/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader;

import org.apache.commons.lang.StringUtils;

public class ContentTypeUtil {
    public static final String EXT_JSON = ".json";
    public static final String TYPE_JSON = "application/json";
    public static final String EXT_XML = ".xml";
    public static final String TYPE_XML = "application/xml";
    public static final String EXT_JCR_XML = ".jcr.xml";
    public static final String TYPE_JCR_XML = "application/x-jcr+xml";
    public static final String EXT_ZIP = ".zip";
    public static final String TYPE_ZIP = "application/zip";
    public static final String EXT_JAR = ".jar";
    public static final String TYPE_JAR = "application/java-archive";

    public static String detectContentType(String filename) {
        if (StringUtils.isNotBlank((String)filename)) {
            if (StringUtils.endsWithIgnoreCase((String)filename, (String)EXT_JSON)) {
                return TYPE_JSON;
            }
            if (StringUtils.endsWithIgnoreCase((String)filename, (String)EXT_JCR_XML)) {
                return TYPE_JCR_XML;
            }
            if (StringUtils.endsWithIgnoreCase((String)filename, (String)EXT_XML)) {
                return TYPE_XML;
            }
            if (StringUtils.endsWithIgnoreCase((String)filename, (String)EXT_ZIP)) {
                return TYPE_ZIP;
            }
            if (StringUtils.endsWithIgnoreCase((String)filename, (String)EXT_JAR)) {
                return TYPE_JAR;
            }
        }
        return null;
    }

    public static String getDefaultExtension(String contentType) {
        if (StringUtils.isNotBlank((String)contentType)) {
            if (TYPE_JSON.equalsIgnoreCase(contentType)) {
                return EXT_JSON;
            }
            if (TYPE_JCR_XML.equalsIgnoreCase(contentType)) {
                return EXT_JCR_XML;
            }
            if (TYPE_XML.equalsIgnoreCase(contentType)) {
                return EXT_XML;
            }
            if (TYPE_ZIP.equalsIgnoreCase(contentType)) {
                return EXT_ZIP;
            }
            if (TYPE_JAR.equalsIgnoreCase(contentType)) {
                return EXT_JAR;
            }
        }
        return null;
    }
}

