/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.jcr.contentloader.internal.BaseImportLoader;
import org.apache.sling.jcr.contentloader.internal.ContentCreator;
import org.apache.sling.jcr.contentloader.internal.ContentLoaderService;
import org.apache.sling.jcr.contentloader.internal.ContentReader;
import org.apache.sling.jcr.contentloader.internal.DefaultContentCreator;
import org.apache.sling.jcr.contentloader.internal.ImportProvider;
import org.apache.sling.jcr.contentloader.internal.PathEntry;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loader
extends BaseImportLoader {
    public static final String ROOT_DESCRIPTOR = "/ROOT";
    private final Logger log = LoggerFactory.getLogger(Loader.class);
    private ContentLoaderService contentLoaderService;
    private List<Bundle> delayedBundles;

    public Loader(ContentLoaderService contentLoaderService) {
        this.contentLoaderService = contentLoaderService;
        this.delayedBundles = new LinkedList<Bundle>();
    }

    @Override
    public void dispose() {
        if (this.delayedBundles != null) {
            this.delayedBundles.clear();
            this.delayedBundles = null;
        }
        this.contentLoaderService = null;
        super.dispose();
    }

    public void registerBundle(Session metadataSession, Bundle bundle, boolean isUpdate) throws RepositoryException {
        if (isUpdate) {
            this.unregisterBundle(metadataSession, bundle);
        }
        this.log.debug("Registering bundle {} for content loading.", (Object)bundle.getSymbolicName());
        if (this.registerBundleInternal(metadataSession, bundle, false, isUpdate)) {
            int currentSize = -1;
            for (int i = this.delayedBundles.size(); i > 0 && currentSize != this.delayedBundles.size() && !this.delayedBundles.isEmpty(); --i) {
                Iterator<Bundle> di = this.delayedBundles.iterator();
                while (di.hasNext()) {
                    Bundle delayed = di.next();
                    if (!this.registerBundleInternal(metadataSession, delayed, true, false)) continue;
                    di.remove();
                }
                currentSize = this.delayedBundles.size();
            }
        } else if (!isUpdate) {
            this.delayedBundles.add(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerBundleInternal(Session metadataSession, Bundle bundle, boolean isRetry, boolean isUpdate) {
        boolean bl;
        Iterator<PathEntry> pathIter = PathEntry.getContentPaths(bundle);
        if (pathIter == null) {
            this.log.debug("Bundle {} has no initial content", (Object)bundle.getSymbolicName());
            return true;
        }
        this.contentLoaderService.createRepositoryPath(metadataSession, "/var/sling/bundle-content");
        Map<String, Object> bundleContentInfo = this.contentLoaderService.getBundleContentInfo(metadataSession, bundle, true);
        if (bundleContentInfo == null) {
            return false;
        }
        boolean success = false;
        List<String> createdNodes = null;
        try {
            boolean contentAlreadyLoaded = (Boolean)bundleContentInfo.get("content-loaded");
            boolean isBundleUpdated = false;
            Calendar lastLoadedAt = (Calendar)bundleContentInfo.get("content-load-time");
            if (lastLoadedAt != null && lastLoadedAt.getTimeInMillis() < bundle.getLastModified()) {
                isBundleUpdated = true;
            }
            if (!isUpdate && !isBundleUpdated && contentAlreadyLoaded) {
                this.log.info("Content of bundle already loaded {}.", (Object)bundle.getSymbolicName());
            } else {
                createdNodes = this.installContent(metadataSession, bundle, pathIter, contentAlreadyLoaded);
                if (isRetry) {
                    this.log.info("Retrying to load initial content for bundle {} succeeded.", (Object)bundle.getSymbolicName());
                }
            }
            success = true;
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                this.contentLoaderService.unlockBundleContentInfo(metadataSession, bundle, success, createdNodes);
                throw throwable;
            }
            catch (RepositoryException re) {
                if (!isRetry) {
                    this.log.error("Cannot load initial content for bundle " + bundle.getSymbolicName() + " : " + re.getMessage(), (Throwable)re);
                }
                return false;
            }
        }
        this.contentLoaderService.unlockBundleContentInfo(metadataSession, bundle, success, createdNodes);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBundle(Session session, Bundle bundle) {
        if (this.delayedBundles.contains(bundle)) {
            this.delayedBundles.remove(bundle);
        } else {
            try {
                this.contentLoaderService.createRepositoryPath(session, "/var/sling/bundle-content");
                Map<String, Object> bundleContentInfo = this.contentLoaderService.getBundleContentInfo(session, bundle, false);
                if (bundleContentInfo == null) {
                    return;
                }
                try {
                    this.uninstallContent(session, bundle, (String[])bundleContentInfo.get("uninstall-paths"));
                    this.contentLoaderService.contentIsUninstalled(session, bundle);
                }
                finally {
                    this.contentLoaderService.unlockBundleContentInfo(session, bundle, false, null);
                }
            }
            catch (RepositoryException re) {
                this.log.error("Cannot remove initial content for bundle " + bundle.getSymbolicName() + " : " + re.getMessage(), (Throwable)re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<String> installContent(Session defaultSession, Bundle bundle, Iterator<PathEntry> pathIter, boolean contentAlreadyLoaded) throws RepositoryException {
        ArrayList<String> createdNodes;
        block22: {
            createdNodes = new ArrayList<String>();
            HashMap<String, Session> createdSessions = new HashMap<String, Session>();
            this.log.debug("Installing initial content from bundle {}", (Object)bundle.getSymbolicName());
            DefaultContentCreator contentCreator = new DefaultContentCreator(this.contentLoaderService);
            while (pathIter.hasNext()) {
                Node targetNode;
                Session targetSession;
                PathEntry entry = pathIter.next();
                if (contentAlreadyLoaded && !entry.isOverwrite()) continue;
                String workspace = entry.getWorkspace();
                if (workspace != null) {
                    if (createdSessions.containsKey(workspace)) {
                        targetSession = (Session)createdSessions.get(workspace);
                    } else {
                        targetSession = this.createSession(workspace);
                        createdSessions.put(workspace, targetSession);
                    }
                } else {
                    targetSession = defaultSession;
                }
                if ((targetNode = this.getTargetNode(targetSession, entry.getTarget())) == null) continue;
                this.installFromPath(bundle, entry.getPath(), entry, targetNode, entry.isUninstall() ? createdNodes : null, contentCreator);
            }
            Collections.sort(createdNodes);
            if (createdNodes.size() > 1) {
                Iterator i = createdNodes.iterator();
                String previous = (String)i.next() + '/';
                while (i.hasNext()) {
                    String current = (String)i.next();
                    if (current.startsWith(previous)) {
                        i.remove();
                        continue;
                    }
                    previous = current + '/';
                }
            }
            defaultSession.refresh(true);
            defaultSession.save();
            for (Session session : createdSessions.values()) {
                session.refresh(true);
                session.save();
            }
            for (Node versionable : contentCreator.getVersionables()) {
                versionable.checkin();
            }
            Object var13_12 = null;
            try {
                if (defaultSession.hasPendingChanges()) {
                    defaultSession.refresh(false);
                }
                for (Session session : createdSessions.values()) {
                    if (!session.hasPendingChanges()) continue;
                    session.refresh(false);
                }
            }
            catch (RepositoryException re) {
                this.log.warn("Failure to rollback partial initial content for bundle {}", (Object)bundle.getSymbolicName(), (Object)re);
            }
            contentCreator.clear();
            for (Session session : createdSessions.values()) {
                session.logout();
            }
            break block22;
            catch (Throwable throwable) {
                Object var13_13 = null;
                try {
                    if (defaultSession.hasPendingChanges()) {
                        defaultSession.refresh(false);
                    }
                    for (Session session : createdSessions.values()) {
                        if (!session.hasPendingChanges()) continue;
                        session.refresh(false);
                    }
                }
                catch (RepositoryException re) {
                    this.log.warn("Failure to rollback partial initial content for bundle {}", (Object)bundle.getSymbolicName(), (Object)re);
                }
                contentCreator.clear();
                for (Session session : createdSessions.values()) {
                    session.logout();
                }
                throw throwable;
            }
        }
        this.log.debug("Done installing initial content from bundle {}", (Object)bundle.getSymbolicName());
        return createdNodes;
    }

    private void installFromPath(Bundle bundle, String path, PathEntry configuration, Node parent, List<String> createdNodes, DefaultContentCreator contentCreator) throws RepositoryException {
        contentCreator.init(configuration, this.defaultImportProviders, createdNodes, null);
        HashMap<String, Node> processedEntries = new HashMap<String, Node>();
        Enumeration entries = bundle.getEntryPaths(path);
        if (entries == null) {
            URL u = bundle.getEntry(path);
            if (u == null) {
                this.log.info("install: No initial content entries at {} in bundle {}", (Object)path, (Object)bundle.getSymbolicName());
                return;
            }
            for (String ext : contentCreator.getImportProviders().keySet()) {
                if (!path.endsWith(ext)) continue;
            }
            this.handleFile(path, bundle, processedEntries, configuration, parent, createdNodes, contentCreator);
            return;
        }
        URL parentNodeDescriptor = this.importParentNode(parent.getSession(), bundle, path, parent, contentCreator);
        if (parentNodeDescriptor != null) {
            processedEntries.put(parentNodeDescriptor.toString(), parent);
        }
        while (entries.hasMoreElements()) {
            String entry = (String)entries.nextElement();
            this.log.debug("Processing initial content entry {} in bundle {}", (Object)entry, (Object)bundle.getSymbolicName());
            if (entry.endsWith("/")) {
                String base = entry.substring(0, entry.length() - 1);
                URL nodeDescriptor = null;
                for (String ext : contentCreator.getImportProviders().keySet()) {
                    nodeDescriptor = bundle.getEntry(base + ext);
                    if (nodeDescriptor == null) continue;
                    break;
                }
                String name = this.getName(base);
                Node node = null;
                if (nodeDescriptor != null) {
                    node = (Node)processedEntries.get(nodeDescriptor);
                    if (node == null) {
                        node = this.createNode(parent, name, nodeDescriptor, configuration, contentCreator);
                        processedEntries.put(nodeDescriptor.toString(), node);
                    }
                } else {
                    node = this.createFolder(parent, name, configuration.isOverwrite());
                }
                if (node == null) continue;
                this.installFromPath(bundle, entry, configuration, node, createdNodes, contentCreator);
                continue;
            }
            this.handleFile(entry, bundle, processedEntries, configuration, parent, createdNodes, contentCreator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFile(String entry, Bundle bundle, Map<String, Node> processedEntries, PathEntry configuration, Node parent, List<String> createdNodes, DefaultContentCreator contentCreator) throws RepositoryException {
        block13: {
            URL file = bundle.getEntry(entry);
            String name = this.getName(entry);
            try {
                if (processedEntries.containsKey(file)) {
                    return;
                }
                URL nodeDescriptor = null;
                for (String ext : contentCreator.getImportProviders().keySet()) {
                    nodeDescriptor = bundle.getEntry(entry + ext);
                    if (nodeDescriptor == null) continue;
                    break;
                }
                boolean foundProvider = contentCreator.getImportProvider(entry) != null;
                Node node = null;
                if (foundProvider) {
                    node = this.createNode(parent, name, file, configuration, contentCreator);
                    if (node != null) {
                        this.log.debug("Created Node as {} {} ", (Object)node.getPath(), (Object)name);
                        processedEntries.put(file.toString(), node);
                    } else {
                        this.log.warn("No Node created for file {} {} ", (Object)file, (Object)name);
                    }
                } else {
                    this.log.debug("Cant find provider for Entry {} at {} ", (Object)entry, (Object)name);
                }
                if (node == null) {
                    try {
                        this.createFile(configuration, parent, file, createdNodes, contentCreator);
                        node = parent.getNode(name);
                    }
                    catch (IOException ioe) {
                        this.log.warn("Cannot create file node for {}", (Object)file, (Object)ioe);
                    }
                }
                if (nodeDescriptor == null || processedEntries.get(nodeDescriptor) != null) break block13;
                try {
                    contentCreator.setIgnoreOverwriteFlag(true);
                    node = this.createNode(parent, name, nodeDescriptor, configuration, contentCreator);
                    processedEntries.put(nodeDescriptor.toString(), node);
                    Object var15_16 = null;
                    contentCreator.setIgnoreOverwriteFlag(false);
                }
                catch (Throwable throwable) {
                    Object var15_17 = null;
                    contentCreator.setIgnoreOverwriteFlag(false);
                    throw throwable;
                }
            }
            catch (RepositoryException e) {
                this.log.error("Failed to process process file {} from {}", (Object)file, (Object)name);
                throw e;
            }
        }
    }

    private Node createNode(Node parent, String name, URL resourceUrl, PathEntry configuration, DefaultContentCreator contentCreator) throws RepositoryException {
        String resourcePath = resourceUrl.getPath().toLowerCase();
        try {
            if (resourcePath.endsWith(".jcr.xml")) {
                return this.importSystemView(parent, name, resourceUrl);
            }
            ImportProvider ip = contentCreator.getImportProvider(resourcePath);
            if (ip == null) {
                return null;
            }
            ContentReader nodeReader = ip.getReader();
            if (nodeReader == null) {
                return null;
            }
            contentCreator.prepareParsing(parent, this.toPlainName(name, contentCreator));
            nodeReader.parse(resourceUrl, (ContentCreator)contentCreator);
            return contentCreator.getCreatedRootNode();
        }
        catch (RepositoryException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RepositoryException(t.getMessage(), t);
        }
    }

    private Node createFolder(Node parent, String name, boolean overwrite) throws RepositoryException {
        if (parent.hasNode(name)) {
            if (overwrite) {
                parent.getNode(name).remove();
            } else {
                return parent.getNode(name);
            }
        }
        return parent.addNode(name, "sling:Folder");
    }

    private void createFile(PathEntry configuration, Node parent, URL source, List<String> createdNodes, DefaultContentCreator contentCreator) throws IOException, RepositoryException {
        String srcPath = source.getPath();
        int pos = srcPath.lastIndexOf("/");
        String name = this.getName(source.getPath());
        String path = pos == -1 ? name : srcPath.substring(0, pos + 1) + name;
        contentCreator.init(configuration, this.defaultImportProviders, createdNodes, null);
        contentCreator.prepareParsing(parent, name);
        URLConnection conn = source.openConnection();
        long lastModified = Math.min(conn.getLastModified(), configuration.getLastModified());
        String type = conn.getContentType();
        InputStream data = conn.getInputStream();
        contentCreator.createFileAndResourceNode(path, data, type, lastModified);
        contentCreator.finishNode();
        contentCreator.finishNode();
    }

    private String getName(String path) {
        String name;
        int lastSlash = path.lastIndexOf(47);
        String string = name = lastSlash < 0 ? path : path.substring(lastSlash + 1);
        if (name.indexOf(37) >= 0) {
            try {
                return URLDecoder.decode(name, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                this.log.error("Cannot decode " + name + " beause the platform has no support for UTF-8, using undecoded");
            }
            catch (Exception e) {
                this.log.error("Cannot decode " + name + ", using undecoded", (Throwable)e);
            }
        }
        return name;
    }

    private Node getTargetNode(Session session, String path) throws RepositoryException {
        if (path == null) {
            return session.getRootNode();
        }
        int firstSlash = path.indexOf("/");
        if (firstSlash != 0) {
            path = "/" + path;
        }
        if (!session.itemExists(path)) {
            Node currentNode = session.getRootNode();
            StringTokenizer st = new StringTokenizer(path.substring(1), "/");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                if (!currentNode.hasNode(name)) {
                    currentNode.addNode(name, "sling:Folder");
                }
                currentNode = currentNode.getNode(name);
            }
            return currentNode;
        }
        Item item = session.getItem(path);
        return item.isNode() ? (Node)item : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void uninstallContent(Session defaultSession, Bundle bundle, String[] uninstallPaths) {
        block27: {
            HashMap<String, Session> createdSessions = new HashMap<String, Session>();
            this.log.debug("Uninstalling initial content from bundle {}", (Object)bundle.getSymbolicName());
            if (uninstallPaths != null && uninstallPaths.length > 0) {
                for (String path : uninstallPaths) {
                    Session targetSession;
                    int wsSepPos = path.indexOf(":/");
                    if (wsSepPos != -1) {
                        String workspaceName = path.substring(0, wsSepPos);
                        path = path.substring(wsSepPos + 1);
                        if (workspaceName.equals(defaultSession.getWorkspace().getName())) {
                            targetSession = defaultSession;
                        } else if (createdSessions.containsKey(workspaceName)) {
                            targetSession = (Session)createdSessions.get(workspaceName);
                        } else {
                            targetSession = this.createSession(workspaceName);
                            createdSessions.put(workspaceName, targetSession);
                        }
                    } else {
                        targetSession = defaultSession;
                    }
                    if (!targetSession.itemExists(path)) continue;
                    targetSession.getItem(path).remove();
                }
                defaultSession.save();
                for (Session session : createdSessions.values()) {
                    session.save();
                }
            }
            this.log.debug("Done uninstalling initial content from bundle {}", (Object)bundle.getSymbolicName());
            Object var13_14 = null;
            try {
                if (defaultSession.hasPendingChanges()) {
                    defaultSession.refresh(false);
                }
                for (Session session : createdSessions.values()) {
                    if (!session.hasPendingChanges()) continue;
                    session.refresh(false);
                }
            }
            catch (RepositoryException re2) {
                this.log.warn("Failure to rollback uninstaling initial content for bundle {}", (Object)bundle.getSymbolicName(), (Object)re2);
            }
            for (Session session : createdSessions.values()) {
                session.logout();
            }
            {
                break block27;
                catch (RepositoryException re) {
                    this.log.error("Unable to uninstall initial content from bundle " + bundle.getSymbolicName(), (Throwable)re);
                    Object var13_15 = null;
                    try {
                        if (defaultSession.hasPendingChanges()) {
                            defaultSession.refresh(false);
                        }
                        for (Session session : createdSessions.values()) {
                            if (!session.hasPendingChanges()) continue;
                            session.refresh(false);
                        }
                    }
                    catch (RepositoryException re2) {
                        this.log.warn("Failure to rollback uninstaling initial content for bundle {}", (Object)bundle.getSymbolicName(), (Object)re2);
                    }
                    for (Session session : createdSessions.values()) {
                        session.logout();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    if (defaultSession.hasPendingChanges()) {
                        defaultSession.refresh(false);
                    }
                    for (Session session : createdSessions.values()) {
                        if (!session.hasPendingChanges()) continue;
                        session.refresh(false);
                    }
                }
                catch (RepositoryException re2) {
                    this.log.warn("Failure to rollback uninstaling initial content for bundle {}", (Object)bundle.getSymbolicName(), (Object)re2);
                }
                for (Session session : createdSessions.values()) {
                    session.logout();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Node importSystemView(Node parent, String name, URL nodeXML) throws IOException {
        Node node;
        InputStream ins;
        block16: {
            block14: {
                Node node2;
                block15: {
                    ins = null;
                    if (name.endsWith(".jcr.xml")) {
                        name = name.substring(0, name.length() - ".jcr.xml".length());
                    }
                    if (!parent.hasNode(name)) break block14;
                    this.log.debug("importSystemView: Node {} for XML {} already exists, nothing to to", (Object)name, (Object)nodeXML);
                    node2 = parent.getNode(name);
                    Object var8_9 = null;
                    if (ins == null) break block15;
                    try {
                        ins.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                return node2;
            }
            ins = nodeXML.openStream();
            Session session = parent.getSession();
            session.importXML(parent.getPath(), ins, 0);
            node = parent.hasNode(name) ? parent.getNode(name) : null;
            Object var8_10 = null;
            if (ins == null) break block16;
            try {
                ins.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return node;
        catch (InvalidSerializedDataException isde) {
            Node node3;
            block17: {
                this.log.info("importSystemView: XML {} does not seem to be system view export, trying old style; cause: {}", (Object)nodeXML, (Object)isde.toString());
                node3 = null;
                Object var8_11 = null;
                if (ins == null) break block17;
                try {
                    ins.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            return node3;
        }
        catch (RepositoryException re) {
            Node node4;
            block18: {
                this.log.info("importSystemView: Repository issue loading XML {}, trying old style; cause: {}", (Object)nodeXML, (Object)re.toString());
                node4 = null;
                Object var8_12 = null;
                if (ins == null) break block18;
                {
                    catch (Throwable throwable) {
                        block19: {
                            Object var8_13 = null;
                            if (ins == null) break block19;
                            try {
                                ins.close();
                            }
                            catch (IOException ignore) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    ins.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            return node4;
        }
    }

    private Descriptor getRootNodeDescriptor(Bundle bundle, String path, DefaultContentCreator contentCreator) {
        URL rootNodeDescriptor = null;
        for (Map.Entry<String, ImportProvider> e : contentCreator.getImportProviders().entrySet()) {
            if (e.getValue() == null || (rootNodeDescriptor = bundle.getEntry(path + ROOT_DESCRIPTOR + e.getKey())) == null) continue;
            try {
                Descriptor d = new Descriptor();
                d.rootNodeDescriptor = rootNodeDescriptor;
                d.nodeReader = e.getValue().getReader();
                return d;
            }
            catch (IOException ioe) {
                this.log.error("Unable to setup node reader for " + e.getKey(), (Throwable)ioe);
                return null;
            }
        }
        return null;
    }

    private URL importParentNode(Session session, Bundle bundle, String path, Node parent, DefaultContentCreator contentCreator) throws RepositoryException {
        Descriptor descriptor = this.getRootNodeDescriptor(bundle, path, contentCreator);
        if (descriptor == null) {
            return null;
        }
        try {
            contentCreator.prepareParsing(parent, null);
            descriptor.nodeReader.parse(descriptor.rootNodeDescriptor, (ContentCreator)contentCreator);
            return descriptor.rootNodeDescriptor;
        }
        catch (RepositoryException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RepositoryException(t.getMessage(), t);
        }
    }

    private String toPlainName(String name, DefaultContentCreator contentCreator) {
        String providerExt = contentCreator.getImportProviderExtension(name);
        if (providerExt != null) {
            return name.substring(0, name.length() - providerExt.length());
        }
        return name;
    }

    private Session createSession(String workspace) throws RepositoryException {
        try {
            return this.contentLoaderService.getRepository().loginAdministrative(workspace);
        }
        catch (NoSuchWorkspaceException e) {
            Session temp = this.contentLoaderService.getRepository().loginAdministrative(null);
            temp.getWorkspace().createWorkspace(workspace);
            temp.logout();
            return this.contentLoaderService.getRepository().loginAdministrative(workspace);
        }
    }

    protected static final class Descriptor {
        public URL rootNodeDescriptor;
        public ContentReader nodeReader;

        protected Descriptor() {
        }
    }
}

