/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.jcr.contentloader.ContentImportListener;
import org.apache.sling.jcr.contentloader.ContentImporter;
import org.apache.sling.jcr.contentloader.ImportOptions;
import org.apache.sling.jcr.contentloader.internal.BaseImportLoader;
import org.apache.sling.jcr.contentloader.internal.ContentCreator;
import org.apache.sling.jcr.contentloader.internal.ContentReader;
import org.apache.sling.jcr.contentloader.internal.DefaultContentCreator;
import org.apache.sling.jcr.contentloader.internal.ImportProvider;
import org.apache.sling.jcr.contentloader.internal.JcrContentHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.description", value={"Apache Sling JCR Content Import Service"})})
@Service(value={ContentImporter.class})
public class DefaultContentImporter
extends BaseImportLoader
implements JcrContentHelper,
ContentImporter {
    private final Logger log = LoggerFactory.getLogger(DefaultContentImporter.class);
    @Reference
    private MimeTypeService mimeTypeService;

    public void importContent(Node parent, String name, InputStream contentStream, ImportOptions importOptions, ContentImportListener importListener) throws RepositoryException, IOException {
        if (name.endsWith(".jcr.xml")) {
            boolean replace = importOptions == null ? false : importOptions.isOverwrite();
            Node node = this.importSystemView(parent, name, contentStream, replace);
            if (node != null && importListener != null) {
                importListener.onCreate(node.getPath());
            }
            return;
        }
        DefaultContentCreator contentCreator = new DefaultContentCreator(this);
        ArrayList<String> createdPaths = new ArrayList<String>();
        contentCreator.init(importOptions, this.defaultImportProviders, createdPaths, importListener);
        contentCreator.prepareParsing(parent, this.toPlainName(contentCreator, name));
        ImportProvider ip = contentCreator.getImportProvider(name);
        ContentReader reader = ip.getReader();
        reader.parse(contentStream, (ContentCreator)contentCreator);
        Session session = parent.getSession();
        session.save();
        for (Node versionable : contentCreator.getVersionables()) {
            versionable.checkin();
            if (importListener == null) continue;
            importListener.onCheckin(versionable.getPath());
        }
    }

    private String toPlainName(DefaultContentCreator contentCreator, String name) {
        String providerExt = contentCreator.getImportProviderExtension(name);
        if (providerExt != null) {
            if (name.length() == providerExt.length()) {
                return null;
            }
            return name.substring(0, name.length() - providerExt.length());
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Node importSystemView(Node parent, String name, InputStream contentStream, boolean replace) throws IOException {
        Node node;
        Node node2;
        InputStream ins;
        block17: {
            String nodeName;
            block15: {
                Node node3;
                block16: {
                    ins = null;
                    String string = nodeName = name.endsWith(".jcr.xml") ? name.substring(0, name.length() - ".jcr.xml".length()) : name;
                    if (nodeName.length() == 0) {
                        throw new IOException("Node name must not be empty (or extension only)");
                    }
                    if (!parent.hasNode(nodeName)) break block15;
                    Node existingNode = parent.getNode(nodeName);
                    if (replace) {
                        this.log.debug("importSystemView: Removing existing node at {}", (Object)nodeName);
                        existingNode.remove();
                        break block15;
                    }
                    this.log.debug("importSystemView: Node {} for XML already exists, nothing to to", (Object)nodeName);
                    node3 = existingNode;
                    Object var11_13 = null;
                    if (ins == null) break block16;
                    try {
                        ins.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                return node3;
            }
            int uuidBehavior = replace ? 2 : 0;
            ins = contentStream;
            Session session = parent.getSession();
            session.importXML(parent.getPath(), ins, uuidBehavior);
            node2 = parent.hasNode(nodeName) ? parent.getNode(nodeName) : null;
            Object var11_14 = null;
            if (ins == null) break block17;
            try {
                ins.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return node2;
        catch (InvalidSerializedDataException isde) {
            block18: {
                this.log.info("importSystemView: XML does not seem to be system view export; cause: {}", (Object)isde.toString());
                node = null;
                Object var11_15 = null;
                if (ins == null) break block18;
                try {
                    ins.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            return node;
        }
        catch (RepositoryException re) {
            block19: {
                this.log.info("importSystemView: Repository issue loading XML; cause: {}", (Object)re.toString());
                node = null;
                Object var11_16 = null;
                if (ins == null) break block19;
                {
                    catch (Throwable throwable) {
                        block20: {
                            Object var11_17 = null;
                            if (ins == null) break block20;
                            try {
                                ins.close();
                            }
                            catch (IOException ignore) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    ins.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            return node;
        }
    }

    public String getMimeType(String name) {
        MimeTypeService mts = this.mimeTypeService;
        return mts != null ? mts.getMimeType(name) : null;
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }
}

