/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal.readers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.RepositoryException;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.sling.jcr.contentloader.internal.ContentCreator;
import org.apache.sling.jcr.contentloader.internal.ContentReader;
import org.apache.sling.jcr.contentloader.internal.ImportProvider;

public class ZipReader
implements ContentReader {
    private static final String NT_FOLDER = "nt:folder";
    public static final ImportProvider ZIP_PROVIDER = new ImportProvider(){
        private ZipReader zipReader;

        public ContentReader getReader() {
            if (this.zipReader == null) {
                this.zipReader = new ZipReader(false);
            }
            return this.zipReader;
        }
    };
    public static final ImportProvider JAR_PROVIDER = new ImportProvider(){
        private ZipReader zipReader;

        public ContentReader getReader() {
            if (this.zipReader == null) {
                this.zipReader = new ZipReader(true);
            }
            return this.zipReader;
        }
    };

    public ZipReader(boolean jarReader) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(URL url, ContentCreator creator) throws IOException, RepositoryException {
        InputStream ins = null;
        try {
            ZipEntry entry;
            ins = url.openStream();
            creator.createNode(null, NT_FOLDER, null);
            ZipInputStream zis = new ZipInputStream(ins);
            do {
                if ((entry = zis.getNextEntry()) == null) continue;
                if (!entry.isDirectory()) {
                    String name = entry.getName();
                    int pos = name.lastIndexOf(47);
                    if (pos != -1) {
                        creator.switchCurrentNode(name.substring(0, pos), NT_FOLDER);
                    }
                    creator.createFileAndResourceNode(name, (InputStream)new CloseShieldInputStream((InputStream)zis), null, entry.getTime());
                    creator.finishNode();
                    creator.finishNode();
                    if (pos != -1) {
                        creator.finishNode();
                    }
                }
                zis.closeEntry();
            } while (entry != null);
            creator.finishNode();
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

