/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.jcr.contentloader.internal.ContentLoaderService;
import org.apache.sling.jcr.contentloader.internal.ContentReader;
import org.apache.sling.jcr.contentloader.internal.DefaultContentCreator;
import org.apache.sling.jcr.contentloader.internal.ImportProvider;
import org.apache.sling.jcr.contentloader.internal.PathEntry;
import org.apache.sling.jcr.contentloader.internal.readers.JsonReader;
import org.apache.sling.jcr.contentloader.internal.readers.XmlReader;
import org.apache.sling.jcr.contentloader.internal.readers.ZipReader;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loader {
    public static final String EXT_XML = ".xml";
    public static final String EXT_JCR_XML = ".jcr.xml";
    public static final String EXT_JSON = ".json";
    public static final String EXT_JAR = ".jar";
    public static final String EXT_ZIP = ".zip";
    public static final String ROOT_DESCRIPTOR = "/ROOT";
    private final Logger log = LoggerFactory.getLogger(Loader.class);
    private ContentLoaderService jcrContentHelper;
    private Map<String, ImportProvider> defaultImportProviders;
    private final DefaultContentCreator contentCreator;
    private List<Bundle> delayedBundles;

    public Loader(ContentLoaderService jcrContentHelper) {
        this.jcrContentHelper = jcrContentHelper;
        this.contentCreator = new DefaultContentCreator(jcrContentHelper);
        this.delayedBundles = new LinkedList<Bundle>();
        this.defaultImportProviders = new LinkedHashMap<String, ImportProvider>();
        this.defaultImportProviders.put(EXT_JCR_XML, null);
        this.defaultImportProviders.put(EXT_JSON, JsonReader.PROVIDER);
        this.defaultImportProviders.put(EXT_XML, XmlReader.PROVIDER);
        this.defaultImportProviders.put(EXT_JAR, ZipReader.JAR_PROVIDER);
        this.defaultImportProviders.put(EXT_ZIP, ZipReader.ZIP_PROVIDER);
    }

    public void dispose() {
        if (this.delayedBundles != null) {
            this.delayedBundles.clear();
            this.delayedBundles = null;
        }
        this.jcrContentHelper = null;
        this.defaultImportProviders = null;
    }

    public void registerBundle(Session session, Bundle bundle, boolean isUpdate) {
        if (isUpdate) {
            this.unregisterBundle(session, bundle);
        }
        this.log.debug("Registering bundle {} for content loading.", (Object)bundle.getSymbolicName());
        if (this.registerBundleInternal(session, bundle, false, isUpdate)) {
            int currentSize = -1;
            for (int i = this.delayedBundles.size(); i > 0 && currentSize != this.delayedBundles.size() && !this.delayedBundles.isEmpty(); --i) {
                Iterator<Bundle> di = this.delayedBundles.iterator();
                while (di.hasNext()) {
                    Bundle delayed = di.next();
                    if (!this.registerBundleInternal(session, delayed, true, false)) continue;
                    di.remove();
                }
                currentSize = this.delayedBundles.size();
            }
        } else if (!isUpdate) {
            this.delayedBundles.add(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerBundleInternal(Session session, Bundle bundle, boolean isRetry, boolean isUpdate) {
        boolean bl;
        Iterator<PathEntry> pathIter = PathEntry.getContentPaths(bundle);
        if (pathIter == null) {
            this.log.debug("Bundle {} has no initial content", (Object)bundle.getSymbolicName());
            return true;
        }
        Map<String, Object> bundleContentInfo = this.jcrContentHelper.getBundleContentInfo(session, bundle, true);
        if (bundleContentInfo == null) {
            return false;
        }
        boolean success = false;
        List<String> createdNodes = null;
        try {
            boolean contentAlreadyLoaded = (Boolean)bundleContentInfo.get("content-loaded");
            if (!isUpdate && contentAlreadyLoaded) {
                this.log.info("Content of bundle already loaded {}.", (Object)bundle.getSymbolicName());
            } else {
                createdNodes = this.installContent(session, bundle, pathIter, contentAlreadyLoaded);
                if (isRetry) {
                    this.log.info("Retrytring to load initial content for bundle {} succeeded.", (Object)bundle.getSymbolicName());
                }
            }
            success = true;
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                this.jcrContentHelper.unlockBundleContentInfo(session, bundle, success, createdNodes);
                throw throwable;
            }
            catch (RepositoryException re) {
                if (!isRetry) {
                    this.log.error("Cannot load initial content for bundle " + bundle.getSymbolicName() + " : " + re.getMessage(), (Throwable)re);
                }
                return false;
            }
        }
        this.jcrContentHelper.unlockBundleContentInfo(session, bundle, success, createdNodes);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBundle(Session session, Bundle bundle) {
        if (this.delayedBundles.contains(bundle)) {
            this.delayedBundles.remove(bundle);
        } else {
            try {
                Map<String, Object> bundleContentInfo = this.jcrContentHelper.getBundleContentInfo(session, bundle, false);
                if (bundleContentInfo == null) {
                    return;
                }
                try {
                    this.uninstallContent(session, bundle, (String[])bundleContentInfo.get("uninstall-paths"));
                    this.jcrContentHelper.contentIsUninstalled(session, bundle);
                }
                finally {
                    this.jcrContentHelper.unlockBundleContentInfo(session, bundle, false, null);
                }
            }
            catch (RepositoryException re) {
                this.log.error("Cannot remove initial content for bundle " + bundle.getSymbolicName() + " : " + re.getMessage(), (Throwable)re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> installContent(Session session, Bundle bundle, Iterator<PathEntry> pathIter, boolean contentAlreadyLoaded) throws RepositoryException {
        ArrayList<String> createdNodes = new ArrayList<String>();
        this.log.debug("Installing initial content from bundle {}", (Object)bundle.getSymbolicName());
        try {
            while (pathIter.hasNext()) {
                Node targetNode;
                PathEntry entry = pathIter.next();
                if (contentAlreadyLoaded && !entry.isOverwrite() || (targetNode = this.getTargetNode(session, entry.getTarget())) == null) continue;
                this.installFromPath(bundle, entry.getPath(), entry, targetNode, entry.isUninstall() ? createdNodes : null);
            }
            Collections.sort(createdNodes);
            if (createdNodes.size() > 1) {
                Iterator i = createdNodes.iterator();
                String previous = (String)i.next() + '/';
                while (i.hasNext()) {
                    String current = (String)i.next();
                    if (current.startsWith(previous)) {
                        i.remove();
                        continue;
                    }
                    previous = current + '/';
                }
            }
            session.refresh(true);
            session.save();
            for (Node versionable : this.contentCreator.getVersionables()) {
                versionable.checkin();
            }
        }
        finally {
            try {
                if (session.hasPendingChanges()) {
                    session.refresh(false);
                }
            }
            catch (RepositoryException re) {
                this.log.warn("Failure to rollback partial initial content for bundle {}", (Object)bundle.getSymbolicName(), (Object)re);
            }
            this.contentCreator.clear();
        }
        this.log.debug("Done installing initial content from bundle {}", (Object)bundle.getSymbolicName());
        return createdNodes;
    }

    private void installFromPath(Bundle bundle, String path, PathEntry configuration, Node parent, List<String> createdNodes) throws RepositoryException {
        this.contentCreator.init(configuration, this.defaultImportProviders, createdNodes);
        HashMap<URL, Node> processedEntries = new HashMap<URL, Node>();
        Enumeration entries = bundle.getEntryPaths(path);
        if (entries == null) {
            URL u = bundle.getEntry(path);
            if (u == null) {
                this.log.info("install: No initial content entries at {} in bundle {}", (Object)path, (Object)bundle.getSymbolicName());
                return;
            }
            for (String ext : this.contentCreator.getImportProviders().keySet()) {
                if (!path.endsWith(ext)) continue;
            }
            this.handleFile(path, bundle, processedEntries, configuration, parent, createdNodes);
            return;
        }
        URL rootNodeDescriptor = this.importRootNode(parent.getSession(), bundle, path);
        if (rootNodeDescriptor != null) {
            processedEntries.put(rootNodeDescriptor, parent.getSession().getRootNode());
        }
        while (entries.hasMoreElements()) {
            String entry = (String)entries.nextElement();
            this.log.debug("Processing initial content entry {} in bundle {}", (Object)entry, (Object)bundle.getSymbolicName());
            if (entry.endsWith("/")) {
                String base = entry.substring(0, entry.length() - 1);
                URL nodeDescriptor = null;
                for (String ext : this.contentCreator.getImportProviders().keySet()) {
                    nodeDescriptor = bundle.getEntry(base + ext);
                    if (nodeDescriptor == null) continue;
                    break;
                }
                String name = this.getName(base);
                Node node = null;
                if (nodeDescriptor != null) {
                    node = (Node)processedEntries.get(nodeDescriptor);
                    if (node == null) {
                        node = this.createNode(parent, name, nodeDescriptor, configuration);
                        processedEntries.put(nodeDescriptor, node);
                    }
                } else {
                    node = this.createFolder(parent, name, configuration.isOverwrite());
                }
                if (node == null) continue;
                this.installFromPath(bundle, entry, configuration, node, createdNodes);
                continue;
            }
            this.handleFile(entry, bundle, processedEntries, configuration, parent, createdNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFile(String entry, Bundle bundle, Map<URL, Node> processedEntries, PathEntry configuration, Node parent, List<String> createdNodes) throws RepositoryException {
        URL file = bundle.getEntry(entry);
        String name = this.getName(entry);
        if (processedEntries.containsKey(file)) {
            return;
        }
        URL nodeDescriptor = null;
        for (String ext : this.contentCreator.getImportProviders().keySet()) {
            nodeDescriptor = bundle.getEntry(entry + ext);
            if (nodeDescriptor == null) continue;
            break;
        }
        boolean foundProvider = this.contentCreator.getImportProvider(entry) != null;
        Node node = null;
        if (foundProvider && (node = this.createNode(parent, name, file, configuration)) != null) {
            processedEntries.put(file, node);
        }
        if (node == null) {
            try {
                this.createFile(configuration, parent, file, createdNodes);
                node = parent.getNode(name);
            }
            catch (IOException ioe) {
                this.log.warn("Cannot create file node for {}", (Object)file, (Object)ioe);
            }
        }
        if (nodeDescriptor != null && processedEntries.get(nodeDescriptor) == null) {
            try {
                this.contentCreator.setIgnoreOverwriteFlag(true);
                node = this.createNode(parent, name, nodeDescriptor, configuration);
                processedEntries.put(nodeDescriptor, node);
            }
            finally {
                this.contentCreator.setIgnoreOverwriteFlag(false);
            }
        }
    }

    private Node createNode(Node parent, String name, URL resourceUrl, PathEntry configuration) throws RepositoryException {
        String resourcePath = resourceUrl.getPath().toLowerCase();
        try {
            if (resourcePath.endsWith(EXT_JCR_XML)) {
                return this.importSystemView(parent, name, resourceUrl);
            }
            ImportProvider ip = this.contentCreator.getImportProvider(resourcePath);
            if (ip == null) {
                return null;
            }
            ContentReader nodeReader = ip.getReader();
            if (nodeReader == null) {
                return null;
            }
            this.contentCreator.prepareParsing(parent, this.toPlainName(name));
            nodeReader.parse(resourceUrl, this.contentCreator);
            return this.contentCreator.getRootNode();
        }
        catch (RepositoryException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RepositoryException(t.getMessage(), t);
        }
    }

    private Node createFolder(Node parent, String name, boolean overwrite) throws RepositoryException {
        if (parent.hasNode(name)) {
            if (overwrite) {
                parent.getNode(name).remove();
            } else {
                return parent.getNode(name);
            }
        }
        return parent.addNode(name, "sling:Folder");
    }

    private void createFile(PathEntry configuration, Node parent, URL source, List<String> createdNodes) throws IOException, RepositoryException {
        String srcPath = source.getPath();
        int pos = srcPath.lastIndexOf("/");
        String name = this.getName(source.getPath());
        String path = pos == -1 ? name : srcPath.substring(0, pos + 1) + name;
        this.contentCreator.init(configuration, this.defaultImportProviders, createdNodes);
        this.contentCreator.prepareParsing(parent, name);
        URLConnection conn = source.openConnection();
        long lastModified = conn.getLastModified();
        String type = conn.getContentType();
        InputStream data = conn.getInputStream();
        this.contentCreator.createFileAndResourceNode(path, data, type, lastModified);
        this.contentCreator.finishNode();
        this.contentCreator.finishNode();
    }

    private String getName(String path) {
        String name;
        int lastSlash = path.lastIndexOf(47);
        String string = name = lastSlash < 0 ? path : path.substring(lastSlash + 1);
        if (name.indexOf(37) >= 0) {
            try {
                return URLDecoder.decode(name, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                this.log.error("Cannot decode " + name + " beause the platform has no support for UTF-8, using undecoded");
            }
            catch (Exception e) {
                this.log.error("Cannot decode " + name + ", using undecoded", (Throwable)e);
            }
        }
        return name;
    }

    private Node getTargetNode(Session session, String path) throws RepositoryException {
        if (path == null) {
            return session.getRootNode();
        }
        int firstSlash = path.indexOf("/");
        if (firstSlash != 0) {
            path = "/" + path;
        }
        if (!session.itemExists(path)) {
            Node currentNode = session.getRootNode();
            StringTokenizer st = new StringTokenizer(path.substring(1), "/");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                if (!currentNode.hasNode(name)) {
                    currentNode.addNode(name, "sling:Folder");
                }
                currentNode = currentNode.getNode(name);
            }
            return currentNode;
        }
        Item item = session.getItem(path);
        return item.isNode() ? (Node)item : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallContent(Session session, Bundle bundle, String[] uninstallPaths) {
        try {
            this.log.debug("Uninstalling initial content from bundle {}", (Object)bundle.getSymbolicName());
            if (uninstallPaths != null && uninstallPaths.length > 0) {
                for (String path : uninstallPaths) {
                    if (!session.itemExists(path)) continue;
                    session.getItem(path).remove();
                }
                session.save();
            }
            this.log.debug("Done uninstalling initial content from bundle {}", (Object)bundle.getSymbolicName());
        }
        catch (RepositoryException re) {
            this.log.error("Unable to uninstall initial content from bundle " + bundle.getSymbolicName(), (Throwable)re);
        }
        finally {
            try {
                if (session.hasPendingChanges()) {
                    session.refresh(false);
                }
            }
            catch (RepositoryException re) {
                this.log.warn("Failure to rollback uninstaling initial content for bundle {}", (Object)bundle.getSymbolicName(), (Object)re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node importSystemView(Node parent, String name, URL nodeXML) throws IOException {
        Node node;
        InputStream ins = null;
        try {
            if (name.endsWith(EXT_JCR_XML)) {
                name = name.substring(0, name.length() - EXT_JCR_XML.length());
            }
            if (parent.hasNode(name)) {
                this.log.debug("importSystemView: Node {} for XML {} already exists, nothing to to", (Object)name, (Object)nodeXML);
                Node node2 = parent.getNode(name);
                return node2;
            }
            ins = nodeXML.openStream();
            Session session = parent.getSession();
            session.importXML(parent.getPath(), ins, 0);
            node = parent.hasNode(name) ? parent.getNode(name) : null;
        }
        catch (InvalidSerializedDataException isde) {
            this.log.info("importSystemView: XML {} does not seem to be system view export, trying old style; cause: {}", (Object)nodeXML, (Object)isde.toString());
            Node node3 = null;
            return node3;
        }
        catch (RepositoryException re) {
            this.log.info("importSystemView: Repository issue loading XML {}, trying old style; cause: {}", (Object)nodeXML, (Object)re.toString());
            Node node4 = null;
            return node4;
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ignore) {}
            }
        }
        return node;
    }

    private Descriptor getRootNodeDescriptor(Bundle bundle, String path) {
        URL rootNodeDescriptor = null;
        for (Map.Entry<String, ImportProvider> e : this.contentCreator.getImportProviders().entrySet()) {
            if (e.getValue() == null || (rootNodeDescriptor = bundle.getEntry(path + ROOT_DESCRIPTOR + e.getKey())) == null) continue;
            try {
                Descriptor d = new Descriptor();
                d.rootNodeDescriptor = rootNodeDescriptor;
                d.nodeReader = e.getValue().getReader();
                return d;
            }
            catch (IOException ioe) {
                this.log.error("Unable to setup node reader for " + e.getKey(), (Throwable)ioe);
                return null;
            }
        }
        return null;
    }

    private URL importRootNode(Session session, Bundle bundle, String path) throws RepositoryException {
        Descriptor descriptor = this.getRootNodeDescriptor(bundle, path);
        if (descriptor == null) {
            return null;
        }
        try {
            this.contentCreator.prepareParsing(session.getRootNode(), null);
            descriptor.nodeReader.parse(descriptor.rootNodeDescriptor, this.contentCreator);
            return descriptor.rootNodeDescriptor;
        }
        catch (RepositoryException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RepositoryException(t.getMessage(), t);
        }
    }

    private String toPlainName(String name) {
        String providerExt = this.contentCreator.getImportProviderExtension(name);
        if (providerExt != null) {
            return name.substring(0, name.length() - providerExt.length());
        }
        return name;
    }

    protected static final class Descriptor {
        public URL rootNodeDescriptor;
        public ContentReader nodeReader;

        protected Descriptor() {
        }
    }
}

