/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.json;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.felix.cm.json.ConfigurationReader;
import org.apache.felix.cm.json.ConfigurationResource;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionState;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.MatchingRequirement;
import org.apache.sling.feature.Prototype;
import org.apache.sling.feature.impl.felix.utils.resource.CapabilityImpl;
import org.apache.sling.feature.impl.felix.utils.resource.RequirementImpl;
import org.apache.sling.feature.io.json.JSONConstants;
import org.apache.sling.feature.io.json.ManifestUtils;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public class FeatureJSONReader {
    private Feature feature;
    private final String location;
    private final String exceptionPrefix;

    public static Feature read(Reader reader, String location) throws IOException {
        try {
            FeatureJSONReader mr = new FeatureJSONReader(location);
            return mr.readFeature(reader);
        }
        catch (IllegalArgumentException | IllegalStateException | JsonException e) {
            throw new IOException(e);
        }
    }

    private FeatureJSONReader(String location) {
        this.location = location;
        this.exceptionPrefix = location == null ? "" : location.concat(" : ");
    }

    private ArtifactId getFeatureId(JsonObject json) throws IOException {
        if (!json.containsKey((Object)"id")) {
            throw new IOException(this.exceptionPrefix.concat("Feature id is missing"));
        }
        return this.checkTypeArtifactId("id", (JsonValue)json.get((Object)"id"));
    }

    private String getProperty(JsonObject json, String key) throws IOException {
        JsonValue val = (JsonValue)json.get((Object)key);
        if (val != null) {
            return this.checkTypeString(key, val);
        }
        return null;
    }

    private void readVariables(JsonObject json, Map<String, String> kvMap) throws IOException {
        if (json.containsKey((Object)"variables")) {
            JsonValue variablesObj = (JsonValue)json.get((Object)"variables");
            for (Map.Entry entry : this.checkTypeObject("variables", variablesObj).entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith("#")) continue;
                if (kvMap.get(key) != null) {
                    throw new IOException(this.exceptionPrefix.concat("Duplicate variable ").concat(key));
                }
                String value = this.checkScalarType("variable value", (JsonValue)entry.getValue(), true);
                kvMap.put(key, value);
            }
        }
    }

    private void readBundles(JsonObject json, Bundles container, Configurations configContainer) throws IOException {
        if (json.containsKey((Object)"bundles")) {
            ArrayList<Artifact> list = new ArrayList<Artifact>();
            this.readArtifacts("bundles", "bundle", list, (JsonValue)json.get((Object)"bundles"), configContainer);
            for (Artifact a : list) {
                if (container.containsExact(a.getId())) {
                    throw new IOException(this.exceptionPrefix + "Duplicate identical bundle " + a.getId().toMvnId());
                }
                try {
                    a.getStartOrder();
                }
                catch (IllegalArgumentException nfe) {
                    throw new IOException(this.exceptionPrefix + "Illegal start order '" + a.getMetadata().get("start-order") + "'");
                }
                container.add(a);
            }
        }
    }

    private void readArtifacts(String section, String artifactType, List<Artifact> artifacts, JsonValue listObj, Configurations container) throws IOException {
        for (JsonValue entry : this.checkTypeArray(section, listObj)) {
            Artifact artifact;
            this.checkTypeObjectOrString(artifactType, entry);
            if (entry.getValueType() == JsonValue.ValueType.STRING) {
                if (((JsonString)entry).getString().startsWith("#")) continue;
                artifact = new Artifact(this.checkTypeArtifactId(artifactType, entry));
            } else {
                JsonObject bundleObj = (JsonObject)entry;
                if (!bundleObj.containsKey((Object)"id")) {
                    throw new IOException(this.exceptionPrefix.concat(" ").concat(artifactType).concat(" is missing required artifact id"));
                }
                ArtifactId id = this.checkTypeArtifactId(artifactType.concat(" ").concat("id"), (JsonValue)bundleObj.get((Object)"id"));
                artifact = new Artifact(id);
                for (Map.Entry metadataEntry : bundleObj.entrySet()) {
                    String key = (String)metadataEntry.getKey();
                    if (key.startsWith("#") || JSONConstants.ARTIFACT_KNOWN_PROPERTIES.contains(key)) continue;
                    String mval = this.checkScalarType(artifactType.concat(" metadata ").concat(key), (JsonValue)metadataEntry.getValue(), false);
                    artifact.getMetadata().put(key, mval);
                }
                if (bundleObj.containsKey((Object)"configurations")) {
                    JsonObject cfgs = this.checkTypeObject(artifactType.concat(" configurations"), (JsonValue)bundleObj.get((Object)"configurations"));
                    this.addConfigurations(cfgs, artifact, container);
                }
            }
            artifacts.add(artifact);
        }
    }

    private void addConfigurations(JsonObject json, Artifact artifact, final Configurations container) throws IOException {
        ConfigurationReader reader = org.apache.felix.cm.json.Configurations.buildReader().verifyAsBundleResource(true).withIdentifier(this.location).withConfiguratorPropertyHandler(new ConfigurationReader.ConfiguratorPropertyHandler(){

            public void handleConfiguratorProperty(String pid, String property, Object value) {
                Configuration cfg = container.getConfiguration(pid);
                if (cfg == null) {
                    cfg = new Configuration(pid);
                    container.add(cfg);
                }
                cfg.getProperties().put(":configurator:".concat(property), value);
            }
        }).build(json);
        ConfigurationResource rsrc = reader.readConfigurationResource();
        if (!reader.getIgnoredErrors().isEmpty()) {
            StringBuilder builder = new StringBuilder(this.exceptionPrefix);
            builder.append("Errors in configurations:");
            for (String w : reader.getIgnoredErrors()) {
                builder.append("\n");
                builder.append(w);
            }
            throw new IOException(builder.toString());
        }
        for (Map.Entry c : rsrc.getConfigurations().entrySet()) {
            Configuration config = container.getConfiguration((String)c.getKey());
            if (config == null) {
                config = new Configuration((String)c.getKey());
                container.add(config);
            }
            for (Map.Entry prop : ((Hashtable)c.getValue()).entrySet()) {
                config.getProperties().put((String)prop.getKey(), prop.getValue());
            }
            if (config.getProperties().get(":configurator:feature-service.bundleLocation") != null) {
                throw new IOException(this.exceptionPrefix.concat("Configuration must not define property ").concat(":configurator:feature-service.bundleLocation"));
            }
            if (artifact == null) continue;
            config.getProperties().put(":configurator:feature-service.bundleLocation", artifact.getId().toMvnId());
        }
    }

    private void readConfigurations(JsonObject json, Configurations container) throws IOException {
        if (json.containsKey((Object)"configurations")) {
            JsonObject cfgs = this.checkTypeObject("configurations", (JsonValue)json.get((Object)"configurations"));
            this.addConfigurations(cfgs, null, container);
        }
    }

    private void readFrameworkProperties(JsonObject json, Map<String, String> container) throws IOException {
        if (json.containsKey((Object)"framework-properties")) {
            JsonValue propsObj = (JsonValue)json.get((Object)"framework-properties");
            for (Map.Entry entry : this.checkTypeObject("framework-properties", propsObj).entrySet()) {
                if (((String)entry.getKey()).startsWith("#")) continue;
                if (container.get(entry.getKey()) != null) {
                    throw new IOException(this.exceptionPrefix.concat("Duplicate framework property ").concat((String)entry.getKey()));
                }
                String value = this.checkScalarType("framework property value", (JsonValue)entry.getValue(), false);
                container.put((String)entry.getKey(), value);
            }
        }
    }

    private void readExtensions(JsonObject json, List<String> keywords, Extensions container, Configurations configContainer) throws IOException {
        HashSet keySet = new HashSet(json.keySet());
        keySet.removeAll(keywords);
        for (String key : keySet) {
            boolean opt;
            String state;
            String name;
            String type;
            int sep;
            if (key.startsWith("#")) continue;
            int pos = key.indexOf(58);
            String postfix = pos == -1 ? null : key.substring(pos + 1);
            int n = sep = postfix == null ? key.indexOf(124) : postfix.indexOf(124);
            if (pos == -1) {
                type = ExtensionType.ARTIFACTS.name();
                if (sep == -1) {
                    name = key;
                    state = ExtensionState.OPTIONAL.name();
                } else {
                    name = key.substring(0, sep);
                    state = key.substring(sep + 1);
                }
            } else {
                name = key.substring(0, pos);
                if (sep == -1) {
                    type = postfix;
                    state = ExtensionState.OPTIONAL.name();
                } else {
                    type = postfix.substring(0, sep);
                    state = postfix.substring(sep + 1);
                }
            }
            if (JSONConstants.FEATURE_KNOWN_PROPERTIES.contains(name)) {
                throw new IOException(this.exceptionPrefix.concat("Extension is using reserved name : ").concat(name));
            }
            if (container.getByName(name) != null) {
                throw new IOException(this.exceptionPrefix.concat("Duplicate extension with name ").concat(name));
            }
            ExtensionType extType = ExtensionType.valueOf(type);
            ExtensionState extState = ExtensionState.OPTIONAL.name().equalsIgnoreCase(state) ? ExtensionState.OPTIONAL : (ExtensionState.REQUIRED.name().equalsIgnoreCase(state) ? ExtensionState.REQUIRED : (ExtensionState.TRANSIENT.name().equalsIgnoreCase(state) ? ExtensionState.TRANSIENT : ((opt = Boolean.valueOf(state).booleanValue()) ? ExtensionState.REQUIRED : ExtensionState.OPTIONAL)));
            Extension ext = new Extension(extType, name, extState);
            JsonValue value = (JsonValue)json.get((Object)key);
            switch (extType) {
                case ARTIFACTS: {
                    ArrayList<Artifact> list = new ArrayList<Artifact>();
                    this.readArtifacts("Extension ".concat(name), "artifact", list, value, configContainer);
                    for (Artifact a : list) {
                        if (ext.getArtifacts().contains(a)) {
                            throw new IOException(this.exceptionPrefix.concat("Duplicate artifact in extension ").concat(name).concat(" : ").concat(a.getId().toMvnId()));
                        }
                        ext.getArtifacts().add(a);
                    }
                    break;
                }
                case JSON: {
                    if (value.getValueType() != JsonValue.ValueType.ARRAY && value.getValueType() != JsonValue.ValueType.OBJECT) {
                        throw new IOException(this.exceptionPrefix.concat("JSON Extension ").concat(name).concat(" is neither an object nor an array : ").concat(value.getValueType().name()));
                    }
                    ext.setJSONStructure((JsonStructure)value);
                    break;
                }
                case TEXT: {
                    if (value.getValueType() != JsonValue.ValueType.ARRAY && value.getValueType() != JsonValue.ValueType.STRING) {
                        throw new IOException(this.exceptionPrefix.concat("Text Extension ").concat(name).concat(" is neither a string nor an array : ").concat(value.getValueType().name()));
                    }
                    if (value.getValueType() == JsonValue.ValueType.STRING) {
                        ext.setText(((JsonString)value).getString());
                        break;
                    }
                    StringBuilder sb = new StringBuilder();
                    for (JsonValue o : value.asJsonArray()) {
                        String textValue = this.checkTypeString("Text Extension ".concat(name).concat(", value ").concat(o.toString()), o);
                        sb.append(textValue);
                        sb.append('\n');
                    }
                    ext.setText(sb.toString());
                }
            }
            container.add(ext);
        }
    }

    private String checkScalarType(String key, JsonValue value, boolean allowNull) throws IOException {
        if (allowNull && value.getValueType() == JsonValue.ValueType.NULL) {
            return null;
        }
        if (value.getValueType() == JsonValue.ValueType.STRING || value.getValueType() == JsonValue.ValueType.NUMBER || value.getValueType() == JsonValue.ValueType.FALSE || value.getValueType() == JsonValue.ValueType.TRUE) {
            return org.apache.felix.cm.json.Configurations.convertToObject((JsonValue)value).toString();
        }
        throw new IOException(this.exceptionPrefix.concat("Key ").concat(key).concat(" is not one of the allowed types string, number or boolean : ").concat(value.getValueType().name()));
    }

    private void checkTypeObjectOrString(String key, JsonValue value) throws IOException {
        if (value.getValueType() != JsonValue.ValueType.STRING && value.getValueType() != JsonValue.ValueType.OBJECT) {
            throw new IOException(this.exceptionPrefix.concat("Key ").concat(key).concat(" is neither a string nor an object : ").concat(value.getValueType().name()));
        }
    }

    private boolean checkTypeBoolean(String key, JsonValue value) throws IOException {
        if (value.getValueType() == JsonValue.ValueType.TRUE || value.getValueType() == JsonValue.ValueType.FALSE) {
            return (Boolean)org.apache.felix.cm.json.Configurations.convertToObject((JsonValue)value);
        }
        throw new IOException(this.exceptionPrefix.concat("Key ").concat(key).concat(" is not of type boolean : ").concat(value.getValueType().name()));
    }

    private ArtifactId checkTypeArtifactId(String key, JsonValue value) throws IOException {
        String textValue = this.checkTypeString(key, value);
        try {
            return ArtifactId.parse(textValue);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(this.exceptionPrefix.concat("Key ").concat(key).concat(" is not a valid artifact id : ").concat(textValue));
        }
    }

    private String checkTypeString(String key, JsonValue value) throws IOException {
        if (value.getValueType() == JsonValue.ValueType.STRING) {
            return ((JsonString)value).getString();
        }
        throw new IOException(this.exceptionPrefix.concat("Key ").concat(key).concat(" is not of type string : ").concat(value.getValueType().name()));
    }

    private JsonObject checkTypeObject(String key, JsonValue value) throws IOException {
        if (value.getValueType() == JsonValue.ValueType.OBJECT) {
            return value.asJsonObject();
        }
        throw new IOException(this.exceptionPrefix.concat("Key ").concat(key).concat(" is not of type object : ").concat(value.getValueType().name()));
    }

    private JsonArray checkTypeArray(String key, JsonValue value) throws IOException {
        if (value.getValueType() == JsonValue.ValueType.ARRAY) {
            return value.asJsonArray();
        }
        throw new IOException(this.exceptionPrefix.concat("Key ").concat(key).concat(" is not of type array : ").concat(value.getValueType().name()));
    }

    private Prototype readPrototype(JsonObject json) throws IOException {
        if (json.containsKey((Object)"prototype")) {
            Prototype prototype;
            JsonValue prototypeObj = (JsonValue)json.get((Object)"prototype");
            this.checkTypeObjectOrString("prototype", prototypeObj);
            if (prototypeObj.getValueType() == JsonValue.ValueType.STRING) {
                prototype = new Prototype(this.checkTypeArtifactId("prototype", prototypeObj));
            } else {
                JsonObject obj = (JsonObject)prototypeObj;
                if (!obj.containsKey((Object)"id")) {
                    throw new IOException(this.exceptionPrefix.concat(" prototype is missing required artifact id"));
                }
                prototype = new Prototype(this.checkTypeArtifactId("Prototype ".concat("id"), (JsonValue)obj.get((Object)"id")));
                if (obj.containsKey((Object)"removals")) {
                    String propVal;
                    JsonObject removalObj = this.checkTypeObject("Prototype removals", (JsonValue)obj.get((Object)"removals"));
                    if (removalObj.containsKey((Object)"bundles")) {
                        for (JsonValue val : this.checkTypeArray("Prototype removal bundles", (JsonValue)removalObj.get((Object)"bundles"))) {
                            if (this.checkTypeString("Prototype removal bundles", val).startsWith("#")) continue;
                            prototype.getBundleRemovals().add(this.checkTypeArtifactId("Prototype removal bundles", val));
                        }
                    }
                    if (removalObj.containsKey((Object)"configurations")) {
                        for (JsonValue val : this.checkTypeArray("Prototype removal configuration", (JsonValue)removalObj.get((Object)"configurations"))) {
                            propVal = this.checkTypeString("Prototype removal configuration", val);
                            if (propVal.startsWith("#")) continue;
                            prototype.getConfigurationRemovals().add(propVal);
                        }
                    }
                    if (removalObj.containsKey((Object)"framework-properties")) {
                        for (JsonValue val : this.checkTypeArray("Prototype removal framework properties", (JsonValue)removalObj.get((Object)"framework-properties"))) {
                            propVal = this.checkTypeString("Prototype removal framework properties", val);
                            if (propVal.startsWith("#")) continue;
                            prototype.getFrameworkPropertiesRemovals().add(propVal);
                        }
                    }
                    if (removalObj.containsKey((Object)"extensions")) {
                        for (JsonValue val : this.checkTypeArray("Prototype removal extensions", (JsonValue)removalObj.get((Object)"extensions"))) {
                            this.checkTypeObjectOrString("Prototype removal extension", val);
                            if (val.getValueType() == JsonValue.ValueType.STRING) {
                                propVal = org.apache.felix.cm.json.Configurations.convertToObject((JsonValue)val).toString();
                                if (propVal.startsWith("#")) continue;
                                prototype.getExtensionRemovals().add(propVal);
                                continue;
                            }
                            JsonObject removalMap = (JsonObject)val;
                            JsonValue nameObj = (JsonValue)removalMap.get((Object)"name");
                            String name = this.checkTypeString("Prototype removal extension", nameObj);
                            if (removalMap.containsKey((Object)"artifacts")) {
                                ArrayList<ArtifactId> ids = new ArrayList<ArtifactId>();
                                for (JsonValue aid : this.checkTypeArray("Prototype removal extension artifacts", (JsonValue)removalMap.get((Object)"artifacts"))) {
                                    if (this.checkTypeString("Prototype removal extension artifact", aid).startsWith("#")) continue;
                                    ids.add(this.checkTypeArtifactId("Prototype removal extension artifact", aid));
                                }
                                prototype.getArtifactExtensionRemovals().put(name, ids);
                                continue;
                            }
                            prototype.getExtensionRemovals().add(name);
                        }
                    }
                    this.readRequirements(removalObj, prototype.getRequirementRemovals());
                    this.readCapabilities(removalObj, prototype.getCapabilityRemovals());
                }
            }
            return prototype;
        }
        return null;
    }

    private void readRequirements(JsonObject json, List<MatchingRequirement> container) throws IOException {
        if (json.containsKey((Object)"requirements")) {
            for (JsonValue req : this.checkTypeArray("requirements", (JsonValue)json.get((Object)"requirements"))) {
                JsonObject obj = this.checkTypeObject("Requirement", req);
                if (!obj.containsKey((Object)"namespace")) {
                    throw new IOException(this.exceptionPrefix.concat("Namespace is missing for requirement"));
                }
                String namespace = this.checkTypeString("Requirement namespace", (JsonValue)obj.get((Object)"namespace"));
                HashMap<String, Object> attrMap = new HashMap<String, Object>();
                if (obj.containsKey((Object)"attributes")) {
                    JsonObject attrs = this.checkTypeObject("Requirement attributes", (JsonValue)obj.get((Object)"attributes"));
                    attrs.forEach(FeatureJSONReader.rethrowBiConsumer((key, value) -> ManifestUtils.unmarshalAttribute(key, value, attrMap::put)));
                }
                HashMap<String, String> dirMap = new HashMap<String, String>();
                if (obj.containsKey((Object)"directives")) {
                    JsonObject dirs = this.checkTypeObject("Requirement directives", (JsonValue)obj.get((Object)"directives"));
                    dirs.forEach(FeatureJSONReader.rethrowBiConsumer((key, value) -> ManifestUtils.unmarshalDirective(key, value, dirMap::put)));
                }
                MatchingRequirementImpl r = new MatchingRequirementImpl(null, namespace, dirMap, attrMap);
                container.add(r);
            }
        }
    }

    private void readCapabilities(JsonObject json, List<Capability> container) throws IOException {
        if (json.containsKey((Object)"capabilities")) {
            for (JsonValue cap : this.checkTypeArray("requirements", (JsonValue)json.get((Object)"capabilities"))) {
                JsonObject obj = this.checkTypeObject("Capability", cap);
                if (!obj.containsKey((Object)"namespace")) {
                    throw new IOException(this.exceptionPrefix.concat("Namespace is missing for capability"));
                }
                String namespace = this.checkTypeString("Capability namespace", (JsonValue)obj.get((Object)"namespace"));
                HashMap<String, Object> attrMap = new HashMap<String, Object>();
                if (obj.containsKey((Object)"attributes")) {
                    JsonObject attrs = this.checkTypeObject("Capability attributes", (JsonValue)obj.get((Object)"attributes"));
                    attrs.forEach(FeatureJSONReader.rethrowBiConsumer((key, value) -> ManifestUtils.unmarshalAttribute(key, value, attrMap::put)));
                }
                HashMap<String, String> dirMap = new HashMap<String, String>();
                if (obj.containsKey((Object)"directives")) {
                    JsonObject dirs = this.checkTypeObject("Capability directives", (JsonValue)obj.get((Object)"directives"));
                    dirs.forEach(FeatureJSONReader.rethrowBiConsumer((key, value) -> ManifestUtils.unmarshalDirective(key, value, dirMap::put)));
                }
                CapabilityImpl c = new CapabilityImpl(null, namespace, dirMap, attrMap);
                container.add(c);
            }
        }
    }

    private static <T, V, E extends Exception> BiConsumer<T, V> rethrowBiConsumer(BiConsumer_WithExceptions<T, V, E> biConsumer) {
        return (t, u) -> {
            try {
                biConsumer.accept(t, u);
            }
            catch (Exception exception) {
                FeatureJSONReader.throwAsUnchecked(exception);
            }
        };
    }

    private static <E extends Throwable> void throwAsUnchecked(Exception exception) throws E {
        throw exception;
    }

    private Feature readFeature(Reader reader) throws IOException {
        JsonObject json = Json.createReader((Reader)org.apache.felix.cm.json.Configurations.jsonCommentAwareReader((Reader)reader)).readObject();
        this.checkModelVersion(json);
        ArtifactId featureId = this.getFeatureId(json);
        this.feature = new Feature(featureId);
        this.feature.setLocation(this.location);
        if (json.containsKey((Object)"final")) {
            this.feature.setFinal(this.checkTypeBoolean("final", (JsonValue)json.get((Object)"final")));
        }
        if (json.containsKey((Object)"complete")) {
            this.feature.setComplete(this.checkTypeBoolean("complete", (JsonValue)json.get((Object)"complete")));
        }
        this.feature.setTitle(this.getProperty(json, "title"));
        this.feature.setDescription(this.getProperty(json, "description"));
        this.feature.setVendor(this.getProperty(json, "vendor"));
        this.feature.setLicense(this.getProperty(json, "license"));
        this.feature.setDocURL(this.getProperty(json, "doc-url"));
        this.feature.setSCMInfo(this.getProperty(json, "scm-info"));
        if (json.containsKey((Object)"categories")) {
            for (JsonValue val : this.checkTypeArray("categories", (JsonValue)json.get((Object)"categories"))) {
                this.feature.getCategories().add(this.checkTypeString("Categories", val));
            }
        }
        this.readVariables(json, this.feature.getVariables());
        this.readBundles(json, this.feature.getBundles(), this.feature.getConfigurations());
        this.readFrameworkProperties(json, this.feature.getFrameworkProperties());
        this.readConfigurations(json, this.feature.getConfigurations());
        this.readCapabilities(json, this.feature.getCapabilities());
        this.readRequirements(json, this.feature.getRequirements());
        this.feature.setPrototype(this.readPrototype(json));
        this.readExtensions(json, JSONConstants.FEATURE_KNOWN_PROPERTIES, this.feature.getExtensions(), this.feature.getConfigurations());
        Extension internalData = this.feature.getExtensions().getByName("feature-internal-data");
        if (internalData != null) {
            this.feature.getExtensions().remove(internalData);
            if (internalData.getType() != ExtensionType.JSON) {
                throw new IOException("Extension " + internalData.getName() + " must be of type JSON");
            }
            this.setInternalData(internalData);
        }
        return this.feature;
    }

    private void checkModelVersion(JsonObject json) throws IOException {
        String modelVersion = this.getProperty(json, "model-version");
        if (modelVersion == null) {
            modelVersion = "1";
        }
        if (!"1".equals(modelVersion)) {
            throw new IOException(this.exceptionPrefix.concat("Unsupported model version: ").concat(modelVersion));
        }
    }

    private void setInternalData(Extension internalData) throws IOException {
        JsonStructure val = internalData.getJSONStructure();
        for (Map.Entry entry : this.checkTypeObject("Extension ".concat(internalData.getName()), (JsonValue)val).entrySet()) {
            Map<String, Object> metadata;
            String key = (String)entry.getKey();
            if ("framework-properties-metadata".equals(key)) {
                for (Map.Entry propEntry : this.checkTypeObject(key, (JsonValue)entry.getValue()).entrySet()) {
                    metadata = this.feature.getFrameworkPropertyMetadata((String)propEntry.getKey());
                    if (metadata == null) {
                        throw new IOException("Framework property " + (String)propEntry.getKey() + " does not exists (metadata)");
                    }
                    for (Map.Entry ve : this.checkTypeObject("framework-properties-metadata".concat(".").concat((String)propEntry.getKey()), (JsonValue)propEntry.getValue()).entrySet()) {
                        metadata.put((String)ve.getKey(), org.apache.felix.cm.json.Configurations.convertToObject((JsonValue)((JsonValue)ve.getValue())));
                    }
                }
                continue;
            }
            if ("variables-metadata".equals(key)) {
                for (Map.Entry varEntry : this.checkTypeObject(key, (JsonValue)entry.getValue()).entrySet()) {
                    metadata = this.feature.getVariableMetadata((String)varEntry.getKey());
                    if (metadata == null) {
                        throw new IOException("Variable " + (String)varEntry.getKey() + " does not exists (metadata)");
                    }
                    for (Map.Entry ve : this.checkTypeObject("variables-metadata".concat(".").concat((String)varEntry.getKey()), (JsonValue)varEntry.getValue()).entrySet()) {
                        metadata.put((String)ve.getKey(), org.apache.felix.cm.json.Configurations.convertToObject((JsonValue)((JsonValue)ve.getValue())));
                    }
                }
                continue;
            }
            throw new IOException("Unknown data in " + internalData.getName() + " : " + key);
        }
    }

    private static class MatchingRequirementImpl
    extends RequirementImpl
    implements MatchingRequirement {
        public MatchingRequirementImpl(Resource res, String ns, Map<String, String> dirs, Map<String, Object> attrs) {
            super(res, ns, dirs, attrs);
        }
    }

    @FunctionalInterface
    private static interface BiConsumer_WithExceptions<T, V, E extends Exception> {
        public void accept(T var1, V var2) throws E;
    }
}

