/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport.fsresource;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.bundlesupport.fsresource.FsMode;
import org.apache.sling.maven.bundlesupport.fsresource.FsMountHelper;
import org.apache.sling.maven.bundlesupport.fsresource.FsResourceConfiguration;

public final class FileVaultXmlMounter {
    private final Log log;
    private final FsMountHelper helper;

    public FileVaultXmlMounter(Log log, HttpClient httpClient, MavenProject project) {
        this.log = log;
        this.helper = new FsMountHelper(log, httpClient, project);
    }

    public void mount(String targetUrl, File jcrRootFile, File filterXmlFile) throws MojoExecutionException {
        this.log.info((CharSequence)"Trying to configure file system provider...");
        ArrayList<FsResourceConfiguration> cfgs = new ArrayList<FsResourceConfiguration>();
        WorkspaceFilter workspaceFilter = this.getWorkspaceFilter(filterXmlFile);
        for (PathFilterSet filterSet : workspaceFilter.getFilterSets()) {
            cfgs.add(new FsResourceConfiguration().fsMode(FsMode.FILEVAULT_XML).contentRootDir(jcrRootFile.getAbsolutePath()).providerRootPath(filterSet.getRoot()).fileVaultFilterXml(filterXmlFile.getAbsolutePath()));
        }
        if (!cfgs.isEmpty()) {
            this.helper.addConfigurations(targetUrl, cfgs);
        }
    }

    public void unmount(String targetUrl, File jcrRootFile, File filterXmlFile) throws MojoExecutionException {
        this.log.info((CharSequence)"Removing file system provider configurations...");
        Map<String, FsResourceConfiguration> oldConfigs = this.helper.getCurrentConfigurations(targetUrl);
        this.helper.removeConfigurations(targetUrl, oldConfigs);
    }

    private WorkspaceFilter getWorkspaceFilter(File filterXmlFile) throws MojoExecutionException {
        try {
            DefaultWorkspaceFilter workspaceFilter = new DefaultWorkspaceFilter();
            workspaceFilter.load(filterXmlFile);
            return workspaceFilter;
        }
        catch (IOException | ConfigurationException ex) {
            throw new MojoExecutionException("Unable to parse workspace filter: " + filterXmlFile.getPath(), (Exception)ex);
        }
    }
}

