/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.jspc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.jspc.JspCServletContext;
import org.apache.sling.scripting.jsp.jasper.JasperException;
import org.apache.sling.scripting.jsp.jasper.JspCompilationContext;
import org.apache.sling.scripting.jsp.jasper.Options;
import org.apache.sling.scripting.jsp.jasper.compiler.Compiler;
import org.apache.sling.scripting.jsp.jasper.compiler.JspConfig;
import org.apache.sling.scripting.jsp.jasper.compiler.JspRuntimeContext;
import org.apache.sling.scripting.jsp.jasper.compiler.TagPluginManager;
import org.apache.sling.scripting.jsp.jasper.compiler.TldLocationsCache;
import org.apache.sling.scripting.jsp.jasper.xmlparser.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspcMojo
extends AbstractMojo
implements Options {
    private MavenProject project;
    private File sourceDirectory;
    private String outputDirectory;
    private boolean jasperClassDebugInfo;
    private boolean jasperEnablePooling;
    private String jasperIeClassId;
    private boolean jasperGenStringAsCharArray;
    private boolean jasperKeepGenerated;
    private boolean jasperMappedFile;
    private boolean jasperTrimSpaces;
    private boolean failOnError;
    private boolean showSuccess;
    private String compilerTargetVM;
    private String compilerSourceVM;
    private String jspFileExtensions;
    private String servletPackage;
    private Set<String> jspFileExtensionSet;
    private boolean compile = true;
    private String uriSourceRoot;
    private List<String> pages = new ArrayList<String>();
    private ServletContext context;
    private JspRuntimeContext rctxt;
    private URLClassLoader loader = null;
    private Map<String, TreeNode> tldCache;
    private TldLocationsCache tldLocationsCache = null;
    private JspConfig jspConfig = null;
    private TagPluginManager tagPluginManager = null;

    public void execute() throws MojoExecutionException {
        try {
            this.uriSourceRoot = this.sourceDirectory.getCanonicalPath();
        }
        catch (Exception e) {
            this.uriSourceRoot = this.sourceDirectory.getAbsolutePath();
        }
        File outputDirectoryFile = new File(this.outputDirectory);
        if (!outputDirectoryFile.isDirectory()) {
            if (outputDirectoryFile.exists()) {
                throw new MojoExecutionException(this.outputDirectory + " exists but is not a directory");
            }
            if (!outputDirectoryFile.mkdirs()) {
                throw new MojoExecutionException("Cannot create output directory " + this.outputDirectory);
            }
        }
        String oldValue = System.getProperty("org.apache.commons.logging.Log");
        try {
            System.setProperty("org.apache.commons.logging.Log", SimpleLog.class.getName());
            this.executeInternal();
        }
        catch (JasperException je) {
            this.getLog().error((CharSequence)"Compilation Failure", (Throwable)je);
            throw new MojoExecutionException(je.getMessage(), (Exception)((Object)je));
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("org.apache.commons.logging.Log");
            } else {
                System.setProperty("org.apache.commons.logging.Log", oldValue);
            }
        }
        this.project.addCompileSourceRoot(this.outputDirectory);
    }

    public void scanFiles(File base) {
        Stack<File> dirs = new Stack<File>();
        dirs.push(base);
        while (!dirs.isEmpty()) {
            File f = (File)dirs.pop();
            if (!f.exists() || !f.isDirectory()) continue;
            String[] files = f.list();
            for (int i = 0; files != null && i < files.length; ++i) {
                File f2 = new File(f, files[i]);
                if (f2.isDirectory()) {
                    dirs.push(f2);
                    continue;
                }
                String ext = files[i].substring(files[i].lastIndexOf(46) + 1);
                if (!this.getExtensions().contains(ext)) continue;
                this.pages.add(f2.getAbsolutePath());
            }
        }
    }

    private void executeInternal() throws JasperException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("execute() starting for " + this.pages.size() + " pages."));
        }
        try {
            File uriRootF;
            if (this.context == null) {
                this.initServletContext();
            }
            if (this.pages.size() == 0) {
                this.scanFiles(this.sourceDirectory);
            }
            if (!(uriRootF = new File(this.uriSourceRoot)).exists() || !uriRootF.isDirectory()) {
                throw new JasperException("The source location '" + this.uriSourceRoot + "' must be an existing directory");
            }
            for (String nextjsp : this.pages) {
                File fjsp = new File(nextjsp);
                if (!fjsp.isAbsolute()) {
                    fjsp = new File(uriRootF, nextjsp);
                }
                if (!fjsp.exists()) {
                    if (!this.getLog().isWarnEnabled()) continue;
                    this.getLog().warn((CharSequence)("JSP file " + fjsp + " does not exist"));
                    continue;
                }
                String s = fjsp.getAbsolutePath();
                if (s.startsWith(this.uriSourceRoot)) {
                    nextjsp = s.substring(this.uriSourceRoot.length());
                }
                if (nextjsp.startsWith("." + File.separatorChar)) {
                    nextjsp = nextjsp.substring(2);
                }
                this.processFile(nextjsp);
            }
        }
        catch (JasperException je) {
            Throwable rootCause = je;
            while (rootCause instanceof JasperException && rootCause.getRootCause() != null) {
                rootCause = rootCause.getRootCause();
            }
            if (rootCause != je) {
                rootCause.printStackTrace();
            }
            throw je;
        }
        catch (Exception ioe) {
            throw new JasperException((Throwable)ioe);
        }
    }

    /*
     * Loose catch block
     */
    private void processFile(String file) throws JasperException {
        ClassLoader originalClassLoader = null;
        try {
            String jspUri = file.replace('\\', '/');
            JspCompilationContext clctxt = new JspCompilationContext(jspUri, false, (Options)this, this.context, null, this.rctxt);
            clctxt.setServletPackageName(this.servletPackage);
            originalClassLoader = Thread.currentThread().getContextClassLoader();
            if (this.loader == null) {
                this.initClassLoader();
            }
            Thread.currentThread().setContextClassLoader(this.loader);
            clctxt.setClassLoader((ClassLoader)this.loader);
            clctxt.setClassPath(null);
            Compiler clc = clctxt.createCompiler();
            if (clc.isOutDated(this.compile)) {
                clc.compile(this.compile, true);
                if (this.showSuccess) {
                    this.getLog().info((CharSequence)("Built File: " + file));
                }
            } else if (this.showSuccess) {
                this.getLog().info((CharSequence)("File up to date: " + file));
            }
            if (originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
        catch (JasperException je) {
            Throwable rootCause = je;
            while (rootCause instanceof JasperException && rootCause.getRootCause() != null) {
                rootCause = rootCause.getRootCause();
            }
            if (rootCause != je) {
                this.getLog().error((CharSequence)("General problem compiling " + file), rootCause);
            }
            if (this.failOnError) {
                throw je;
            }
            this.getLog().error((CharSequence)je.getMessage());
            if (originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException && this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("Missing file: " + e.getMessage()));
            }
            throw new JasperException((Throwable)e);
            {
                catch (Throwable throwable) {
                    if (originalClassLoader != null) {
                        Thread.currentThread().setContextClassLoader(originalClassLoader);
                    }
                    throw throwable;
                }
            }
        }
    }

    private Set<String> getExtensions() {
        if (this.jspFileExtensionSet == null) {
            this.jspFileExtensionSet = new HashSet<String>();
            if (this.jspFileExtensions == null) {
                this.jspFileExtensions = "jsp,jspx";
            }
            StringTokenizer st = new StringTokenizer(this.jspFileExtensions, ",");
            while (st.hasMoreTokens()) {
                String ext = st.nextToken().trim();
                if (ext.length() <= 0) continue;
                this.jspFileExtensionSet.add(ext);
            }
        }
        return this.jspFileExtensionSet;
    }

    private void initServletContext() {
        try {
            this.context = new JspCServletContext(this.getLog(), new URL("file:" + this.uriSourceRoot.replace('\\', '/') + '/'));
            this.tldLocationsCache = new TldLocationsCache(this.context, true);
        }
        catch (MalformedURLException me) {
            this.getLog().error((CharSequence)"Cannot setup ServletContext", (Throwable)me);
        }
        this.rctxt = new JspRuntimeContext(this.context, (Options)this);
        this.jspConfig = new JspConfig(this.context);
        this.tagPluginManager = new TagPluginManager(this.context);
    }

    private void initClassLoader() throws IOException, DependencyResolutionRequiredException {
        List artifacts = this.project.getCompileArtifacts();
        URL[] path = new URL[artifacts.size() + 1];
        int i = 0;
        for (Artifact a : artifacts) {
            path[i++] = a.getFile().toURI().toURL();
        }
        String targetDirectory = this.project.getBuild().getOutputDirectory();
        path[path.length - 1] = new File(targetDirectory).toURI().toURL();
        this.loader = new URLClassLoader(path, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public boolean genStringAsCharArray() {
        return this.jasperGenStringAsCharArray;
    }

    public boolean isCaching() {
        return true;
    }

    public Map<String, TreeNode> getCache() {
        if (this.tldCache == null) {
            this.tldCache = new HashMap<String, TreeNode>();
        }
        return this.tldCache;
    }

    public int getCheckInterval() {
        return 0;
    }

    public boolean getClassDebugInfo() {
        return this.jasperClassDebugInfo;
    }

    public String getClassPath() {
        return null;
    }

    public String getCompiler() {
        return null;
    }

    public String getCompilerClassName() {
        return null;
    }

    public String getCompilerSourceVM() {
        return this.compilerSourceVM;
    }

    public String getCompilerTargetVM() {
        return this.compilerTargetVM;
    }

    public boolean getDevelopment() {
        return false;
    }

    public boolean getErrorOnUseBeanInvalidClassAttribute() {
        return true;
    }

    public boolean getFork() {
        return false;
    }

    public String getIeClassId() {
        return this.jasperIeClassId;
    }

    public String getJavaEncoding() {
        return "UTF-8";
    }

    public ClassLoader getJspClassLoader() {
        return null;
    }

    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    public boolean getKeepGenerated() {
        return this.jasperKeepGenerated;
    }

    public boolean getMappedFile() {
        return this.jasperMappedFile;
    }

    public int getModificationTestInterval() {
        return 0;
    }

    public String getScratchDir() {
        return this.outputDirectory;
    }

    public boolean getSendErrorToClient() {
        return true;
    }

    public TagPluginManager getTagPluginManager() {
        return this.tagPluginManager;
    }

    public TldLocationsCache getTldLocationsCache() {
        return this.tldLocationsCache;
    }

    public boolean getTrimSpaces() {
        return this.jasperTrimSpaces;
    }

    public boolean isPoolingEnabled() {
        return this.jasperEnablePooling;
    }

    public boolean isSmapDumped() {
        return true;
    }

    public boolean isSmapSuppressed() {
        return false;
    }

    public boolean isXpoweredBy() {
        return false;
    }

    public boolean getDisplaySourceFragment() {
        return true;
    }
}

