/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.jspc;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspCServletContext
implements ServletContext {
    private static final String WEB_XML = "/WEB-INF/web.xml";
    protected Hashtable<String, Object> attributes = new Hashtable();
    protected Log log;
    protected URL resourceBaseURL;

    public JspCServletContext(Log log, URL resourceBaseURL) {
        this.log = log;
        this.resourceBaseURL = resourceBaseURL;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.attributes.keys();
    }

    public ServletContext getContext(String uripath) {
        return null;
    }

    public String getInitParameter(String name) {
        return null;
    }

    public Enumeration<String> getInitParameterNames() {
        return new Vector().elements();
    }

    public int getMajorVersion() {
        return 2;
    }

    public String getMimeType(String file) {
        return null;
    }

    public int getMinorVersion() {
        return 3;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return null;
    }

    public String getRealPath(String path) {
        if (!this.resourceBaseURL.getProtocol().equals("file")) {
            return null;
        }
        if (!path.startsWith("/")) {
            return null;
        }
        try {
            return this.getResource(path).getFile().replace('/', File.separatorChar);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(String path) throws MalformedURLException {
        if (WEB_XML.equals(path)) {
            return this.getClass().getResource("web.xml");
        }
        if (!path.startsWith("/")) {
            throw new MalformedURLException("Path '" + path + "' does not start with '/'");
        }
        URL url = new URL(this.resourceBaseURL, path.substring(1));
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (Throwable t) {
            url = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable t2) {}
            }
        }
        return url;
    }

    public InputStream getResourceAsStream(String path) {
        try {
            return this.getResource(path).openStream();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Set<String> getResourcePaths(String path) {
        String basePath;
        HashSet<String> thePaths = new HashSet<String>();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ((basePath = this.getRealPath(path)) == null) {
            return thePaths;
        }
        File theBaseDir = new File(basePath);
        if (!theBaseDir.exists() || !theBaseDir.isDirectory()) {
            return thePaths;
        }
        String[] theFiles = theBaseDir.list();
        for (int i = 0; i < theFiles.length; ++i) {
            File testFile = new File(basePath + File.separator + theFiles[i]);
            if (testFile.isFile()) {
                thePaths.add(path + theFiles[i]);
                continue;
            }
            if (!testFile.isDirectory()) continue;
            thePaths.add(path + theFiles[i] + "/");
        }
        return thePaths;
    }

    public String getServerInfo() {
        return "JspCServletContext/1.0";
    }

    @Deprecated
    public Servlet getServlet(String name) {
        return null;
    }

    public String getServletContextName() {
        return this.getServerInfo();
    }

    public String getContextPath() {
        return "/";
    }

    @Deprecated
    public Enumeration<String> getServletNames() {
        return new Vector().elements();
    }

    @Deprecated
    public Enumeration<Servlet> getServlets() {
        return new Vector().elements();
    }

    public void log(String message) {
        this.log.info((CharSequence)message);
    }

    @Deprecated
    public void log(Exception exception, String message) {
        this.log(message, exception);
    }

    public void log(String message, Throwable exception) {
        this.log.error((CharSequence)message, exception);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }
}

