/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.sharing.server;

import io.grpc.BindableService;
import java.util.Objects;
import org.apache.logging.log4j.util.Strings;
import org.apache.skywalking.oap.server.core.remote.health.HealthCheckServiceHandler;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegisterImpl;
import org.apache.skywalking.oap.server.core.server.JettyHandlerRegister;
import org.apache.skywalking.oap.server.core.server.JettyHandlerRegisterImpl;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.server.ServerException;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCServer;
import org.apache.skywalking.oap.server.library.server.jetty.JettyServer;
import org.apache.skywalking.oap.server.receiver.sharing.server.ReceiverGRPCHandlerRegister;
import org.apache.skywalking.oap.server.receiver.sharing.server.ReceiverJettyHandlerRegister;
import org.apache.skywalking.oap.server.receiver.sharing.server.SharingServerConfig;
import org.apache.skywalking.oap.server.receiver.sharing.server.SharingServerModule;

public class SharingServerModuleProvider
extends ModuleProvider {
    private final SharingServerConfig config = new SharingServerConfig();
    private GRPCServer grpcServer;
    private JettyServer jettyServer;
    private ReceiverGRPCHandlerRegister receiverGRPCHandlerRegister;
    private ReceiverJettyHandlerRegister receiverJettyHandlerRegister;

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return SharingServerModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() {
        if (this.config.getRestPort() != 0) {
            this.jettyServer = new JettyServer(Strings.isBlank((String)this.config.getRestHost()) ? "0.0.0.0" : this.config.getRestHost(), this.config.getRestPort(), this.config.getRestContextPath());
            this.jettyServer.initialize();
            this.registerServiceImplementation(JettyHandlerRegister.class, (Service)new JettyHandlerRegisterImpl(this.jettyServer));
        } else {
            this.receiverJettyHandlerRegister = new ReceiverJettyHandlerRegister();
            this.registerServiceImplementation(JettyHandlerRegister.class, (Service)this.receiverJettyHandlerRegister);
        }
        if (this.config.getGRPCPort() != 0) {
            this.grpcServer = new GRPCServer(Strings.isBlank((String)this.config.getGRPCHost()) ? "0.0.0.0" : this.config.getGRPCHost(), this.config.getGRPCPort());
            if (this.config.getMaxMessageSize() > 0) {
                this.grpcServer.setMaxMessageSize(this.config.getMaxMessageSize());
            }
            if (this.config.getMaxConcurrentCallsPerConnection() > 0) {
                this.grpcServer.setMaxConcurrentCallsPerConnection(this.config.getMaxConcurrentCallsPerConnection());
            }
            this.grpcServer.initialize();
            this.registerServiceImplementation(GRPCHandlerRegister.class, (Service)new GRPCHandlerRegisterImpl(this.grpcServer));
        } else {
            this.receiverGRPCHandlerRegister = new ReceiverGRPCHandlerRegister();
            this.registerServiceImplementation(GRPCHandlerRegister.class, (Service)this.receiverGRPCHandlerRegister);
        }
    }

    public void start() {
        if (Objects.nonNull(this.grpcServer)) {
            this.grpcServer.addHandler((BindableService)new HealthCheckServiceHandler());
        }
        if (Objects.nonNull(this.receiverGRPCHandlerRegister)) {
            this.receiverGRPCHandlerRegister.setGrpcHandlerRegister((GRPCHandlerRegister)this.getManager().find("core").provider().getService(GRPCHandlerRegister.class));
        }
        if (Objects.nonNull(this.receiverJettyHandlerRegister)) {
            this.receiverJettyHandlerRegister.setJettyHandlerRegister((JettyHandlerRegister)this.getManager().find("core").provider().getService(JettyHandlerRegister.class));
        }
    }

    public void notifyAfterCompleted() throws ModuleStartException {
        try {
            if (Objects.nonNull(this.grpcServer)) {
                this.grpcServer.start();
            }
            if (Objects.nonNull(this.jettyServer)) {
                this.jettyServer.start();
            }
        }
        catch (ServerException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

