/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import com.coxautodev.graphql.tools.GraphQLQueryResolver;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.query.TraceQueryService;
import org.apache.skywalking.oap.server.core.query.input.TraceQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.Pagination;
import org.apache.skywalking.oap.server.core.query.type.QueryOrder;
import org.apache.skywalking.oap.server.core.query.type.Trace;
import org.apache.skywalking.oap.server.core.query.type.TraceBrief;
import org.apache.skywalking.oap.server.core.query.type.TraceState;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class TraceQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private TraceQueryService queryService;

    public TraceQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private TraceQueryService getQueryService() {
        if (this.queryService == null) {
            this.queryService = (TraceQueryService)this.moduleManager.find("core").provider().getService(TraceQueryService.class);
        }
        return this.queryService;
    }

    public TraceBrief queryBasicTraces(TraceQueryCondition condition) throws IOException {
        long startSecondTB = 0L;
        long endSecondTB = 0L;
        String traceId = "";
        if (!Strings.isNullOrEmpty((String)condition.getTraceId())) {
            traceId = condition.getTraceId();
        } else if (Objects.nonNull(condition.getQueryDuration())) {
            startSecondTB = condition.getQueryDuration().getStartTimeBucketInSec();
            endSecondTB = condition.getQueryDuration().getEndTimeBucketInSec();
        } else {
            throw new UnexpectedException("The condition must contains either queryDuration or traceId.");
        }
        int minDuration = condition.getMinTraceDuration();
        int maxDuration = condition.getMaxTraceDuration();
        String endpointId = condition.getEndpointId();
        TraceState traceState = condition.getTraceState();
        QueryOrder queryOrder = condition.getQueryOrder();
        Pagination pagination = condition.getPaging();
        return this.getQueryService().queryBasicTraces(condition.getServiceId(), condition.getServiceInstanceId(), endpointId, traceId, minDuration, maxDuration, traceState, queryOrder, pagination, startSecondTB, endSecondTB, condition.getTags());
    }

    public Trace queryTrace(String traceId) throws IOException {
        return this.getQueryService().queryTrace(traceId);
    }
}

