/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import com.coxautodev.graphql.tools.GraphQLQueryResolver;
import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.oap.log.analyzer.dsl.Binding;
import org.apache.skywalking.oap.log.analyzer.dsl.DSL;
import org.apache.skywalking.oap.log.analyzer.provider.LogAnalyzerModuleConfig;
import org.apache.skywalking.oap.log.analyzer.provider.LogAnalyzerModuleProvider;
import org.apache.skywalking.oap.query.graphql.GraphQLQueryConfig;
import org.apache.skywalking.oap.query.graphql.type.LogTestRequest;
import org.apache.skywalking.oap.query.graphql.type.LogTestResponse;
import org.apache.skywalking.oap.query.graphql.type.Metrics;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.Log;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.ProtoBufJsonUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class LogTestQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private final GraphQLQueryConfig config;

    public LogTestResponse test(LogTestRequest request) throws Exception {
        if (!this.config.isEnableLogTestTool()) {
            throw new IllegalAccessException("LAL debug tool is not enabled. To enable, please set SW_QUERY_GRAPHQL_ENABLE_LOG_TEST_TOOL=true,for more details, refer to https://skywalking.apache.org/docs/main/latest/en/setup/backend/configuration-vocabulary/");
        }
        Objects.requireNonNull(request, "request");
        Preconditions.checkArgument((boolean)StringUtil.isNotBlank((String)request.getLog()), (Object)"request.log cannot be blank");
        Preconditions.checkArgument((boolean)StringUtil.isNotBlank((String)request.getDsl()), (Object)"request.dsl cannot be blank");
        LogAnalyzerModuleProvider provider = (LogAnalyzerModuleProvider)this.moduleManager.find("log-analyzer").provider();
        LogAnalyzerModuleConfig config = (LogAnalyzerModuleConfig)provider.createConfigBeanIfAbsent();
        DSL dsl = DSL.of((ModuleManager)this.moduleManager, (LogAnalyzerModuleConfig)config, (String)request.getDsl());
        Binding binding = new Binding();
        LogData.Builder log = LogData.newBuilder();
        ProtoBufJsonUtils.fromJSON((String)request.getLog(), (Message.Builder)log);
        binding.log(log);
        binding.logContainer(new AtomicReference());
        binding.metricsContainer(new ArrayList());
        dsl.bind(binding);
        dsl.evaluate();
        LogTestResponse.LogTestResponseBuilder builder = LogTestResponse.builder();
        binding.logContainer().map(AtomicReference::get).ifPresent(it -> {
            String name;
            Log l = new Log();
            if (StringUtil.isNotBlank((String)it.getServiceId())) {
                l.setServiceName(IDManager.ServiceID.analysisId((String)it.getServiceId()).getName());
            }
            l.setServiceId(it.getServiceId());
            if (StringUtil.isNotBlank((String)it.getServiceInstanceId())) {
                name = IDManager.ServiceInstanceID.analysisId((String)it.getServiceId()).getName();
                l.setServiceInstanceName(name);
            }
            l.setServiceInstanceId(it.getServiceInstanceId());
            l.setEndpointId(it.getEndpointId());
            if (StringUtil.isNotBlank((String)it.getEndpointId())) {
                name = IDManager.EndpointID.analysisId((String)it.getEndpointId()).getEndpointName();
                l.setEndpointName(name);
            }
            l.setTraceId(it.getTraceId());
            l.setTimestamp(Long.valueOf(it.getTimestamp()));
            l.setContentType(it.getContentType());
            l.setContent(it.getContent());
            List tags = it.getTags().stream().map(tag -> new KeyValue(tag.getKey(), tag.getValue())).collect(Collectors.toList());
            l.getTags().addAll(tags);
            builder.log(l);
        });
        binding.metricsContainer().ifPresent(it -> {
            List<Metrics> samples = it.stream().flatMap(s -> Arrays.stream(s.samples)).map(s -> new Metrics(s.getName(), s.getLabels().entrySet().stream().map(kv -> new KeyValue((String)kv.getKey(), (String)kv.getValue())).collect(Collectors.toList()), (long)s.getValue(), s.getTimestamp())).collect(Collectors.toList());
            builder.metrics(samples);
        });
        return builder.build();
    }

    @Generated
    public LogTestQuery(ModuleManager moduleManager, GraphQLQueryConfig config) {
        this.moduleManager = moduleManager;
        this.config = config;
    }
}

