/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import com.coxautodev.graphql.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.util.Objects;
import org.apache.skywalking.oap.query.graphql.type.TraceQueryCondition;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.query.DurationUtils;
import org.apache.skywalking.oap.server.core.query.TraceQueryService;
import org.apache.skywalking.oap.server.core.query.entity.Pagination;
import org.apache.skywalking.oap.server.core.query.entity.QueryOrder;
import org.apache.skywalking.oap.server.core.query.entity.Trace;
import org.apache.skywalking.oap.server.core.query.entity.TraceBrief;
import org.apache.skywalking.oap.server.core.query.entity.TraceState;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtils;

public class TraceQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private TraceQueryService queryService;

    public TraceQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private TraceQueryService getQueryService() {
        if (this.queryService == null) {
            this.queryService = (TraceQueryService)this.moduleManager.find("core").getService(TraceQueryService.class);
        }
        return this.queryService;
    }

    public TraceBrief queryBasicTraces(TraceQueryCondition condition) throws IOException {
        long startSecondTB = 0L;
        long endSecondTB = 0L;
        String traceId = "";
        if (StringUtils.isNotEmpty((Object)condition.getTraceId())) {
            traceId = condition.getTraceId();
        } else if (Objects.nonNull(condition.getQueryDuration())) {
            startSecondTB = DurationUtils.INSTANCE.startTimeDurationToSecondTimeBucket(condition.getQueryDuration().getStep(), condition.getQueryDuration().getStart());
            endSecondTB = DurationUtils.INSTANCE.endTimeDurationToSecondTimeBucket(condition.getQueryDuration().getStep(), condition.getQueryDuration().getEnd());
        } else {
            throw new UnexpectedException("The condition must contains either queryDuration or traceId.");
        }
        int minDuration = condition.getMinTraceDuration();
        int maxDuration = condition.getMaxTraceDuration();
        String endpointName = condition.getEndpointName();
        int serviceId = StringUtils.isEmpty((Object)condition.getServiceId()) ? 0 : Integer.parseInt(condition.getServiceId());
        int endpointId = StringUtils.isEmpty((Object)condition.getEndpointId()) ? 0 : Integer.parseInt(condition.getEndpointId());
        TraceState traceState = condition.getTraceState();
        QueryOrder queryOrder = condition.getQueryOrder();
        Pagination pagination = condition.getPaging();
        return this.getQueryService().queryBasicTraces(serviceId, endpointId, traceId, endpointName, minDuration, maxDuration, traceState, queryOrder, pagination, startSecondTB, endSecondTB);
    }

    public Trace queryTrace(String traceId) throws IOException {
        return this.getQueryService().queryTrace(traceId);
    }
}

