/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.datacarrier.buffer;

import java.util.List;
import org.apache.skywalking.oap.server.library.datacarrier.buffer.BufferStrategy;
import org.apache.skywalking.oap.server.library.datacarrier.buffer.QueueBuffer;
import org.apache.skywalking.oap.server.library.datacarrier.common.AtomicRangeInteger;

public class Buffer<T>
implements QueueBuffer<T> {
    private final Object[] buffer;
    private BufferStrategy strategy;
    private AtomicRangeInteger index;

    Buffer(int bufferSize, BufferStrategy strategy) {
        this.buffer = new Object[bufferSize];
        this.strategy = strategy;
        this.index = new AtomicRangeInteger(0, bufferSize);
    }

    @Override
    public void setStrategy(BufferStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public boolean save(T data) {
        int i = this.index.getAndIncrement();
        if (this.buffer[i] != null) {
            switch (this.strategy) {
                case IF_POSSIBLE: {
                    return false;
                }
            }
        }
        this.buffer[i] = data;
        return true;
    }

    @Override
    public int getBufferSize() {
        return this.buffer.length;
    }

    @Override
    public void obtain(List<T> consumeList) {
        this.obtain(consumeList, 0, this.buffer.length);
    }

    void obtain(List<T> consumeList, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (this.buffer[i] == null) continue;
            consumeList.add(this.buffer[i]);
            this.buffer[i] = null;
        }
    }
}

