/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.zookeeper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.cluster.ServiceRegisterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperCoordinator
implements ClusterRegister,
ClusterNodesQuery {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperCoordinator.class);
    private final ServiceDiscovery<RemoteInstance> serviceDiscovery;
    private volatile ServiceCache<RemoteInstance> serviceCache;
    private volatile RemoteInstance selfInstance;

    ZookeeperCoordinator(ServiceDiscovery<RemoteInstance> serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public synchronized void registerRemote(RemoteInstance remoteInstance) throws ServiceRegisterException {
        try {
            String remoteNamePath = "remote";
            ServiceInstance thisInstance = ServiceInstance.builder().name(remoteNamePath).id(UUID.randomUUID().toString()).address(remoteInstance.getHost()).port(remoteInstance.getPort()).payload((Object)remoteInstance).build();
            this.serviceDiscovery.registerService(thisInstance);
            this.serviceCache = this.serviceDiscovery.serviceCacheBuilder().name(remoteNamePath).build();
            this.serviceCache.start();
            this.selfInstance = remoteInstance;
        }
        catch (Exception e) {
            throw new ServiceRegisterException(e.getMessage());
        }
    }

    public List<RemoteInstance> queryRemoteNodes() {
        ArrayList<RemoteInstance> remoteInstanceDetails = new ArrayList<RemoteInstance>(20);
        if (Objects.nonNull(this.serviceCache)) {
            List serviceInstances = this.serviceCache.getInstances();
            serviceInstances.forEach(serviceInstance -> {
                RemoteInstance instance = (RemoteInstance)serviceInstance.getPayload();
                if (instance.equals((Object)this.selfInstance)) {
                    instance.setSelf(true);
                } else {
                    instance.setSelf(false);
                }
                remoteInstanceDetails.add(instance);
            });
        }
        return remoteInstanceDetails;
    }
}

