/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.kubernetes.dependencies;

import com.google.common.reflect.TypeToken;
import com.squareup.okhttp.Call;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.models.V1Pod;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.Watch;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.Event;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.ReusableWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespacedPodListWatch
implements ReusableWatch<Event> {
    private static final Logger logger = LoggerFactory.getLogger(NamespacedPodListWatch.class);
    private final String namespace;
    private final String labelSelector;
    private final int watchTimeoutSeconds;
    private Watch<V1Pod> watch;

    public NamespacedPodListWatch(String namespace, String labelSelector, int watchTimeoutSeconds) {
        this.namespace = namespace;
        this.labelSelector = labelSelector;
        this.watchTimeoutSeconds = watchTimeoutSeconds;
    }

    @Override
    public void initOrReset() {
        ApiClient client;
        try {
            client = Config.defaultClient();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        client.getHttpClient().setReadTimeout((long)this.watchTimeoutSeconds, TimeUnit.SECONDS);
        Configuration.setDefaultApiClient((ApiClient)client);
        CoreV1Api api = new CoreV1Api();
        try {
            this.watch = Watch.createWatch((ApiClient)client, (Call)api.listNamespacedPodCall(this.namespace, null, null, null, null, this.labelSelector, Integer.valueOf(Integer.MAX_VALUE), null, null, Boolean.TRUE, null, null), (Type)new TypeToken<Watch.Response<V1Pod>>(){}.getType());
        }
        catch (ApiException e) {
            logger.error("code:{} header:{} body:{}", new Object[]{e.getCode(), e.getResponseHeaders(), e.getResponseBody()});
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Iterator<Event> iterator() {
        final Iterator watchItr = this.watch.iterator();
        return new Iterator<Event>(){

            @Override
            public boolean hasNext() {
                return this.wrap(watchItr::hasNext, false);
            }

            @Override
            public Event next() {
                return this.wrap(() -> {
                    Watch.Response response = (Watch.Response)watchItr.next();
                    return new Event(response.type, ((V1Pod)response.object).getMetadata().getUid(), ((V1Pod)response.object).getStatus().getPodIP());
                }, null);
            }

            private <R> R wrap(Supplier<R> action, R defaultValue) {
                Objects.requireNonNull(action);
                try {
                    return action.get();
                }
                catch (Throwable t) {
                    logger.trace("Throwable", t);
                    try {
                        NamespacedPodListWatch.this.watch.close();
                    }
                    catch (IOException e) {
                        logger.error("Close watch error", (Throwable)e);
                    }
                    return defaultValue;
                }
            }
        };
    }
}

