/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.kubernetes;

import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.ClusterModuleKubernetesConfig;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.KubernetesCoordinator;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.dependencies.NamespacedPodListWatch;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.dependencies.UidEnvSupplier;
import org.apache.skywalking.oap.server.core.cluster.ClusterModule;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;

public class ClusterModuleKubernetesProvider
extends ModuleProvider {
    private final ClusterModuleKubernetesConfig config = new ClusterModuleKubernetesConfig();

    public String name() {
        return "kubernetes";
    }

    public Class<? extends ModuleDefine> module() {
        return ClusterModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException {
        KubernetesCoordinator coordinator = new KubernetesCoordinator(new NamespacedPodListWatch(this.config.getNamespace(), this.config.getLabelSelector(), this.config.getWatchTimeoutSeconds()), new UidEnvSupplier(this.config.getUidEnvName()));
        this.registerServiceImplementation(ClusterRegister.class, (Service)coordinator);
        this.registerServiceImplementation(ClusterNodesQuery.class, (Service)coordinator);
    }

    public void start() {
    }

    public void notifyAfterCompleted() {
    }

    public String[] requiredModules() {
        return new String[0];
    }
}

