/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import io.grpc.Channel;
import java.util.Arrays;
import java.util.List;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.property.v1.BanyandbProperty;
import org.apache.skywalking.banyandb.property.v1.PropertyServiceGrpc;
import org.apache.skywalking.banyandb.v1.client.grpc.HandleExceptionsWith;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;

public class PropertyStore {
    private final PropertyServiceGrpc.PropertyServiceBlockingStub stub;

    public PropertyStore(Channel channel) {
        this.stub = PropertyServiceGrpc.newBlockingStub(channel);
    }

    public BanyandbProperty.ApplyResponse apply(BanyandbProperty.Property payload) throws BanyanDBException {
        return this.apply(payload, BanyandbProperty.ApplyRequest.Strategy.STRATEGY_MERGE);
    }

    public BanyandbProperty.ApplyResponse apply(BanyandbProperty.Property payload, BanyandbProperty.ApplyRequest.Strategy strategy) throws BanyanDBException {
        BanyandbProperty.ApplyRequest.Strategy s = BanyandbProperty.ApplyRequest.Strategy.STRATEGY_MERGE;
        BanyandbProperty.ApplyRequest r = BanyandbProperty.ApplyRequest.newBuilder().setProperty(payload).setStrategy(strategy).build();
        return HandleExceptionsWith.callAndTranslateApiException(() -> this.stub.apply(r));
    }

    public BanyandbProperty.DeleteResponse delete(String group, String name, String id, String ... tags) throws BanyanDBException {
        BanyandbProperty.DeleteRequest.Builder b = BanyandbProperty.DeleteRequest.newBuilder();
        if (tags != null && tags.length > 0) {
            b.addAllTags(Arrays.asList(tags));
        }
        return HandleExceptionsWith.callAndTranslateApiException(() -> this.stub.delete(b.setMetadata(BanyandbProperty.Metadata.newBuilder().setContainer(BanyandbCommon.Metadata.newBuilder().setGroup(group).setName(name).build()).setId(id).build()).build()));
    }

    public BanyandbProperty.Property get(String group, String name, String id, String ... tags) throws BanyanDBException {
        BanyandbProperty.GetRequest.Builder b = BanyandbProperty.GetRequest.newBuilder();
        if (tags != null && tags.length > 0) {
            b.addAllTags(Arrays.asList(tags));
        }
        BanyandbProperty.GetResponse resp = HandleExceptionsWith.callAndTranslateApiException(() -> this.stub.get(b.setMetadata(BanyandbProperty.Metadata.newBuilder().setContainer(BanyandbCommon.Metadata.newBuilder().setGroup(group).setName(name).build()).setId(id).build()).build()));
        return resp.getProperty();
    }

    public List<BanyandbProperty.Property> list(String group, String name, List<String> ids, List<String> tags) throws BanyanDBException {
        BanyandbProperty.ListRequest.Builder builder = BanyandbProperty.ListRequest.newBuilder().setContainer(BanyandbCommon.Metadata.newBuilder().setGroup(group).setName(name).build());
        if (ids != null && ids.size() > 0) {
            builder.addAllIds(ids);
        }
        if (tags != null && tags.size() > 0) {
            builder.addAllTags(tags);
        }
        BanyandbProperty.ListResponse resp = HandleExceptionsWith.callAndTranslateApiException(() -> this.stub.list(builder.build()));
        return resp.getPropertyList();
    }

    public void keepAlive(long leaseId) throws BanyanDBException {
        BanyandbProperty.KeepAliveRequest req = BanyandbProperty.KeepAliveRequest.newBuilder().setLeaseId(leaseId).build();
        HandleExceptionsWith.callAndTranslateApiException(() -> this.stub.keepAlive(req));
    }
}

