/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.model.v1;

import io.envoyproxy.pgv.RepeatedValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import java.util.List;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;

public class BanyandbModelValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(BanyandbModel.Str.class)) {
            return new StrValidator();
        }
        if (clazz.equals(BanyandbModel.Int.class)) {
            return new IntValidator();
        }
        if (clazz.equals(BanyandbModel.Float.class)) {
            return new FloatValidator();
        }
        if (clazz.equals(BanyandbModel.StrArray.class)) {
            return new StrArrayValidator();
        }
        if (clazz.equals(BanyandbModel.IntArray.class)) {
            return new IntArrayValidator();
        }
        if (clazz.equals(BanyandbModel.TagValue.class)) {
            return new TagValueValidator();
        }
        if (clazz.equals(BanyandbModel.TagFamilyForWrite.class)) {
            return new TagFamilyForWriteValidator();
        }
        if (clazz.equals(BanyandbModel.FieldValue.class)) {
            return new FieldValueValidator();
        }
        if (clazz.equals(BanyandbModel.Tag.class)) {
            return new TagValidator();
        }
        if (clazz.equals(BanyandbModel.TagFamily.class)) {
            return new TagFamilyValidator();
        }
        if (clazz.equals(BanyandbModel.Condition.class)) {
            return new ConditionValidator();
        }
        if (clazz.equals(BanyandbModel.Criteria.class)) {
            return new CriteriaValidator();
        }
        if (clazz.equals(BanyandbModel.LogicalExpression.class)) {
            return new LogicalExpressionValidator();
        }
        if (clazz.equals(BanyandbModel.QueryOrder.class)) {
            return new QueryOrderValidator();
        }
        if (clazz.equals(BanyandbModel.TagProjection.class)) {
            return new TagProjectionValidator();
        }
        if (clazz.equals(BanyandbModel.TimeRange.class)) {
            return new TimeRangeValidator();
        }
        if (clazz.equals(BanyandbModel.Condition.MatchOption.class)) {
            return new Condition_MatchOptionValidator();
        }
        if (clazz.equals(BanyandbModel.TagProjection.TagFamily.class)) {
            return new TagProjection_TagFamilyValidator();
        }
        return null;
    }

    public static class StrValidator
    implements ValidatorImpl<BanyandbModel.Str> {
        public void assertValid(BanyandbModel.Str proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class IntValidator
    implements ValidatorImpl<BanyandbModel.Int> {
        public void assertValid(BanyandbModel.Int proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class FloatValidator
    implements ValidatorImpl<BanyandbModel.Float> {
        public void assertValid(BanyandbModel.Float proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class StrArrayValidator
    implements ValidatorImpl<BanyandbModel.StrArray> {
        public void assertValid(BanyandbModel.StrArray proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach((List)proto.getValueList(), item -> {});
        }
    }

    public static class IntArrayValidator
    implements ValidatorImpl<BanyandbModel.IntArray> {
        public void assertValid(BanyandbModel.IntArray proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getValueList(), item -> {});
        }
    }

    public static class TagValueValidator
    implements ValidatorImpl<BanyandbModel.TagValue> {
        public void assertValid(BanyandbModel.TagValue proto, ValidatorIndex index) throws ValidationException {
            switch (proto.getValueCase()) {
                case NULL: {
                    break;
                }
                case STR: {
                    if (!proto.hasStr()) break;
                    index.validatorFor((Object)proto.getStr()).assertValid((Object)proto.getStr());
                    break;
                }
                case STR_ARRAY: {
                    if (!proto.hasStrArray()) break;
                    index.validatorFor((Object)proto.getStrArray()).assertValid((Object)proto.getStrArray());
                    break;
                }
                case INT: {
                    if (!proto.hasInt()) break;
                    index.validatorFor((Object)proto.getInt()).assertValid((Object)proto.getInt());
                    break;
                }
                case INT_ARRAY: {
                    if (!proto.hasIntArray()) break;
                    index.validatorFor((Object)proto.getIntArray()).assertValid((Object)proto.getIntArray());
                    break;
                }
            }
        }
    }

    public static class TagFamilyForWriteValidator
    implements ValidatorImpl<BanyandbModel.TagFamilyForWrite> {
        public void assertValid(BanyandbModel.TagFamilyForWrite proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getTagsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class FieldValueValidator
    implements ValidatorImpl<BanyandbModel.FieldValue> {
        public void assertValid(BanyandbModel.FieldValue proto, ValidatorIndex index) throws ValidationException {
            switch (proto.getValueCase()) {
                case NULL: {
                    break;
                }
                case STR: {
                    if (!proto.hasStr()) break;
                    index.validatorFor((Object)proto.getStr()).assertValid((Object)proto.getStr());
                    break;
                }
                case INT: {
                    if (!proto.hasInt()) break;
                    index.validatorFor((Object)proto.getInt()).assertValid((Object)proto.getInt());
                    break;
                }
                case BINARY_DATA: {
                    break;
                }
                case FLOAT: {
                    if (!proto.hasFloat()) break;
                    index.validatorFor((Object)proto.getFloat()).assertValid((Object)proto.getFloat());
                }
            }
        }
    }

    public static class TagValidator
    implements ValidatorImpl<BanyandbModel.Tag> {
        public void assertValid(BanyandbModel.Tag proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasValue()) {
                index.validatorFor((Object)proto.getValue()).assertValid((Object)proto.getValue());
            }
        }
    }

    public static class TagFamilyValidator
    implements ValidatorImpl<BanyandbModel.TagFamily> {
        public void assertValid(BanyandbModel.TagFamily proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getTagsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class ConditionValidator
    implements ValidatorImpl<BanyandbModel.Condition> {
        public void assertValid(BanyandbModel.Condition proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasValue()) {
                index.validatorFor((Object)proto.getValue()).assertValid((Object)proto.getValue());
            }
            if (proto.hasMatchOption()) {
                index.validatorFor((Object)proto.getMatchOption()).assertValid((Object)proto.getMatchOption());
            }
        }
    }

    public static class CriteriaValidator
    implements ValidatorImpl<BanyandbModel.Criteria> {
        public void assertValid(BanyandbModel.Criteria proto, ValidatorIndex index) throws ValidationException {
            switch (proto.getExpCase()) {
                case LE: {
                    if (!proto.hasLe()) break;
                    index.validatorFor((Object)proto.getLe()).assertValid((Object)proto.getLe());
                    break;
                }
                case CONDITION: {
                    if (!proto.hasCondition()) break;
                    index.validatorFor((Object)proto.getCondition()).assertValid((Object)proto.getCondition());
                }
            }
        }
    }

    public static class LogicalExpressionValidator
    implements ValidatorImpl<BanyandbModel.LogicalExpression> {
        public void assertValid(BanyandbModel.LogicalExpression proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasLeft()) {
                index.validatorFor((Object)proto.getLeft()).assertValid((Object)proto.getLeft());
            }
            if (proto.hasRight()) {
                index.validatorFor((Object)proto.getRight()).assertValid((Object)proto.getRight());
            }
        }
    }

    public static class QueryOrderValidator
    implements ValidatorImpl<BanyandbModel.QueryOrder> {
        public void assertValid(BanyandbModel.QueryOrder proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class TagProjectionValidator
    implements ValidatorImpl<BanyandbModel.TagProjection> {
        public void assertValid(BanyandbModel.TagProjection proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getTagFamiliesList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class TimeRangeValidator
    implements ValidatorImpl<BanyandbModel.TimeRange> {
        public void assertValid(BanyandbModel.TimeRange proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasBegin()) {
                index.validatorFor((Object)proto.getBegin()).assertValid((Object)proto.getBegin());
            }
            if (proto.hasEnd()) {
                index.validatorFor((Object)proto.getEnd()).assertValid((Object)proto.getEnd());
            }
        }
    }

    public static class Condition_MatchOptionValidator
    implements ValidatorImpl<BanyandbModel.Condition.MatchOption> {
        public void assertValid(BanyandbModel.Condition.MatchOption proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class TagProjection_TagFamilyValidator
    implements ValidatorImpl<BanyandbModel.TagProjection.TagFamily> {
        public void assertValid(BanyandbModel.TagProjection.TagFamily proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach((List)proto.getTagsList(), item -> {});
        }
    }
}

