/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.skywalking.banyandb.v1.client.metadata.Measure;
import org.apache.skywalking.banyandb.v1.client.metadata.Stream;
import org.apache.skywalking.banyandb.v1.client.metadata.TagFamilySpec;
import org.apache.skywalking.banyandb.v1.client.util.CopyOnWriteMap;

public class MetadataCache {
    private final Map<String, EntityMetadata> cache = new CopyOnWriteMap<String, EntityMetadata>();

    public Stream register(Stream stream) {
        this.cache.put(MetadataCache.formatKey(stream.group(), stream.name()), MetadataCache.parse(stream));
        return stream;
    }

    public EntityMetadata unregister(Stream stream) {
        return this.cache.remove(MetadataCache.formatKey(stream.group(), stream.name()));
    }

    public Measure register(Measure measure) {
        this.cache.put(MetadataCache.formatKey(measure.group(), measure.name()), MetadataCache.parse(measure));
        return measure;
    }

    public EntityMetadata unregister(Measure measure) {
        return this.cache.remove(MetadataCache.formatKey(measure.group(), measure.name()));
    }

    public EntityMetadata findMetadata(String group, String name) {
        return this.cache.get(MetadataCache.formatKey(group, name));
    }

    static String formatKey(String group, String name) {
        return group + ":" + name;
    }

    static EntityMetadata parse(Stream s) {
        int totalTags = 0;
        int[] tagFamilyCapacity = new int[s.tagFamilies().size()];
        HashMap<String, TagInfo> tagInfo = new HashMap<String, TagInfo>();
        int k = 0;
        for (int i = 0; i < s.tagFamilies().size(); ++i) {
            String tagFamilyName = ((TagFamilySpec)s.tagFamilies().get(i)).tagFamilyName();
            tagFamilyCapacity[i] = ((TagFamilySpec)s.tagFamilies().get(i)).tagSpecs().size();
            totalTags += tagFamilyCapacity[i];
            for (int j = 0; j < tagFamilyCapacity[i]; ++j) {
                tagInfo.put(((TagFamilySpec.TagSpec)((TagFamilySpec)s.tagFamilies().get(i)).tagSpecs().get(j)).getTagName(), new TagInfo(tagFamilyName, k++));
            }
        }
        return new EntityMetadata(s.group(), s.name(), s.modRevision(), totalTags, 0, tagFamilyCapacity, Collections.unmodifiableMap(tagInfo), Collections.emptyMap());
    }

    static EntityMetadata parse(Measure m) {
        int totalTags = 0;
        int[] tagFamilyCapacity = new int[m.tagFamilies().size()];
        HashMap<String, TagInfo> tagOffset = new HashMap<String, TagInfo>();
        int k = 0;
        for (int i = 0; i < m.tagFamilies().size(); ++i) {
            String tagFamilyName = ((TagFamilySpec)m.tagFamilies().get(i)).tagFamilyName();
            tagFamilyCapacity[i] = ((TagFamilySpec)m.tagFamilies().get(i)).tagSpecs().size();
            totalTags += tagFamilyCapacity[i];
            for (int j = 0; j < tagFamilyCapacity[i]; ++j) {
                tagOffset.put(((TagFamilySpec.TagSpec)((TagFamilySpec)m.tagFamilies().get(i)).tagSpecs().get(j)).getTagName(), new TagInfo(tagFamilyName, k++));
            }
        }
        HashMap<String, Integer> fieldOffset = new HashMap<String, Integer>();
        for (int i = 0; i < m.fields().size(); ++i) {
            fieldOffset.put(((Measure.FieldSpec)m.fields().get(i)).getName(), i);
        }
        return new EntityMetadata(m.group(), m.name(), m.modRevision(), totalTags, m.fields().size(), tagFamilyCapacity, Collections.unmodifiableMap(tagOffset), Collections.unmodifiableMap(fieldOffset));
    }

    public static class TagInfo {
        private final String tagFamilyName;
        private final int offset;

        public TagInfo(String tagFamilyName, int offset) {
            this.tagFamilyName = tagFamilyName;
            this.offset = offset;
        }

        public String getTagFamilyName() {
            return this.tagFamilyName;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    public static class EntityMetadata {
        private final String group;
        private final String name;
        private final long modRevision;
        private final int totalTags;
        private final int totalFields;
        private final int[] tagFamilyCapacity;
        private final Map<String, TagInfo> tagOffset;
        private final Map<String, Integer> fieldOffset;

        public Optional<TagInfo> findTagInfo(String name) {
            return Optional.ofNullable(this.tagOffset.get(name));
        }

        public int findFieldInfo(String name) {
            return this.fieldOffset.get(name);
        }

        public String getGroup() {
            return this.group;
        }

        public String getName() {
            return this.name;
        }

        public long getModRevision() {
            return this.modRevision;
        }

        public int getTotalTags() {
            return this.totalTags;
        }

        public int getTotalFields() {
            return this.totalFields;
        }

        public int[] getTagFamilyCapacity() {
            return this.tagFamilyCapacity;
        }

        public Map<String, TagInfo> getTagOffset() {
            return this.tagOffset;
        }

        public Map<String, Integer> getFieldOffset() {
            return this.fieldOffset;
        }

        public EntityMetadata(String group, String name, long modRevision, int totalTags, int totalFields, int[] tagFamilyCapacity, Map<String, TagInfo> tagOffset, Map<String, Integer> fieldOffset) {
            this.group = group;
            this.name = name;
            this.modRevision = modRevision;
            this.totalTags = totalTags;
            this.totalFields = totalFields;
            this.tagFamilyCapacity = tagFamilyCapacity;
            this.tagOffset = tagOffset;
            this.fieldOffset = fieldOffset;
        }
    }
}

