/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import io.grpc.Channel;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.database.v1.MeasureRegistryServiceGrpc;
import org.apache.skywalking.banyandb.v1.client.grpc.MetadataClient;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.Measure;
import org.apache.skywalking.banyandb.v1.client.metadata.ResourceExist;

public class MeasureMetadataRegistry
extends MetadataClient<MeasureRegistryServiceGrpc.MeasureRegistryServiceBlockingStub, BanyandbDatabase.Measure, Measure> {
    public MeasureMetadataRegistry(Channel channel) {
        super(MeasureRegistryServiceGrpc.newBlockingStub(channel));
    }

    @Override
    public long create(Measure payload) throws BanyanDBException {
        BanyandbDatabase.MeasureRegistryServiceCreateResponse resp = this.execute(() -> ((MeasureRegistryServiceGrpc.MeasureRegistryServiceBlockingStub)this.stub).create(BanyandbDatabase.MeasureRegistryServiceCreateRequest.newBuilder().setMeasure(payload.serialize()).build()));
        return resp.getModRevision();
    }

    @Override
    public void update(Measure payload) throws BanyanDBException {
        this.execute(() -> ((MeasureRegistryServiceGrpc.MeasureRegistryServiceBlockingStub)this.stub).update(BanyandbDatabase.MeasureRegistryServiceUpdateRequest.newBuilder().setMeasure(payload.serialize()).build()));
    }

    @Override
    public boolean delete(String group, String name) throws BanyanDBException {
        BanyandbDatabase.MeasureRegistryServiceDeleteResponse resp = this.execute(() -> ((MeasureRegistryServiceGrpc.MeasureRegistryServiceBlockingStub)this.stub).delete(BanyandbDatabase.MeasureRegistryServiceDeleteRequest.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(group).setName(name).build()).build()));
        return resp != null && resp.getDeleted();
    }

    @Override
    public Measure get(String group, String name) throws BanyanDBException {
        BanyandbDatabase.MeasureRegistryServiceGetResponse resp = this.execute(() -> ((MeasureRegistryServiceGrpc.MeasureRegistryServiceBlockingStub)this.stub).get(BanyandbDatabase.MeasureRegistryServiceGetRequest.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(group).setName(name).build()).build()));
        return Measure.fromProtobuf(resp.getMeasure());
    }

    @Override
    public ResourceExist exist(String group, String name) throws BanyanDBException {
        BanyandbDatabase.MeasureRegistryServiceExistResponse resp = this.execute(() -> ((MeasureRegistryServiceGrpc.MeasureRegistryServiceBlockingStub)this.stub).exist(BanyandbDatabase.MeasureRegistryServiceExistRequest.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(group).setName(name).build()).build()));
        return ResourceExist.create(resp.getHasGroup(), resp.getHasMeasure());
    }

    @Override
    public List<Measure> list(String group) throws BanyanDBException {
        BanyandbDatabase.MeasureRegistryServiceListResponse resp = this.execute(() -> ((MeasureRegistryServiceGrpc.MeasureRegistryServiceBlockingStub)this.stub).list(BanyandbDatabase.MeasureRegistryServiceListRequest.newBuilder().setGroup(group).build()));
        return resp.getMeasureList().stream().map(Measure::fromProtobuf).collect(Collectors.toList());
    }
}

