/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.v1.client.metadata.AutoValue_IndexRuleBinding;
import org.apache.skywalking.banyandb.v1.client.metadata.Catalog;
import org.apache.skywalking.banyandb.v1.client.metadata.NamedSchema;
import org.apache.skywalking.banyandb.v1.client.metadata.Serializable;
import org.apache.skywalking.banyandb.v1.client.util.TimeUtils;

@AutoValue
public abstract class IndexRuleBinding
extends NamedSchema<BanyandbDatabase.IndexRuleBinding> {
    private static final ZonedDateTime DEFAULT_EXPIRE_AT = ZonedDateTime.of(2099, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);

    public abstract ImmutableList<String> rules();

    abstract Subject subject();

    abstract ZonedDateTime beginAt();

    abstract ZonedDateTime expireAt();

    public static IndexRuleBinding create(String group, String name, Subject subject, List<String> rules) {
        return new AutoValue_IndexRuleBinding(group, name, null, (ImmutableList<String>)ImmutableList.copyOf(rules), subject, ZonedDateTime.now(), DEFAULT_EXPIRE_AT);
    }

    @VisibleForTesting
    static IndexRuleBinding create(String group, String name, Subject subject, List<String> rules, ZonedDateTime beginAt, ZonedDateTime expireAt) {
        return new AutoValue_IndexRuleBinding(group, name, null, (ImmutableList<String>)ImmutableList.copyOf(rules), subject, beginAt, expireAt);
    }

    public static String defaultBindingRule(String entityName) {
        return entityName + "-index-rule-binding";
    }

    @Override
    public BanyandbDatabase.IndexRuleBinding serialize() {
        BanyandbDatabase.IndexRuleBinding.Builder b = BanyandbDatabase.IndexRuleBinding.newBuilder().setMetadata(this.buildMetadata()).addAllRules((Iterable<String>)this.rules()).setSubject(this.subject().serialize()).setBeginAt(TimeUtils.buildTimestamp(this.beginAt())).setExpireAt(TimeUtils.buildTimestamp(this.expireAt()));
        if (this.updatedAt() != null) {
            b.setUpdatedAt(TimeUtils.buildTimestamp(this.updatedAt()));
        }
        return b.build();
    }

    static IndexRuleBinding fromProtobuf(BanyandbDatabase.IndexRuleBinding pb) {
        return new AutoValue_IndexRuleBinding(pb.getMetadata().getGroup(), pb.getMetadata().getName(), TimeUtils.parseTimestamp(pb.getUpdatedAt()), (ImmutableList<String>)ImmutableList.copyOf((Collection)pb.getRulesList()), Subject.fromProtobuf(pb.getSubject()), TimeUtils.parseTimestamp(pb.getBeginAt()), TimeUtils.parseTimestamp(pb.getExpireAt()));
    }

    public static class Subject
    implements Serializable<BanyandbDatabase.Subject> {
        private final String name;
        private final Catalog catalog;

        @Override
        public BanyandbDatabase.Subject serialize() {
            return BanyandbDatabase.Subject.newBuilder().setName(this.name).setCatalog(this.catalog.getCatalog()).build();
        }

        public static Subject referToStream(String name) {
            return new Subject(name, Catalog.STREAM);
        }

        public static Subject referToMeasure(String name) {
            return new Subject(name, Catalog.MEASURE);
        }

        private static Subject fromProtobuf(BanyandbDatabase.Subject pb) {
            switch (pb.getCatalog()) {
                case CATALOG_STREAM: {
                    return Subject.referToStream(pb.getName());
                }
                case CATALOG_MEASURE: {
                    return Subject.referToMeasure(pb.getName());
                }
            }
            throw new IllegalArgumentException("unrecognized catalog");
        }

        public Subject(String name, Catalog catalog) {
            this.name = name;
            this.catalog = catalog;
        }

        public String getName() {
            return this.name;
        }

        public Catalog getCatalog() {
            return this.catalog;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Subject)) {
                return false;
            }
            Subject other = (Subject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Catalog this$catalog = this.getCatalog();
            Catalog other$catalog = other.getCatalog();
            return !(this$catalog == null ? other$catalog != null : !((Object)((Object)this$catalog)).equals((Object)other$catalog));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Subject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Catalog $catalog = this.getCatalog();
            result = result * 59 + ($catalog == null ? 43 : ((Object)((Object)$catalog)).hashCode());
            return result;
        }
    }
}

