/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.grpc.channel;

import com.google.common.base.Strings;
import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import org.apache.skywalking.banyandb.v1.client.Options;
import org.apache.skywalking.banyandb.v1.client.grpc.channel.ChannelFactory;
import org.apache.skywalking.banyandb.v1.client.util.PrivateKeyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChannelFactory
implements ChannelFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultChannelFactory.class);
    private final URI[] targets;
    private final Options options;
    private SocketAddress[] addresses;
    private long lastTargetsResolvedTime;

    @Override
    public ManagedChannel create() throws IOException {
        boolean isCAFileExist;
        if (this.addresses == null || System.currentTimeMillis() - this.lastTargetsResolvedTime > this.options.getResolveDNSInterval()) {
            this.resolveTargets();
        }
        NettyChannelBuilder managedChannelBuilder = NettyChannelBuilder.forAddress((SocketAddress)this.resolveAddress()).maxInboundMessageSize(this.options.getMaxInboundMessageSize()).usePlaintext();
        File caFile = new File(this.options.getSslTrustCAPath());
        boolean bl = isCAFileExist = caFile.exists() && caFile.isFile();
        if (this.options.isForceTLS() || isCAFileExist) {
            SslContextBuilder builder = GrpcSslContexts.forClient();
            if (isCAFileExist) {
                block17: {
                    String certPath = this.options.getSslCertChainPath();
                    String keyPath = this.options.getSslKeyPath();
                    if (!Strings.isNullOrEmpty((String)certPath) && Strings.isNullOrEmpty((String)keyPath)) {
                        File keyFile = new File(keyPath);
                        File certFile = new File(certPath);
                        if (certFile.isFile() && keyFile.isFile()) {
                            try (FileInputStream cert = new FileInputStream(certFile);
                                 InputStream key = PrivateKeyUtil.loadDecryptionKey(keyFile.getAbsolutePath());){
                                builder.keyManager((InputStream)cert, key);
                                break block17;
                            }
                        }
                        if (!certFile.isFile() || !keyFile.isFile()) {
                            log.warn("Failed to enable mTLS caused by cert or key cannot be found.");
                        }
                    }
                }
                builder.trustManager(caFile);
            }
            managedChannelBuilder.negotiationType(NegotiationType.TLS).sslContext(builder.build());
        }
        return managedChannelBuilder.build();
    }

    private void resolveTargets() {
        this.addresses = (SocketAddress[])Arrays.stream(this.targets).flatMap(target -> {
            try {
                return Arrays.stream(SocketUtils.allAddressesByName((String)target.getHost())).map(InetAddress::getHostAddress).map(ip -> new InetSocketAddress((String)ip, target.getPort()));
            }
            catch (Throwable t) {
                log.error("Failed to resolve the BanyanDB server's address ", t);
                return Stream.empty();
            }
        }).sorted(Comparator.comparing(InetSocketAddress::toString)).distinct().toArray(InetSocketAddress[]::new);
        this.lastTargetsResolvedTime = System.currentTimeMillis();
    }

    private SocketAddress resolveAddress() throws UnknownHostException {
        int numAddresses = this.addresses.length;
        if (numAddresses < 1) {
            throw new UnknownHostException();
        }
        int offset = numAddresses == 1 ? 0 : PlatformDependent.threadLocalRandom().nextInt(numAddresses);
        return this.addresses[offset];
    }

    public DefaultChannelFactory(URI[] targets, Options options) {
        this.targets = targets;
        this.options = options;
    }
}

