/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import io.grpc.stub.StreamObserver;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.measure.v1.BanyandbMeasure;
import org.apache.skywalking.banyandb.measure.v1.MeasureServiceGrpc;
import org.apache.skywalking.banyandb.v1.client.AbstractBulkWriteProcessor;
import org.apache.skywalking.banyandb.v1.client.BanyanDBClient;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MeasureBulkWriteProcessor
extends AbstractBulkWriteProcessor<BanyandbMeasure.WriteRequest, MeasureServiceGrpc.MeasureServiceStub> {
    private static final Logger log = LoggerFactory.getLogger(MeasureBulkWriteProcessor.class);
    private final BanyanDBClient client;

    protected MeasureBulkWriteProcessor(BanyanDBClient client, int maxBulkSize, int flushInterval, int concurrency, int timeout) {
        super(client.getMeasureServiceStub(), "MeasureBulkWriteProcessor", maxBulkSize, flushInterval, concurrency, timeout);
        this.client = client;
    }

    @Override
    protected StreamObserver<BanyandbMeasure.WriteRequest> buildStreamObserver(MeasureServiceGrpc.MeasureServiceStub stub, final CompletableFuture<Void> batch) {
        return stub.write(new StreamObserver<BanyandbMeasure.WriteResponse>(){
            private final Set<String> schemaExpired = new HashSet<String>();

            public void onNext(BanyandbMeasure.WriteResponse writeResponse) {
                switch (writeResponse.getStatus()) {
                    case STATUS_EXPIRED_SCHEMA: {
                        BanyandbCommon.Metadata metadata = writeResponse.getMetadata();
                        String schemaKey = metadata.getGroup() + "." + metadata.getName();
                        if (this.schemaExpired.contains(schemaKey)) break;
                        log.warn("The schema {} is expired, trying update the schema...", (Object)schemaKey);
                        try {
                            MeasureBulkWriteProcessor.this.client.findMeasure(metadata.getGroup(), metadata.getName());
                            this.schemaExpired.add(schemaKey);
                        }
                        catch (BanyanDBException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        break;
                    }
                }
            }

            public void onError(Throwable t) {
                batch.completeExceptionally(t);
                log.error("Error occurs in flushing measures", t);
            }

            public void onCompleted() {
                batch.complete(null);
            }
        });
    }
}

