/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.meter.micrometer;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.meter.micrometer.SkywalkingConfig;
import org.apache.skywalking.apm.toolkit.meter.Counter;
import org.apache.skywalking.apm.toolkit.meter.Histogram;
import org.apache.skywalking.apm.toolkit.meter.MeterFactory;
import org.apache.skywalking.apm.toolkit.meter.MeterId;

public class MeterBuilder {
    public static Counter buildCounter(MeterId meterId, SkywalkingConfig config) {
        return (Counter)MeterFactory.counter((MeterId)meterId).mode(MeterBuilder.getCounterMode(meterId, config)).build();
    }

    public static Counter.Mode getCounterMode(MeterId meterId, SkywalkingConfig config) {
        return config.isRateCounter(meterId.getName()) ? Counter.Mode.RATE : Counter.Mode.INCREMENT;
    }

    public static Optional<Histogram> buildHistogram(MeterId meterId, boolean supportsAggregablePercentiles, DistributionStatisticConfig distributionStatisticConfig, boolean useNanoTime) {
        if (!distributionStatisticConfig.isPublishingHistogram()) {
            return Optional.empty();
        }
        NavigableSet buckets = distributionStatisticConfig.getHistogramBuckets(supportsAggregablePercentiles);
        List steps = buckets.stream().sorted(Double::compare).map(t -> useNanoTime ? TimeUtils.nanosToUnit((double)t, (TimeUnit)TimeUnit.MILLISECONDS) : t).collect(Collectors.toList());
        Histogram.Builder histogramBuilder = MeterFactory.histogram((MeterId)meterId.copyTo(meterId.getName() + "_histogram", MeterId.MeterType.HISTOGRAM)).steps(steps);
        Double minimumExpectedValueAsDouble = distributionStatisticConfig.getMinimumExpectedValueAsDouble();
        if (minimumExpectedValueAsDouble != null) {
            histogramBuilder.minValue(useNanoTime ? TimeUtils.nanosToUnit((double)minimumExpectedValueAsDouble, (TimeUnit)TimeUnit.MILLISECONDS) : minimumExpectedValueAsDouble);
        }
        return Optional.of((Histogram)histogramBuilder.build());
    }

    public static MeterId convertId(Meter.Id id, String name) {
        MeterId.MeterType type;
        switch (id.getType()) {
            case COUNTER: {
                type = MeterId.MeterType.COUNTER;
                break;
            }
            case GAUGE: {
                type = MeterId.MeterType.GAUGE;
                break;
            }
            default: {
                type = MeterId.MeterType.HISTOGRAM;
            }
        }
        List tags = id.getTags().stream().map(t -> new MeterId.Tag(t.getKey(), t.getValue())).collect(Collectors.toList());
        MeterId meterId = new MeterId(name, type, tags);
        return meterId;
    }
}

