/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.meter.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.toolkit.meter.Histogram;
import org.apache.skywalking.apm.toolkit.meter.MeterId;
import org.apache.skywalking.apm.toolkit.meter.impl.AbstractBuilder;
import org.apache.skywalking.apm.toolkit.meter.impl.AbstractMeter;

public class HistogramImpl
extends AbstractMeter
implements Histogram {
    protected final Bucket[] buckets;
    protected final List<Double> steps;

    public static Builder create(String name) {
        return new Builder(name);
    }

    protected HistogramImpl(MeterId meterId, List<Double> steps) {
        super(meterId);
        this.steps = steps;
        this.buckets = this.initBuckets(steps);
    }

    @Override
    public void addValue(double value) {
        Bucket bucket = this.findBucket(value);
        if (bucket == null) {
            return;
        }
        bucket.increment(1L);
    }

    public Bucket[] getBuckets() {
        return this.buckets;
    }

    private Bucket findBucket(double value) {
        int low = 0;
        int high = this.buckets.length - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            if (this.buckets[mid].bucket < value) {
                low = mid + 1;
                continue;
            }
            if (this.buckets[mid].bucket > value) {
                high = mid - 1;
                continue;
            }
            return this.buckets[mid];
        }
        return --low < this.buckets.length && low >= 0 ? this.buckets[low] : null;
    }

    private Bucket[] initBuckets(List<Double> buckets) {
        Bucket[] list = new Bucket[buckets.size()];
        for (int i = 0; i < buckets.size(); ++i) {
            list[i] = new Bucket(buckets.get(i));
        }
        return list;
    }

    private static class Bucket
    implements Histogram.Bucket {
        protected double bucket;
        protected AtomicLong count = new AtomicLong();

        public Bucket(double bucket) {
            this.bucket = bucket;
        }

        public void increment(long count) {
            this.count.addAndGet(count);
        }

        @Override
        public double getBucket() {
            return this.bucket;
        }

        @Override
        public long getCount() {
            return this.count.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bucket bucket1 = (Bucket)o;
            return this.bucket == bucket1.bucket;
        }

        public int hashCode() {
            return Objects.hash(this.bucket);
        }
    }

    public static class Builder
    extends AbstractBuilder<Histogram.Builder, Histogram, HistogramImpl>
    implements Histogram.Builder {
        private double minValue = 0.0;
        private List<Double> steps;

        public Builder(String name) {
            super(name);
        }

        public Builder(MeterId meterId) {
            super(meterId);
        }

        @Override
        public Builder steps(List<Double> steps) {
            this.steps = new ArrayList<Double>(steps);
            return this;
        }

        @Override
        public Builder minValue(double minValue) {
            this.minValue = minValue;
            return this;
        }

        @Override
        public void accept(HistogramImpl meter) {
            if (this.steps.get(0) != this.minValue) {
                this.steps.add(0, this.minValue);
            }
            if (meter.buckets.length != this.steps.size()) {
                throw new IllegalArgumentException("Steps are not has the same size");
            }
            ArrayList<Double> meterSteps = new ArrayList<Double>(meter.buckets.length);
            for (Bucket bucket : meter.buckets) {
                meterSteps.add(bucket.bucket);
            }
            if (!Objects.equals(meterSteps, this.steps)) {
                throw new IllegalArgumentException("Steps are not the same");
            }
        }

        @Override
        public HistogramImpl create(MeterId meterId) {
            if (this.steps == null || this.steps.isEmpty()) {
                throw new IllegalArgumentException("Missing steps setting");
            }
            this.steps = this.steps.stream().distinct().sorted().collect(Collectors.toList());
            if (this.steps.get(0) < this.minValue) {
                throw new IllegalArgumentException("First step must bigger than min value");
            }
            if (this.steps.get(0) != this.minValue) {
                this.steps.add(0, this.minValue);
            }
            return new HistogramImpl(meterId, this.steps);
        }

        @Override
        public MeterId.MeterType getType() {
            return MeterId.MeterType.HISTOGRAM;
        }
    }
}

