/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.meter.impl;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.DoubleAdder;
import org.apache.skywalking.apm.toolkit.meter.Counter;
import org.apache.skywalking.apm.toolkit.meter.MeterId;
import org.apache.skywalking.apm.toolkit.meter.impl.AbstractBuilder;
import org.apache.skywalking.apm.toolkit.meter.impl.AbstractMeter;

public class CounterImpl
extends AbstractMeter
implements Counter {
    protected final DoubleAdder count;
    protected final Counter.Mode mode;
    private final AtomicReference<Double> previous = new AtomicReference();

    protected CounterImpl(MeterId meterId, Counter.Mode mode) {
        super(meterId);
        this.count = new DoubleAdder();
        this.mode = mode;
    }

    @Override
    public void increment(double count) {
        this.count.add(count);
    }

    @Override
    public double get() {
        return this.count.doubleValue();
    }

    public double agentGet() {
        Double previousValue;
        double currentValue = this.get();
        double count = Objects.equals((Object)Counter.Mode.RATE, (Object)this.mode) ? ((previousValue = this.previous.getAndSet(currentValue)) == null ? currentValue : currentValue - previousValue) : currentValue;
        return count;
    }

    public static class Builder
    extends AbstractBuilder<Counter.Builder, Counter, CounterImpl>
    implements Counter.Builder {
        private Counter.Mode mode = Counter.Mode.INCREMENT;

        public Builder(String name) {
            super(name);
        }

        public Builder(MeterId meterId) {
            super(meterId);
        }

        @Override
        public Builder mode(Counter.Mode mode) {
            this.mode = mode;
            return this;
        }

        @Override
        protected void accept(CounterImpl meter) throws IllegalArgumentException {
            if (!Objects.equals((Object)meter.mode, (Object)this.mode)) {
                throw new IllegalArgumentException("Mode is not same");
            }
        }

        @Override
        protected Counter create(MeterId meterId) {
            return new CounterImpl(meterId, this.mode);
        }

        @Override
        protected MeterId.MeterType getType() {
            return MeterId.MeterType.COUNTER;
        }
    }
}

