/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.sjdbc;

import com.dangdang.ddframe.rdb.sharding.executor.event.AbstractExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.event.DMLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.event.DQLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.threadlocal.ExecutorDataMap;
import com.dangdang.ddframe.rdb.sharding.util.EventBusInstance;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class ExecuteEventListener {
    public static void init() {
        EventBusInstance.getInstance().register((Object)new ExecuteEventListener());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void listenDML(DMLExecutionEvent event) {
        this.handle((AbstractExecutionEvent)event, "MODIFY");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void listenDQL(DQLExecutionEvent event) {
        this.handle((AbstractExecutionEvent)event, "QUERY");
    }

    private void handle(AbstractExecutionEvent event, String operation) {
        switch (event.getEventExecutionType()) {
            case BEFORE_EXECUTE: {
                AbstractSpan span = ContextManager.createExitSpan((String)("/SJDBC/BRANCH/" + operation), (String)event.getDataSource());
                if (ExecutorDataMap.getDataMap().containsKey("APM_SKYWALKING_SNAPSHOT_DATA")) {
                    ContextManager.continued((ContextSnapshot)((ContextSnapshot)ExecutorDataMap.getDataMap().get("APM_SKYWALKING_SNAPSHOT_DATA")));
                }
                Tags.DB_TYPE.set(span, "sql");
                Tags.DB_INSTANCE.set(span, event.getDataSource());
                Tags.DB_STATEMENT.set(span, event.getSql());
                if (!event.getParameters().isEmpty()) {
                    String variables = event.getParameters().stream().map(String::valueOf).collect(Collectors.joining(","));
                    Tags.DB_BIND_VARIABLES.set(span, variables);
                }
                span.setComponent((Component)ComponentsDefine.SHARDING_JDBC);
                SpanLayer.asDB((AbstractSpan)span);
                break;
            }
            case EXECUTE_FAILURE: {
                AbstractSpan span = ContextManager.activeSpan();
                span.errorOccurred();
                if (event.getException().isPresent()) {
                    span.log((Throwable)event.getException().get());
                }
            }
            case EXECUTE_SUCCESS: {
                ContextManager.stopSpan();
            }
        }
    }
}

