/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.mongodb.v3;

import com.mongodb.ServerAddress;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.ServerDescription;
import com.mongodb.operation.CountOperation;
import com.mongodb.operation.CreateCollectionOperation;
import com.mongodb.operation.CreateIndexesOperation;
import com.mongodb.operation.CreateViewOperation;
import com.mongodb.operation.DeleteOperation;
import com.mongodb.operation.DistinctOperation;
import com.mongodb.operation.FindAndDeleteOperation;
import com.mongodb.operation.FindAndReplaceOperation;
import com.mongodb.operation.FindAndUpdateOperation;
import com.mongodb.operation.FindOperation;
import com.mongodb.operation.GroupOperation;
import com.mongodb.operation.InsertOperation;
import com.mongodb.operation.ListCollectionsOperation;
import com.mongodb.operation.MapReduceToCollectionOperation;
import com.mongodb.operation.MapReduceWithInlineResultsOperation;
import com.mongodb.operation.MixedBulkWriteOperation;
import com.mongodb.operation.UpdateOperation;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.bson.BsonDocument;

public class MongoDBMethodInterceptor
implements InstanceMethodsAroundInterceptor,
InstanceConstructorInterceptor {
    private static final String DB_TYPE = "MongoDB";
    private static final String MONGO_DB_OP_PREFIX = "MongoDB/";
    private static final int FILTER_LENGTH_LIMIT = 256;
    private static final String EMPTY = "";

    private String getTraceParam(Object obj) {
        if (obj instanceof CountOperation) {
            BsonDocument filter = ((CountOperation)obj).getFilter();
            return this.limitFilter(filter.toString());
        }
        if (obj instanceof DistinctOperation) {
            BsonDocument filter = ((DistinctOperation)obj).getFilter();
            return this.limitFilter(filter.toString());
        }
        if (obj instanceof FindOperation) {
            BsonDocument filter = ((FindOperation)obj).getFilter();
            return this.limitFilter(filter.toString());
        }
        if (obj instanceof GroupOperation) {
            BsonDocument filter = ((GroupOperation)obj).getFilter();
            return this.limitFilter(filter.toString());
        }
        if (obj instanceof ListCollectionsOperation) {
            BsonDocument filter = ((ListCollectionsOperation)obj).getFilter();
            return this.limitFilter(filter.toString());
        }
        if (obj instanceof MapReduceWithInlineResultsOperation) {
            BsonDocument filter = ((ListCollectionsOperation)obj).getFilter();
            return this.limitFilter(filter.toString());
        }
        if (obj instanceof DeleteOperation) {
            List writeRequestList = ((DeleteOperation)obj).getDeleteRequests();
            return this.getFilter(writeRequestList);
        }
        if (obj instanceof InsertOperation) {
            List writeRequestList = ((InsertOperation)obj).getInsertRequests();
            return this.getFilter(writeRequestList);
        }
        if (obj instanceof UpdateOperation) {
            List writeRequestList = ((UpdateOperation)obj).getUpdateRequests();
            return this.getFilter(writeRequestList);
        }
        if (obj instanceof CreateCollectionOperation) {
            String filter = ((CreateCollectionOperation)obj).getCollectionName();
            return this.limitFilter(filter);
        }
        if (obj instanceof CreateIndexesOperation) {
            List filter = ((CreateIndexesOperation)obj).getIndexNames();
            return this.limitFilter(filter.toString());
        }
        if (obj instanceof CreateViewOperation) {
            String filter = ((CreateViewOperation)obj).getViewName();
            return this.limitFilter(filter);
        }
        if (obj instanceof FindAndDeleteOperation) {
            BsonDocument filter = ((FindAndDeleteOperation)obj).getFilter();
            return this.limitFilter(filter.toString());
        }
        if (obj instanceof FindAndReplaceOperation) {
            BsonDocument filter = ((FindAndReplaceOperation)obj).getFilter();
            return this.limitFilter(filter.toString());
        }
        if (obj instanceof FindAndUpdateOperation) {
            BsonDocument filter = ((FindAndUpdateOperation)obj).getFilter();
            return this.limitFilter(filter.toString());
        }
        if (obj instanceof MapReduceToCollectionOperation) {
            BsonDocument filter = ((MapReduceToCollectionOperation)obj).getFilter();
            return this.limitFilter(filter.toString());
        }
        if (obj instanceof MixedBulkWriteOperation) {
            List writeRequestList = ((MixedBulkWriteOperation)obj).getWriteRequests();
            return this.getFilter(writeRequestList);
        }
        return EMPTY;
    }

    private String getFilter(List<? extends WriteRequest> writeRequestList) {
        StringBuilder params = new StringBuilder();
        for (WriteRequest writeRequest : writeRequestList) {
            if (writeRequest instanceof InsertRequest) {
                params.append(((InsertRequest)writeRequest).getDocument().toString()).append(",");
            } else if (writeRequest instanceof DeleteRequest) {
                params.append(((DeleteRequest)writeRequest).getFilter()).append(",");
            } else if (writeRequest instanceof UpdateRequest) {
                params.append(((UpdateRequest)writeRequest).getFilter()).append(",");
            }
            if (params.length() <= 256) continue;
            params.append("...");
            break;
        }
        return params.toString();
    }

    private String limitFilter(String filter) {
        StringBuilder params = new StringBuilder();
        if (filter.length() > 256) {
            return params.append(filter.substring(0, 256)).append("...").toString();
        }
        return filter;
    }

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        Object[] arguments = allArguments;
        String executeMethod = arguments[0].getClass().getSimpleName();
        String remotePeer = (String)objInst.getSkyWalkingDynamicField();
        AbstractSpan span = ContextManager.createExitSpan((String)(MONGO_DB_OP_PREFIX + executeMethod), (ContextCarrier)new ContextCarrier(), (String)remotePeer);
        span.setComponent((Component)ComponentsDefine.MONGO_DRIVER);
        Tags.DB_TYPE.set(span, DB_TYPE);
        SpanLayer.asDB((AbstractSpan)span);
        if (Config.Plugin.MongoDB.TRACE_PARAM) {
            Tags.DB_STATEMENT.set(span, executeMethod + " " + this.getTraceParam(arguments[0]));
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan activeSpan = ContextManager.activeSpan();
        activeSpan.errorOccurred();
        activeSpan.log(t);
    }

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        Cluster cluster = (Cluster)allArguments[0];
        StringBuilder peers = new StringBuilder();
        for (ServerDescription description : cluster.getDescription().getServerDescriptions()) {
            ServerAddress address = description.getAddress();
            peers.append(address.getHost() + ":" + address.getPort() + ";");
        }
        objInst.setSkyWalkingDynamicField((Object)peers.subSequence(0, peers.length() - 1).toString());
    }
}

