/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser;

import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.AbstractURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.H2URLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.ImpalaJdbcURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.KylinJdbcURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.MariadbURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.MssqlJdbcURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.MssqlJtdsURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.MysqlURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.OracleURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.PostgreSQLURLParser;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class URLParser {
    private static final String MYSQL_JDBC_URL_PREFIX = "jdbc:mysql";
    private static final String ORACLE_JDBC_URL_PREFIX = "jdbc:oracle";
    private static final String H2_JDBC_URL_PREFIX = "jdbc:h2";
    private static final String POSTGRESQL_JDBC_URL_PREFIX = "jdbc:postgresql";
    private static final String MARIADB_JDBC_URL_PREFIX = "jdbc:mariadb";
    private static final String MSSQL_JTDS_URL_PREFIX = "jdbc:jtds:sqlserver:";
    private static final String MSSQL_JDBC_URL_PREFIX = "jdbc:sqlserver:";
    private static final String KYLIN_JDBC_URK_PREFIX = "jdbc:kylin";
    private static final String IMPALA_JDBC_URK_PREFIX = "jdbc:impala";

    public static ConnectionInfo parser(String url) {
        AbstractURLParser parser = null;
        String lowerCaseUrl = url.toLowerCase();
        if (lowerCaseUrl.startsWith(MYSQL_JDBC_URL_PREFIX)) {
            parser = new MysqlURLParser(url);
        } else if (lowerCaseUrl.startsWith(ORACLE_JDBC_URL_PREFIX)) {
            parser = new OracleURLParser(url);
        } else if (lowerCaseUrl.startsWith(H2_JDBC_URL_PREFIX)) {
            parser = new H2URLParser(url);
        } else if (lowerCaseUrl.startsWith(POSTGRESQL_JDBC_URL_PREFIX)) {
            parser = new PostgreSQLURLParser(url);
        } else if (lowerCaseUrl.startsWith(MARIADB_JDBC_URL_PREFIX)) {
            parser = new MariadbURLParser(url);
        } else if (lowerCaseUrl.startsWith(MSSQL_JTDS_URL_PREFIX)) {
            parser = new MssqlJtdsURLParser(url);
        } else if (lowerCaseUrl.startsWith(MSSQL_JDBC_URL_PREFIX)) {
            parser = new MssqlJdbcURLParser(url);
        } else if (lowerCaseUrl.startsWith(KYLIN_JDBC_URK_PREFIX)) {
            parser = new KylinJdbcURLParser(url);
        } else if (lowerCaseUrl.startsWith(IMPALA_JDBC_URK_PREFIX)) {
            parser = new ImpalaJdbcURLParser(url);
        }
        return parser.parse();
    }
}

