/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.define;

import java.util.Arrays;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class StatementEnhanceInfos {
    private ConnectionInfo connectionInfo;
    private String statementName;
    private String sql;
    private Object[] parameters;
    private int maxIndex = 0;

    public StatementEnhanceInfos(ConnectionInfo connectionInfo, String sql, String statementName) {
        this.connectionInfo = connectionInfo;
        this.sql = sql;
        this.statementName = statementName;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public String getSql() {
        return this.sql;
    }

    public String getStatementName() {
        return this.statementName;
    }

    public void setParameter(int index, Object parameter) {
        int length;
        this.maxIndex = this.maxIndex > index ? this.maxIndex : index;
        --index;
        if (this.parameters == null) {
            int initialSize = Math.max(20, this.maxIndex);
            this.parameters = new Object[initialSize];
            Arrays.fill(this.parameters, null);
        }
        if (index >= (length = this.parameters.length)) {
            int newSize = Math.max(index + 1, length * 2);
            Object[] newParameters = new Object[newSize];
            System.arraycopy(this.parameters, 0, newParameters, 0, length);
            Arrays.fill(newParameters, length, newSize, null);
            this.parameters = newParameters;
        }
        this.parameters[index] = parameter;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }
}

