/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.session;

import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import org.apache.shiro.lang.util.StringUtils;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.web.servlet.ShiroHttpSession;

public class HttpServletSession
implements Session {
    private static final String HOST_SESSION_KEY = HttpServletSession.class.getName() + ".HOST_SESSION_KEY";
    private static final String TOUCH_OBJECT_SESSION_KEY = HttpServletSession.class.getName() + ".TOUCH_OBJECT_SESSION_KEY";
    private HttpSession httpSession = null;

    public HttpServletSession(HttpSession httpSession, String host) {
        if (httpSession == null) {
            String msg = "HttpSession constructor argument cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (httpSession instanceof ShiroHttpSession) {
            String msg = "HttpSession constructor argument cannot be an instance of ShiroHttpSession.  This is enforced to prevent circular dependencies and infinite loops.";
            throw new IllegalArgumentException(msg);
        }
        this.httpSession = httpSession;
        if (StringUtils.hasText((String)host)) {
            this.setHost(host);
        }
    }

    public Serializable getId() {
        return this.httpSession.getId();
    }

    public Date getStartTimestamp() {
        return new Date(this.httpSession.getCreationTime());
    }

    public Date getLastAccessTime() {
        return new Date(this.httpSession.getLastAccessedTime());
    }

    public long getTimeout() throws InvalidSessionException {
        try {
            return (long)this.httpSession.getMaxInactiveInterval() * 1000L;
        }
        catch (Exception e) {
            throw new InvalidSessionException((Throwable)e);
        }
    }

    public void setTimeout(long maxIdleTimeInMillis) throws InvalidSessionException {
        try {
            int timeout = (int)(maxIdleTimeInMillis / 1000L);
            this.httpSession.setMaxInactiveInterval(timeout);
        }
        catch (Exception e) {
            throw new InvalidSessionException((Throwable)e);
        }
    }

    protected void setHost(String host) {
        this.setAttribute(HOST_SESSION_KEY, host);
    }

    public String getHost() {
        return (String)this.getAttribute(HOST_SESSION_KEY);
    }

    public void touch() throws InvalidSessionException {
        try {
            this.httpSession.setAttribute(TOUCH_OBJECT_SESSION_KEY, (Object)TOUCH_OBJECT_SESSION_KEY);
            this.httpSession.removeAttribute(TOUCH_OBJECT_SESSION_KEY);
        }
        catch (Exception e) {
            throw new InvalidSessionException((Throwable)e);
        }
    }

    public void stop() throws InvalidSessionException {
        try {
            this.httpSession.invalidate();
        }
        catch (Exception e) {
            throw new InvalidSessionException((Throwable)e);
        }
    }

    public Collection<Object> getAttributeKeys() throws InvalidSessionException {
        try {
            Enumeration namesEnum = this.httpSession.getAttributeNames();
            ArrayList keys = null;
            if (namesEnum != null) {
                keys = new ArrayList();
                while (namesEnum.hasMoreElements()) {
                    keys.add(namesEnum.nextElement());
                }
            }
            return keys;
        }
        catch (Exception e) {
            throw new InvalidSessionException((Throwable)e);
        }
    }

    private static String assertString(Object key) {
        if (!(key instanceof String)) {
            String msg = "HttpSession based implementations of the Shiro Session interface requires attribute keys to be String objects.  The HttpSession class does not support anything other than String keys.";
            throw new IllegalArgumentException(msg);
        }
        return (String)key;
    }

    public Object getAttribute(Object key) throws InvalidSessionException {
        try {
            return this.httpSession.getAttribute(HttpServletSession.assertString(key));
        }
        catch (Exception e) {
            throw new InvalidSessionException((Throwable)e);
        }
    }

    public void setAttribute(Object key, Object value) throws InvalidSessionException {
        try {
            this.httpSession.setAttribute(HttpServletSession.assertString(key), value);
        }
        catch (Exception e) {
            throw new InvalidSessionException((Throwable)e);
        }
    }

    public Object removeAttribute(Object key) throws InvalidSessionException {
        try {
            String sKey = HttpServletSession.assertString(key);
            Object removed = this.httpSession.getAttribute(sKey);
            this.httpSession.removeAttribute(sKey);
            return removed;
        }
        catch (Exception e) {
            throw new InvalidSessionException((Throwable)e);
        }
    }
}

