/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.ee.filters;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URLDecoder;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.ee.filters.FormResubmitSupportCookies;
import org.apache.shiro.ee.filters.Forms;
import org.apache.shiro.ee.listeners.EnvironmentLoaderListener;
import org.apache.shiro.ee.util.JakartaTransformer;
import org.apache.shiro.mgt.AbstractRememberMeManager;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionsSecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.util.WebUtils;
import org.jsoup.Jsoup;
import org.jsoup.select.Elements;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Servlets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormResubmitSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FormResubmitSupport.class);
    static final String SHIRO_FORM_DATA_KEY = "org.apache.shiro.form-data-key";
    static final String SESSION_EXPIRED_PARAMETER = "org.apache.shiro.sessionExpired";
    static final String FORM_IS_RESUBMITTED = "org.apache.shiro.form-is-resubmitted";
    private static final String FACES_VIEW_STATE = JakartaTransformer.jakartify("jakarta.faces.ViewState");
    private static final String FACES_VIEW_STATE_EQUALS = FACES_VIEW_STATE + "=";
    private static final Pattern VIEW_STATE_PATTERN = Pattern.compile(String.format("(.*)(%s[-]?[\\d]+:[-]?[\\d]+)(.*)", FACES_VIEW_STATE_EQUALS));
    private static final String PARTIAL_VIEW = JakartaTransformer.jakartify("jakarta.faces.partial");
    private static final Pattern PARTIAL_REQUEST_PATTERN = Pattern.compile(String.format("[\\&]?%s.\\w+=[\\w\\s:%%\\d]*", PARTIAL_VIEW));
    private static final Pattern INITIAL_AMPERSAND = Pattern.compile("^\\&");
    private static final String FORM_DATA_CACHE = "org.apache.shiro.form-data-cache";
    private static final String FORM_RESUBMIT_HOST = "org.apache.shiro.form-resubmit-host";
    private static final String FORM_RESUBMIT_PORT = "org.apache.shiro.form-resubmit-port";
    private static final Optional<String> RESUBMIT_HOST = Optional.ofNullable(System.getProperty("org.apache.shiro.form-resubmit-host"));
    private static final Optional<Integer> RESUBMIT_PORT = Optional.ofNullable(System.getProperty("org.apache.shiro.form-resubmit-port")).map(Integer::valueOf);

    static void savePostDataForResubmit(HttpServletRequest request, HttpServletResponse response, @NonNull String loginUrl) {
        if (loginUrl == null) {
            throw new NullPointerException("loginUrl is marked non-null but is null");
        }
        if (FormResubmitSupport.isPostRequest((ServletRequest)request) && SecurityUtils.isSecurityManagerTypeOf((SecurityManager)SecurityUtils.getSecurityManager(), DefaultSecurityManager.class)) {
            String postData = FormResubmitSupport.getPostData((ServletRequest)request);
            UUID cacheKey = UUID.randomUUID();
            DefaultSecurityManager dsm = (DefaultSecurityManager)SecurityUtils.getSecurityManager(DefaultSecurityManager.class);
            if (dsm.getCacheManager() != null) {
                Cache cache = dsm.getCacheManager().getCache(FORM_DATA_CACHE);
                AbstractRememberMeManager rememberMeManager = (AbstractRememberMeManager)dsm.getRememberMeManager();
                if (rememberMeManager != null && rememberMeManager.getCipherService() != null) {
                    cache.put((Object)cacheKey, (Object)rememberMeManager.getCipherService().encrypt(postData.getBytes(StandardCharsets.UTF_8), rememberMeManager.getEncryptionCipherKey()).getBytes());
                } else {
                    log.warn("Post-data was saved in plain text due to rememberMeManager not being available");
                    cache.put((Object)cacheKey, (Object)postData);
                }
                FormResubmitSupportCookies.addCookie(response, request.getServletContext(), SHIRO_FORM_DATA_KEY, cacheKey.toString(), FormResubmitSupportCookies.getCookieAge((ServletRequest)request, (SecurityManager)dsm));
            } else {
                log.warn("Shiro Cache manager is not configured, cannot store form data");
            }
        }
        boolean isFacesGetRequest = "GET".equalsIgnoreCase(request.getMethod());
        FormResubmitSupport.doFacesRedirect(request, response, request.getContextPath() + loginUrl + (isFacesGetRequest ? "" : "?%s=true"), SESSION_EXPIRED_PARAMETER);
    }

    static boolean isPostRequest(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            return "POST".equalsIgnoreCase(WebUtils.toHttp((ServletRequest)request).getMethod());
        }
        return false;
    }

    static String getPostData(ServletRequest request) {
        return request.getReader().lines().collect(Collectors.joining());
    }

    static String getSavedFormDataFromKey(@NonNull String savedFormDataKey) {
        DefaultSecurityManager dsm;
        if (savedFormDataKey == null) {
            throw new NullPointerException("savedFormDataKey is marked non-null but is null");
        }
        String savedFormData = null;
        if (SecurityUtils.isSecurityManagerTypeOf((SecurityManager)SecurityUtils.getSecurityManager(), DefaultSecurityManager.class) && (dsm = (DefaultSecurityManager)SecurityUtils.getSecurityManager(DefaultSecurityManager.class)).getCacheManager() != null) {
            Cache cache = dsm.getCacheManager().getCache(FORM_DATA_CACHE);
            UUID cacheKey = UUID.fromString(savedFormDataKey);
            AbstractRememberMeManager rememberMeManager = (AbstractRememberMeManager)dsm.getRememberMeManager();
            if (rememberMeManager != null && rememberMeManager.getCipherService() != null) {
                Optional<byte[]> cachedData = Optional.ofNullable((byte[])cache.get((Object)cacheKey));
                savedFormData = cachedData.map(encryptedData -> FormResubmitSupport.decrypt(encryptedData, rememberMeManager)).orElse(savedFormData);
            } else {
                savedFormData = (String)cache.get((Object)cacheKey);
            }
            cache.remove((Object)cacheKey);
        }
        return savedFormData;
    }

    static String decrypt(byte[] encrypted, AbstractRememberMeManager rememberMeManager) {
        return new String(rememberMeManager.getCipherService().decrypt(encrypted, rememberMeManager.getDecryptionCipherKey()).getClonedBytes(), StandardCharsets.UTF_8);
    }

    static void saveRequest(HttpServletRequest request, HttpServletResponse response, boolean useReferer) {
        String path;
        String string = path = useReferer ? FormResubmitSupport.getReferer(request) : Servlets.getRequestURLWithQueryString((HttpServletRequest)request);
        if (path != null) {
            Servlets.addResponseCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"shiroSavedRequest", (String)path, null, (String)request.getContextPath(), (int)FormResubmitSupportCookies.getCookieAge((ServletRequest)request, SecurityUtils.getSecurityManager()));
        }
    }

    static void saveRequestReferer(boolean rv, HttpServletRequest request, HttpServletResponse response) {
        if (rv && "GET".equalsIgnoreCase(request.getMethod()) && Servlets.getRequestCookie((HttpServletRequest)request, (String)"shiroSavedRequest") == null) {
            FormResubmitSupport.saveRequest(request, response, true);
        }
    }

    static String getReferer(HttpServletRequest request) {
        String referer = request.getHeader("referer");
        if (referer != null && !referer.matches("^http:\\/\\/[A-z|.|[0-9]]+:[0-9]+(\\/.*|$)")) {
            referer = referer.replaceFirst("^http:", "https:");
        }
        return referer;
    }

    static void redirectToSaved(HttpServletRequest request, HttpServletResponse response, Forms.FallbackPredicate useFallbackPath, String fallbackPath, boolean resubmit) {
        String savedRequest = Servlets.getRequestCookie((HttpServletRequest)request, (String)"shiroSavedRequest");
        if (savedRequest != null) {
            FormResubmitSupport.doRedirectToSaved(request, response, savedRequest, resubmit);
        } else {
            FormResubmitSupport.redirectToView(request, response, useFallbackPath, fallbackPath);
        }
    }

    static void redirectToSaved(HttpServletRequest request, HttpServletResponse response, Forms.FallbackPredicate useFallbackPath, String fallbackPath) {
        FormResubmitSupport.redirectToSaved(request, response, useFallbackPath, fallbackPath, !EnvironmentLoaderListener.isFormResubmitDisabled(request.getServletContext()));
    }

    private static void doRedirectToSaved(HttpServletRequest request, HttpServletResponse response, @NonNull String savedRequest, boolean resubmit) throws IOException, InterruptedException {
        if (savedRequest == null) {
            throw new NullPointerException("savedRequest is marked non-null but is null");
        }
        FormResubmitSupportCookies.deleteCookie(response, request.getServletContext(), "shiroSavedRequest");
        String savedFormDataKey = Servlets.getRequestCookie((HttpServletRequest)request, (String)SHIRO_FORM_DATA_KEY);
        boolean doRedirectAtEnd = true;
        if (savedFormDataKey != null && resubmit) {
            String formData = FormResubmitSupport.getSavedFormDataFromKey(savedFormDataKey);
            if (formData != null) {
                Optional.ofNullable(FormResubmitSupport.resubmitSavedForm(formData, savedRequest, request, response, request.getServletContext(), false)).ifPresent(path -> FormResubmitSupport.doFacesRedirect(request, response, path, new Object[0]));
                doRedirectAtEnd = false;
            } else {
                FormResubmitSupportCookies.deleteCookie(response, request.getServletContext(), SHIRO_FORM_DATA_KEY);
            }
        }
        if (doRedirectAtEnd) {
            FormResubmitSupport.doFacesRedirect(request, response, savedRequest, new Object[0]);
        }
    }

    static void redirectToView(HttpServletRequest request, HttpServletResponse response) {
        FormResubmitSupport.redirectToView(request, response, (path, req) -> false, null);
    }

    static void redirectToView(HttpServletRequest request, HttpServletResponse response, Forms.FallbackPredicate useFallbackPath, String fallbackPath) {
        boolean useFallback = useFallbackPath.useFallback(request.getRequestURI(), request);
        String referer = FormResubmitSupport.getReferer(request);
        String redirectPath = Servlets.getRequestURLWithQueryString((HttpServletRequest)request);
        if (useFallback && referer != null && !FormResubmitSupport.isLoginUrl(request)) {
            useFallback = useFallbackPath.useFallback(referer, request);
            redirectPath = referer;
        }
        if (useFallback) {
            FormResubmitSupport.doFacesRedirect(request, response, request.getContextPath() + fallbackPath, new Object[0]);
        } else {
            FormResubmitSupport.doFacesRedirect(request, response, redirectPath, new Object[0]);
        }
    }

    private static void doFacesRedirect(HttpServletRequest request, HttpServletResponse response, String path, Object ... paramValues) {
        if (FormResubmitSupport.hasFacesContext()) {
            Faces.redirect((String)path, (Object[])paramValues);
        } else {
            Servlets.facesRedirect((HttpServletRequest)request, (HttpServletResponse)response, (String)path, (Object[])paramValues);
        }
    }

    static boolean hasFacesContext() {
        try {
            return Faces.hasContext();
        }
        catch (Throwable e) {
            return false;
        }
    }

    static boolean isLoginUrl(HttpServletRequest request) {
        String loginUrl = (String)request.getAttribute("org.apache.shiro.ee.login-url");
        return loginUrl != null && request.getRequestURI().equals(request.getContextPath() + loginUrl);
    }

    static String resubmitSavedForm(@NonNull String savedFormData, @NonNull String savedRequest, HttpServletRequest originalRequest, HttpServletResponse originalResponse, ServletContext servletContext, boolean rememberedAjaxResubmit) throws InterruptedException, IOException {
        HttpResponse<String> response;
        PartialAjaxResult decodedFormData;
        if (savedFormData == null) {
            throw new NullPointerException("savedFormData is marked non-null but is null");
        }
        if (savedRequest == null) {
            throw new NullPointerException("savedRequest is marked non-null but is null");
        }
        if (log.isDebugEnabled()) {
            log.debug("saved form data: {}", (Object)savedFormData);
            log.debug("Set Cookie Headers: {}", (Object)originalResponse.getHeaders("Set-Cookie"));
            log.debug("Original Request Headers: {}", Collections.list(originalRequest.getHeaderNames()));
            log.debug("Original Request Cookie Header: {}", Collections.list(originalRequest.getHeaders("Cookie")));
        }
        if (Boolean.TRUE.toString().equals(originalRequest.getHeader(FORM_IS_RESUBMITTED))) {
            log.debug("Form resubmit: internal auth failure");
            originalResponse.setStatus(401);
            return FormResubmitSupport.resubmitResponseCleanup(originalRequest);
        }
        URI overriddenRequestURI = FormResubmitSupport.overrideSavedRequestURI(URI.create(savedRequest));
        HttpClient client = FormResubmitSupport.buildHttpClient(overriddenRequestURI, servletContext, originalRequest);
        try {
            decodedFormData = FormResubmitSupport.parseFormData(savedFormData, overriddenRequestURI, client, servletContext);
            HttpRequest postRequest = FormResubmitSupport.constructPostRequest(overriddenRequestURI, decodedFormData.result);
            response = FormResubmitSupport.sendResubmitRequest(client, postRequest);
        }
        catch (IOException e) {
            log.warn("Unable to resubmit form to {}" + System.lineSeparator() + "perhaps set org.apache.shiro.form-resubmit-host or org.apache.shiro.form-resubmit-port system property?", (Object)overriddenRequestURI, (Object)e);
            return savedRequest;
        }
        if (rememberedAjaxResubmit && !decodedFormData.isStatelessRequest) {
            HttpRequest redirectRequest = FormResubmitSupport.constructPostRequest(overriddenRequestURI, savedFormData);
            HttpResponse<String> redirectResponse = client.send(redirectRequest, HttpResponse.BodyHandlers.ofString());
            log.debug("Redirect request: {}, response: {}", (Object)redirectRequest, redirectResponse);
            return FormResubmitSupport.processResubmitResponse(redirectResponse, originalRequest, originalResponse, response.headers(), savedRequest, servletContext, true, rememberedAjaxResubmit);
        }
        FormResubmitSupportCookies.deleteCookie(originalResponse, servletContext, SHIRO_FORM_DATA_KEY);
        return FormResubmitSupport.processResubmitResponse(response, originalRequest, originalResponse, response.headers(), savedRequest, servletContext, rememberedAjaxResubmit && decodedFormData.isStatelessRequest ? false : decodedFormData.isPartialAjaxRequest, rememberedAjaxResubmit);
    }

    private static URI overrideSavedRequestURI(URI savedRequestURI) {
        if (RESUBMIT_HOST.isPresent() || RESUBMIT_PORT.isPresent()) {
            URI uri = new URI(savedRequestURI.getScheme(), savedRequestURI.getRawUserInfo(), RESUBMIT_HOST.orElse(savedRequestURI.getHost()), RESUBMIT_PORT.orElse(savedRequestURI.getPort()), savedRequestURI.getRawPath(), savedRequestURI.getRawQuery(), savedRequestURI.getRawFragment());
            log.debug("Form Resubmit - Overriding URI {} with {}", (Object)savedRequestURI, (Object)uri);
            return uri;
        }
        return savedRequestURI;
    }

    private static HttpRequest constructPostRequest(URI request, String body) {
        return HttpRequest.newBuilder().uri(request).POST(HttpRequest.BodyPublishers.ofString(body)).headers("Content-Type", "application/x-www-form-urlencoded", FORM_IS_RESUBMITTED, Boolean.TRUE.toString()).build();
    }

    private static HttpResponse<String> sendResubmitRequest(HttpClient client, HttpRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        if (log.isDebugEnabled()) {
            log.debug("Resubmit request: {}, response: {}", (Object)request, response);
            log.debug("Response Headers: {}", response.headers().map());
        }
        if (response.statusCode() == 401) {
            log.debug("processing authfail");
            CookieManager cookieManager = (CookieManager)client.cookieHandler().get();
            FormResubmitSupportCookies.cookieStreamFromHeader(response.headers().allValues("Set-Cookie")).forEach(cookie -> cookieManager.getCookieStore().add(request.uri(), (HttpCookie)cookie));
            response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (log.isDebugEnabled()) {
                log.debug("Resubmit request(authfail): {}, response: {}", (Object)request, response);
                log.debug("Response Headers(authfail): {}", response.headers().map());
            }
        }
        return response;
    }

    private static PartialAjaxResult parseFormData(String savedFormData, URI savedRequest, HttpClient client, ServletContext servletContext) throws IOException, InterruptedException {
        String decodedFormData;
        boolean isStateless = true;
        if (!FormResubmitSupport.isJSFClientStateSavingMethod(servletContext) && FormResubmitSupport.isJSFStatefulForm(decodedFormData = URLDecoder.decode(savedFormData, StandardCharsets.UTF_8))) {
            isStateless = false;
            savedFormData = FormResubmitSupport.getJSFNewViewState(savedRequest, client, decodedFormData);
        }
        return FormResubmitSupport.noJSFAjaxRequests(savedFormData, isStateless);
    }

    private static String processResubmitResponse(HttpResponse<String> response, HttpServletRequest originalRequest, HttpServletResponse originalResponse, HttpHeaders headers, String savedRequest, ServletContext servletContext, boolean isPartialAjaxRequest, boolean rememberedAjaxResubmit) throws IOException {
        switch (response.statusCode()) {
            case 302: {
                if (rememberedAjaxResubmit) {
                    originalResponse.setStatus(200);
                } else {
                    originalResponse.setStatus(response.statusCode());
                    originalResponse.setHeader("Location", response.headers().firstValue("Location").orElseThrow());
                }
            }
            case 200: {
                FormResubmitSupportCookies.transformCookieHeader(headers.allValues("Set-Cookie")).entrySet().stream().filter(Predicate.not(entry -> ((String)entry.getKey()).startsWith(FormResubmitSupportCookies.getSessionCookieName(servletContext, SecurityUtils.getSecurityManager())))).forEach(entry -> FormResubmitSupportCookies.addCookie(originalResponse, servletContext, (String)entry.getKey(), (String)entry.getValue(), -1));
                if (isPartialAjaxRequest) {
                    originalResponse.setHeader("Content-Type", "text/xml");
                    originalResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
                    originalResponse.getWriter().append(String.format("<partial-response><redirect url=\"%s\"></redirect></partial-response>", savedRequest));
                } else {
                    originalResponse.getWriter().append(response.body());
                }
                return FormResubmitSupport.resubmitResponseCleanup(originalRequest);
            }
        }
        return savedRequest;
    }

    private static String resubmitResponseCleanup(HttpServletRequest originalRequest) {
        originalRequest.setAttribute("org.apache.shiro.no-more-cookies", (Object)Boolean.TRUE);
        if (FormResubmitSupport.hasFacesContext()) {
            Faces.responseComplete();
        }
        return null;
    }

    private static HttpClient buildHttpClient(URI savedRequest, ServletContext servletContext, HttpServletRequest originalRequest) {
        CookieManager cookieManager = new CookieManager();
        Session session = SecurityUtils.getSubject().getSession();
        String sessionCookieName = FormResubmitSupportCookies.getSessionCookieName(servletContext, SecurityUtils.getSecurityManager());
        HttpCookie sessionCookie = new HttpCookie(sessionCookieName, session.getId().toString());
        sessionCookie.setPath(servletContext.getContextPath());
        sessionCookie.setVersion(0);
        cookieManager.getCookieStore().add(savedRequest, sessionCookie);
        log.debug("Setting Cookie {}", (Object)sessionCookieName);
        for (Cookie origCookie : originalRequest.getCookies()) {
            if (origCookie.getName().equals(sessionCookieName)) continue;
            try {
                log.debug("Setting Cookie {}", (Object)origCookie.getName());
                HttpCookie cookie = new HttpCookie(origCookie.getName(), origCookie.getValue());
                cookie.setPath(servletContext.getContextPath());
                cookie.setVersion(0);
                cookieManager.getCookieStore().add(savedRequest, cookie);
            }
            catch (IllegalArgumentException e) {
                log.warn("Form Resubmit: Ignoring invalid cookie [{} - {}]", new Object[]{origCookie.getName(), origCookie.getValue(), e});
            }
        }
        return HttpClient.newBuilder().cookieHandler(cookieManager).build();
    }

    public static DefaultWebSessionManager getNativeSessionManager(SecurityManager securityManager) {
        SessionsSecurityManager ssm;
        SessionManager sm;
        DefaultWebSessionManager rv = null;
        SecurityManager unwrapped = SecurityUtils.unwrapSecurityManager((SecurityManager)securityManager, SecurityManager.class, type -> false);
        if (unwrapped instanceof SessionsSecurityManager && (sm = (ssm = (SessionsSecurityManager)unwrapped).getSessionManager()) instanceof DefaultWebSessionManager) {
            rv = (DefaultWebSessionManager)sm;
        }
        return rv;
    }

    private static String getJSFNewViewState(URI savedRequest, HttpClient client, String savedFormData) throws IOException, InterruptedException {
        HttpRequest getRequest = HttpRequest.newBuilder().uri(savedRequest).GET().build();
        HttpResponse<String> htmlResponse = FormResubmitSupport.sendResubmitRequest(client, getRequest);
        if (htmlResponse.statusCode() == 200) {
            savedFormData = FormResubmitSupport.extractJSFNewViewState(htmlResponse.body(), savedFormData);
        }
        return savedFormData;
    }

    static String extractJSFNewViewState(@NonNull String responseBody, @NonNull String savedFormData) {
        if (responseBody == null) {
            throw new NullPointerException("responseBody is marked non-null but is null");
        }
        if (savedFormData == null) {
            throw new NullPointerException("savedFormData is marked non-null but is null");
        }
        Elements elts = Jsoup.parse((String)responseBody).select(String.format("input[name=%s]", FACES_VIEW_STATE));
        if (!elts.isEmpty()) {
            String viewState = elts.first().attr("value");
            Matcher matcher = VIEW_STATE_PATTERN.matcher(savedFormData);
            if (matcher.matches()) {
                savedFormData = matcher.replaceFirst(String.format("$1%s%s$3", FACES_VIEW_STATE_EQUALS, viewState));
                log.debug("Encoded w/Replaced ViewState: {}", (Object)savedFormData);
            }
        }
        return savedFormData;
    }

    static PartialAjaxResult noJSFAjaxRequests(String savedFormData, boolean isStateless) {
        Matcher partialMatcher = PARTIAL_REQUEST_PATTERN.matcher(savedFormData);
        boolean hasPartialAjax = partialMatcher.find();
        return new PartialAjaxResult(isStateless ? savedFormData : INITIAL_AMPERSAND.matcher(partialMatcher.replaceAll("")).replaceFirst(""), hasPartialAjax, isStateless);
    }

    static boolean isJSFStatefulForm(@NonNull String savedFormData) {
        if (savedFormData == null) {
            throw new NullPointerException("savedFormData is marked non-null but is null");
        }
        Matcher matcher = VIEW_STATE_PATTERN.matcher(savedFormData);
        return matcher.find() && matcher.groupCount() >= 2 && !matcher.group(2).equalsIgnoreCase("stateless");
    }

    static boolean isJSFClientStateSavingMethod(ServletContext servletContext) {
        return "client".equals(servletContext.getInitParameter("jakarta.faces.STATE_SAVING_METHOD"));
    }

    @Generated
    private FormResubmitSupport() {
    }

    static class HttpResponseCodes {
        static final int OK = 200;
        static final int FOUND = 302;
        static final int AUTHFAIL = 401;

        HttpResponseCodes() {
        }
    }

    static class MediaType {
        static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
        static final String TEXT_XML = "text/xml";

        MediaType() {
        }
    }

    static class HttpHeaderContstants {
        static final String CONTENT_TYPE = "Content-Type";
        static final String LOCATION = "Location";
        static final String COOKIE = "Cookie";
        static final String SET_COOKIE = "Set-Cookie";

        HttpHeaderContstants() {
        }
    }

    static class HttpMethod {
        static final String GET = "GET";
        static final String POST = "POST";

        HttpMethod() {
        }
    }

    static class PartialAjaxResult {
        public final String result;
        public final boolean isPartialAjaxRequest;
        public final boolean isStatelessRequest;

        @Generated
        public PartialAjaxResult(String result, boolean isPartialAjaxRequest, boolean isStatelessRequest) {
            this.result = result;
            this.isPartialAjaxRequest = isPartialAjaxRequest;
            this.isStatelessRequest = isStatelessRequest;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartialAjaxResult)) {
                return false;
            }
            PartialAjaxResult other = (PartialAjaxResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPartialAjaxRequest != other.isPartialAjaxRequest) {
                return false;
            }
            if (this.isStatelessRequest != other.isStatelessRequest) {
                return false;
            }
            String this$result = this.result;
            String other$result = other.result;
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PartialAjaxResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPartialAjaxRequest ? 79 : 97);
            result = result * 59 + (this.isStatelessRequest ? 79 : 97);
            String $result = this.result;
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FormResubmitSupport.PartialAjaxResult(result=" + this.result + ", isPartialAjaxRequest=" + this.isPartialAjaxRequest + ", isStatelessRequest=" + this.isStatelessRequest + ")";
        }
    }
}

