/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.PrivateModule;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.PreDestroy;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.env.Environment;
import org.apache.shiro.event.EventBus;
import org.apache.shiro.event.EventBusAware;
import org.apache.shiro.event.Subscribe;
import org.apache.shiro.event.support.DefaultEventBus;
import org.apache.shiro.guice.BeanTypeListener;
import org.apache.shiro.guice.DestroyableInjectionListener;
import org.apache.shiro.guice.GuiceEnvironment;
import org.apache.shiro.guice.LifecycleTypeListener;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.util.ClassUtils;
import org.apache.shiro.util.Destroyable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShiroModule
extends PrivateModule
implements Destroyable {
    private final Logger log = LoggerFactory.getLogger(ShiroModule.class);
    private Set<Destroyable> destroyables = Collections.newSetFromMap(new WeakHashMap());

    public void configure() {
        this.bindSecurityManager((AnnotatedBindingBuilder<? super SecurityManager>)this.bind(SecurityManager.class));
        this.bindSessionManager((AnnotatedBindingBuilder<SessionManager>)this.bind(SessionManager.class));
        this.bindEnvironment((AnnotatedBindingBuilder<Environment>)this.bind(Environment.class));
        this.bindListener(BeanTypeListener.MATCHER, new BeanTypeListener());
        this.bindEventBus((AnnotatedBindingBuilder<EventBus>)this.bind(EventBus.class));
        this.bindListener(Matchers.any(), new SubscribedEventTypeListener());
        this.bindListener(Matchers.any(), new EventBusAwareTypeListener());
        DestroyableInjectionListener.DestroyableRegistry registry = new DestroyableInjectionListener.DestroyableRegistry(){

            @Override
            public void add(Destroyable destroyable) {
                ShiroModule.this.add(destroyable);
            }

            @PreDestroy
            public void destroy() {
                ShiroModule.this.destroy();
            }
        };
        this.bindListener(LifecycleTypeListener.MATCHER, new LifecycleTypeListener(registry));
        this.expose(SecurityManager.class);
        this.expose(EventBus.class);
        this.configureShiro();
        this.bind(this.realmCollectionKey()).to(this.realmSetKey());
        this.bind(DestroyableInjectionListener.DestroyableRegistry.class).toInstance((Object)registry);
        BeanTypeListener.ensureBeanTypeMapExists((Binder)this.binder());
    }

    private Key<Set<Realm>> realmSetKey() {
        return Key.get((TypeLiteral)TypeLiteral.get((Type)Types.setOf(Realm.class)));
    }

    private Key<Collection<Realm>> realmCollectionKey() {
        return Key.get((Type)Types.newParameterizedType(Collection.class, (Type[])new Type[]{Realm.class}));
    }

    protected abstract void configureShiro();

    protected final LinkedBindingBuilder<Realm> bindRealm() {
        Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), Realm.class);
        return multibinder.addBinding();
    }

    protected void bindSecurityManager(AnnotatedBindingBuilder<? super SecurityManager> bind) {
        try {
            bind.toConstructor(DefaultSecurityManager.class.getConstructor(Collection.class)).asEagerSingleton();
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("This really shouldn't happen.  Either something has changed in Shiro, or there's a bug in " + ShiroModule.class.getSimpleName(), (Throwable)e);
        }
    }

    protected void bindSessionManager(AnnotatedBindingBuilder<SessionManager> bind) {
        bind.to(DefaultSessionManager.class).asEagerSingleton();
    }

    protected void bindEnvironment(AnnotatedBindingBuilder<Environment> bind) {
        bind.to(GuiceEnvironment.class).asEagerSingleton();
    }

    protected final <T> void bindBeanType(TypeLiteral<T> typeLiteral, Key<? extends T> key) {
        BeanTypeListener.bindBeanType((Binder)this.binder(), typeLiteral, key);
    }

    protected void bindEventBus(AnnotatedBindingBuilder<EventBus> bind) {
        bind.to(DefaultEventBus.class).asEagerSingleton();
    }

    public final void destroy() {
        for (Destroyable destroyable : this.destroyables) {
            try {
                destroyable.destroy();
            }
            catch (Exception e) {
                this.log.warn("Error destroying component class: " + destroyable.getClass(), (Throwable)e);
            }
        }
    }

    public void add(Destroyable destroyable) {
        this.destroyables.add(destroyable);
    }

    private class EventBusAwareTypeListener
    implements TypeListener {
        private EventBusAwareTypeListener() {
        }

        public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
            final Provider eventBusProvider = typeEncounter.getProvider(EventBus.class);
            if (EventBusAware.class.isAssignableFrom(typeLiteral.getRawType())) {
                typeEncounter.register(new InjectionListener<I>(){

                    public void afterInjection(Object o) {
                        ((EventBusAware)o).setEventBus((EventBus)eventBusProvider.get());
                    }
                });
            }
        }
    }

    private class SubscribedEventTypeListener
    implements TypeListener {
        private SubscribedEventTypeListener() {
        }

        public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
            final Provider eventBusProvider = typeEncounter.getProvider(EventBus.class);
            List methods = ClassUtils.getAnnotatedMethods((Class)typeLiteral.getRawType(), Subscribe.class);
            if (methods != null && !methods.isEmpty()) {
                typeEncounter.register(new InjectionListener<I>(){

                    public void afterInjection(Object o) {
                        ((EventBus)eventBusProvider.get()).register(o);
                    }
                });
            }
        }
    }
}

