/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.filter.authz;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.web.filter.authz.PortFilter;

public class SslFilter
extends PortFilter {
    public static final int DEFAULT_HTTPS_PORT = 443;
    public static final String HTTPS_SCHEME = "https";
    private HSTS hsts;

    public SslFilter() {
        this.setPort(443);
        this.hsts = new HSTS();
    }

    public HSTS getHsts() {
        return this.hsts;
    }

    public void setHsts(HSTS hsts) {
        this.hsts = hsts;
    }

    @Override
    protected String getScheme(String requestScheme, int port) {
        if (port == 80) {
            return "http";
        }
        return HTTPS_SCHEME;
    }

    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return super.isAccessAllowed(request, response, mappedValue) && request.isSecure();
    }

    @Override
    protected void postHandle(ServletRequest request, ServletResponse response) {
        if (this.hsts.isEnabled()) {
            StringBuilder directives = new StringBuilder(64).append("max-age=").append(this.hsts.getMaxAge());
            if (this.hsts.isIncludeSubDomains()) {
                directives.append("; includeSubDomains");
            }
            HttpServletResponse resp = (HttpServletResponse)response;
            resp.addHeader("Strict-Transport-Security", directives.toString());
        }
    }

    public class HSTS {
        public static final String HTTP_HEADER = "Strict-Transport-Security";
        public static final boolean DEFAULT_ENABLED = false;
        public static final int DEFAULT_MAX_AGE = 31536000;
        public static final boolean DEFAULT_INCLUDE_SUB_DOMAINS = false;
        private boolean enabled = false;
        private int maxAge = 31536000;
        private boolean includeSubDomains = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int getMaxAge() {
            return this.maxAge;
        }

        public void setMaxAge(int maxAge) {
            this.maxAge = maxAge;
        }

        public boolean isIncludeSubDomains() {
            return this.includeSubDomains;
        }

        public void setIncludeSubDomains(boolean includeSubDomains) {
            this.includeSubDomains = includeSubDomains;
        }
    }
}

