/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.support.hashes.argon2;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.crypto.hash.HashSpi;
import org.apache.shiro.crypto.support.hashes.argon2.Argon2Hash;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.lang.util.SimpleByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Argon2HashProvider
implements HashSpi {
    private static final Logger LOG = LoggerFactory.getLogger(Argon2HashProvider.class);

    public Set<String> getImplementedAlgorithms() {
        return Argon2Hash.getAlgorithmsArgon2();
    }

    public Argon2Hash fromString(String format) {
        return Argon2Hash.fromString(format);
    }

    public HashSpi.HashFactory newHashFactory(Random random) {
        return new Argon2HashFactory(random);
    }

    static class Argon2HashFactory
    implements HashSpi.HashFactory {
        private final SecureRandom random;

        public Argon2HashFactory(Random random) {
            if (!(random instanceof SecureRandom)) {
                throw new IllegalArgumentException("Only SecureRandom instances are supported at the moment!");
            }
            this.random = (SecureRandom)random;
        }

        public Argon2Hash generate(HashRequest hashRequest) {
            String algorithmName = Optional.ofNullable(hashRequest.getParameters().get("Argon2.algorithmName")).map(algo -> (String)algo).orElse("argon2id");
            int version = Optional.ofNullable(hashRequest.getParameters().get("Argon2.version")).flatMap(algoV -> this.intOrEmpty(algoV, "Argon2.version")).orElse(19);
            ByteSource salt = this.parseSalt(hashRequest);
            int iterations = Optional.ofNullable(hashRequest.getParameters().get("Argon2.iterations")).flatMap(algoV -> this.intOrEmpty(algoV, "Argon2.iterations")).orElse(1);
            int memoryKib = Optional.ofNullable(hashRequest.getParameters().get("Argon2.memoryKib")).flatMap(algoV -> this.intOrEmpty(algoV, "Argon2.memoryKib")).orElse(65536);
            int parallelism = Optional.ofNullable(hashRequest.getParameters().get("Argon2.parallelism")).flatMap(algoV -> this.intOrEmpty(algoV, "Argon2.parallelism")).orElse(4);
            int outputLengthBits = Optional.ofNullable(hashRequest.getParameters().get("Argon2.outputLength")).flatMap(algoV -> this.intOrEmpty(algoV, "Argon2.outputLength")).orElse(256);
            return Argon2Hash.generate(algorithmName, version, hashRequest.getSource(), salt, iterations, memoryKib, parallelism, outputLengthBits);
        }

        private ByteSource parseSalt(HashRequest hashRequest) {
            return Optional.ofNullable(hashRequest.getParameters().get("Argon2.salt")).map(saltParm -> Base64.getDecoder().decode((String)saltParm)).map(SimpleByteSource::new).flatMap(this::lengthValidOrEmpty).orElseGet(() -> Argon2Hash.createSalt(this.random));
        }

        private Optional<ByteSource> lengthValidOrEmpty(ByteSource bytes) {
            if (bytes.getBytes().length != 16) {
                return Optional.empty();
            }
            return Optional.of(bytes);
        }

        private Optional<Integer> intOrEmpty(Object maybeInt, String parameterName) {
            try {
                return Optional.of(Integer.parseInt((String)maybeInt, 10));
            }
            catch (NumberFormatException numberFormatException) {
                String message = String.format(Locale.ENGLISH, "Expected Integer for parameter %s, but %s is not parsable.", parameterName, maybeInt);
                LOG.warn(message, (Throwable)numberFormatException);
                return Optional.empty();
            }
        }
    }

    public static final class Parameters {
        public static final String DEFAULT_ALGORITHM_NAME = "argon2id";
        public static final int DEFAULT_ALGORITHM_VERSION = 19;
        public static final int DEFAULT_ITERATIONS = 1;
        public static final int DEFAULT_MEMORY_KIB = 65536;
        public static final int DEFAULT_PARALLELISM = 4;
        public static final int DEFAULT_OUTPUT_LENGTH_BITS = 256;
        public static final String PARAMETER_ALGORITHM_NAME = "Argon2.algorithmName";
        public static final String PARAMETER_ALGORITHM_VERSION = "Argon2.version";
        public static final String PARAMETER_SALT = "Argon2.salt";
        public static final String PARAMETER_ITERATIONS = "Argon2.iterations";
        public static final String PARAMETER_MEMORY_KIB = "Argon2.memoryKib";
        public static final String PARAMETER_PARALLELISM = "Argon2.parallelism";
        public static final String PARAMETER_OUTPUT_LENGTH_BITS = "Argon2.outputLength";

        private Parameters() {
        }
    }
}

