/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.multipart;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.shindig.protocol.multipart.CommonsFormDataItem;
import org.apache.shindig.protocol.multipart.FormDataItem;
import org.apache.shindig.protocol.multipart.MultipartFormParser;

public class DefaultMultipartFormParser
implements MultipartFormParser {
    private static final String MULTIPART = "multipart/";

    @Override
    public Collection<FormDataItem> parse(HttpServletRequest servletRequest) throws IOException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            List fileItems = upload.parseRequest(servletRequest);
            return this.convertToFormData(fileItems);
        }
        catch (FileUploadException e) {
            UnknownServiceException use = new UnknownServiceException("File upload error.");
            use.initCause(e);
            throw use;
        }
    }

    private Collection<FormDataItem> convertToFormData(List<FileItem> fileItems) {
        ArrayList formDataItems = Lists.newArrayListWithCapacity((int)fileItems.size());
        for (FileItem item : fileItems) {
            formDataItems.add(new CommonsFormDataItem(item));
        }
        return formDataItems;
    }

    @Override
    public boolean isMultipartContent(HttpServletRequest request) {
        if (!"POST".equals(request.getMethod())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }
}

