/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class UserAgent {
    private final Browser browser;
    private final String version;
    private static final Pattern VERSION_NUMBER_REGEX = Pattern.compile(".*?([0-9]+(\\.[0-9]+)?).*");

    public UserAgent(Browser browser, String version) {
        this.browser = browser;
        this.version = version;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public String getVersion() {
        return this.version != null ? this.version.trim() : null;
    }

    public double getVersionNumber() {
        Matcher matcher = VERSION_NUMBER_REGEX.matcher(this.getVersion());
        if (!matcher.matches()) {
            return -1.0;
        }
        String matched = matcher.group(1);
        return Double.parseDouble(matched);
    }

    public static enum Browser {
        MSIE,
        FIREFOX,
        SAFARI,
        WEBKIT,
        CHROME,
        OPERA,
        HTML5,
        OTHER;

    }

    public static interface Parser {
        public UserAgent parse(String var1);
    }
}

