/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.cache.ehcache;

import com.google.common.base.Preconditions;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.shindig.common.cache.Cache;

public class EhConfiguredCache<K, V>
implements Cache<K, V> {
    private net.sf.ehcache.Cache cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EhConfiguredCache(String cacheName, CacheManager cacheManager) {
        CacheManager cacheManager2 = cacheManager;
        synchronized (cacheManager2) {
            this.cache = cacheManager.getCache((String)Preconditions.checkNotNull((Object)cacheName));
            if (this.cache == null) {
                cacheManager.addCache(cacheName);
                this.cache = cacheManager.getCache(cacheName);
                if (this.cache == null) {
                    throw new RuntimeException("Failed to create Cache with name " + cacheName);
                }
            }
        }
    }

    @Override
    public void addElement(K key, V value) {
        this.cache.put(new Element(key, value));
    }

    @Override
    public V getElement(K key) {
        Element cacheElement = this.cache.get(key);
        if (cacheElement != null) {
            return (V)cacheElement.getObjectValue();
        }
        return null;
    }

    @Override
    public V removeElement(K key) {
        V value = this.getElement(key);
        this.cache.remove(key);
        return value;
    }

    @Override
    public long getCapacity() {
        long totalCapacity = this.cache.getCacheConfiguration().getMaxEntriesLocalHeap() + this.cache.getCacheConfiguration().getMaxEntriesLocalDisk();
        return totalCapacity == 0L ? -1L : totalCapacity;
    }

    @Override
    public long getSize() {
        return this.cache.getMemoryStoreSize() + (long)this.cache.getDiskStoreSize();
    }
}

