/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.config.ContainerConfigException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonContainerConfigLoader {
    private static final String classname = JsonContainerConfigLoader.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private static final Splitter CRLF_SPLITTER = Splitter.onPattern((String)"[\r\n]+");
    public static final char FILE_SEPARATOR = ',';
    public static final String SERVER_PORT = "SERVER_PORT";
    public static final String SERVER_HOST = "SERVER_HOST";
    public static final String CONTEXT_ROOT = "CONTEXT_ROOT";

    private JsonContainerConfigLoader() {
    }

    public static ContainerConfig.Transaction getTransactionFromFile(String containers, String host, String port, String contextRoot, ContainerConfig containerConfig) throws ContainerConfigException {
        return JsonContainerConfigLoader.addToTransactionFromFile(containers, host, port, contextRoot, containerConfig.newTransaction());
    }

    public static ContainerConfig.Transaction addToTransactionFromFile(String containers, String host, String port, String contextRoot, ContainerConfig.Transaction transaction) throws ContainerConfigException {
        List<Map<String, Object>> config = JsonContainerConfigLoader.loadContainers(containers);
        JsonContainerConfigLoader.addHostAndPortToDefaultContainer(config, host, port, contextRoot);
        JsonContainerConfigLoader.addContainersToTransaction(transaction, config);
        return transaction;
    }

    public static Map<String, Object> parseJsonContainer(JSONObject json) {
        return JsonContainerConfigLoader.jsonToMap(json);
    }

    public static Map<String, Object> parseJsonContainer(String json) throws JSONException {
        return JsonContainerConfigLoader.parseJsonContainer(new JSONObject(json));
    }

    private static List<Map<String, Object>> loadContainers(String path) throws ContainerConfigException {
        ArrayList all = Lists.newArrayList();
        try {
            for (String location : Splitter.on((char)',').split((CharSequence)path)) {
                if (location.startsWith("res://")) {
                    location = location.substring(6);
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.logp(Level.INFO, classname, "loadContainers", "loadResourcesFrom", new Object[]{location});
                    }
                    if (path.endsWith(".txt")) {
                        JsonContainerConfigLoader.loadResources(CRLF_SPLITTER.split((CharSequence)ResourceLoader.getContent(location)), all);
                        continue;
                    }
                    JsonContainerConfigLoader.loadResources((Iterable<String>)ImmutableList.of((Object)location), all);
                    continue;
                }
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.logp(Level.INFO, classname, "loadContainers", "loadFilesFrom", new Object[]{location});
                }
                File file = new File(location);
                JsonContainerConfigLoader.loadFiles(new File[]{file}, all);
            }
            return all;
        }
        catch (IOException e) {
            throw new ContainerConfigException(e);
        }
    }

    private static void loadFiles(File[] files, List<Map<String, Object>> all) throws ContainerConfigException {
        for (File file : files) {
            try {
                if (file == null) continue;
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.logp(Level.INFO, classname, "loadFiles", "readingContainerConfig", new Object[]{file.getName()});
                }
                if (file.isDirectory()) {
                    JsonContainerConfigLoader.loadFiles(file.listFiles(), all);
                    continue;
                }
                if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".js") || file.getName().toLowerCase(Locale.ENGLISH).endsWith(".json")) {
                    if (!file.exists()) {
                        throw new ContainerConfigException("The file '" + file.getAbsolutePath() + "' doesn't exist.");
                    }
                    all.add(JsonContainerConfigLoader.loadFromString(ResourceLoader.getContent(file)));
                    continue;
                }
                if (!LOG.isLoggable(Level.FINEST)) continue;
                LOG.finest(file.getAbsolutePath() + " doesn't seem to be a JS or JSON file.");
            }
            catch (IOException e) {
                throw new ContainerConfigException("The file '" + file.getAbsolutePath() + "' has errors", e);
            }
        }
    }

    private static void loadResources(Iterable<String> files, List<Map<String, Object>> all) throws ContainerConfigException {
        try {
            for (String entry : files) {
                String content;
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.logp(Level.INFO, classname, "loadResources", "readingContainerConfig", new Object[]{entry});
                }
                if ((content = ResourceLoader.getContent(entry)) == null || content.length() == 0) {
                    throw new IOException("The file " + entry + "is empty");
                }
                all.add(JsonContainerConfigLoader.loadFromString(content));
            }
        }
        catch (IOException e) {
            throw new ContainerConfigException(e);
        }
    }

    private static Map<String, Object> loadFromString(String json) throws ContainerConfigException {
        try {
            return JsonContainerConfigLoader.jsonToMap(new JSONObject(json));
        }
        catch (JSONException e) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.logp(Level.WARNING, classname, "loadFromString", "readingContainerConfig", new Object[]{json});
            }
            throw new ContainerConfigException("Trouble parsing " + json, e);
        }
    }

    private static Object jsonToConfig(Object json) {
        if (JSONObject.NULL.equals(json)) {
            return null;
        }
        if (json instanceof CharSequence) {
            return json.toString();
        }
        if (json instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)json;
            ImmutableList.Builder values = ImmutableList.builder();
            int j = jsonArray.length();
            for (int i = 0; i < j; ++i) {
                values.add(JsonContainerConfigLoader.jsonToConfig(jsonArray.opt(i)));
            }
            return values.build();
        }
        if (json instanceof JSONObject) {
            return JsonContainerConfigLoader.jsonToMap((JSONObject)json);
        }
        return json;
    }

    private static Map<String, Object> jsonToMap(JSONObject json) {
        String[] keys = JSONObject.getNames((JSONObject)json);
        if (keys == null) {
            return ImmutableMap.of();
        }
        HashMap<String, Object> values = new HashMap<String, Object>(json.length(), 1.0f);
        for (String key : keys) {
            Object val;
            block5: {
                String stringVal;
                val = JsonContainerConfigLoader.jsonToConfig(json.opt(key));
                if (val instanceof String && ((stringVal = (String)val).startsWith("res://") || stringVal.startsWith("file://"))) {
                    try {
                        val = IOUtils.toString((InputStream)ResourceLoader.open(stringVal), (String)"UTF-8");
                    }
                    catch (IOException e) {
                        if (!LOG.isLoggable(Level.WARNING)) break block5;
                        LOG.logp(Level.WARNING, classname, "jsonToMap", "readingContainerConfig", e);
                    }
                }
            }
            values.put(key, val);
        }
        return Collections.unmodifiableMap(values);
    }

    private static void addHostAndPortToDefaultContainer(List<Map<String, Object>> config, String host, String port, String contextRoot) {
        int j = config.size();
        for (int i = 0; i < j; ++i) {
            Map<String, Object> container = config.get(i);
            List names = (List)container.get("gadgets.container");
            if (names == null || !names.contains("default")) continue;
            HashMap newContainer = Maps.newHashMap();
            newContainer.putAll(container);
            newContainer.put(SERVER_PORT, port);
            newContainer.put(SERVER_HOST, host);
            newContainer.put(CONTEXT_ROOT, contextRoot);
            config.set(i, Collections.unmodifiableMap(newContainer));
        }
    }

    private static void addContainersToTransaction(ContainerConfig.Transaction transaction, List<Map<String, Object>> config) {
        for (Map<String, Object> container : config) {
            transaction.addContainer(container);
        }
    }
}

