/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.mapper.DefaultMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.xstream.StackDriver;
import org.apache.shindig.protocol.conversion.xstream.ThreadSafeWriterStack;
import org.apache.shindig.protocol.conversion.xstream.WriterStack;
import org.apache.shindig.protocol.conversion.xstream.XStreamConfiguration;

public class BeanXStreamConverter
implements BeanConverter {
    public static final String XML_DECL = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final XStreamConfiguration.ConverterSet[] MAPPER_SCOPES = new XStreamConfiguration.ConverterSet[]{XStreamConfiguration.ConverterSet.MAP, XStreamConfiguration.ConverterSet.COLLECTION, XStreamConfiguration.ConverterSet.DEFAULT};
    private static final Logger LOG = Logger.getLogger(BeanXStreamConverter.class.getName());
    protected WriterStack writerStack;
    protected Map<XStreamConfiguration.ConverterSet, XStreamConfiguration.ConverterConfig> converterMap = Maps.newHashMap();

    @Inject
    public BeanXStreamConverter(XStreamConfiguration configuration) {
        PureJavaReflectionProvider rp = new PureJavaReflectionProvider();
        DefaultMapper dmapper = new DefaultMapper(this.getClass().getClassLoader());
        this.writerStack = new ThreadSafeWriterStack();
        StackDriver driver = new StackDriver((HierarchicalStreamDriver)new XppDriver(), this.writerStack, configuration.getNameSpaces());
        for (XStreamConfiguration.ConverterSet c : MAPPER_SCOPES) {
            this.converterMap.put(c, configuration.getConverterConfig(c, (ReflectionProvider)rp, (Mapper)dmapper, driver, this.writerStack));
        }
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    @Override
    public String convertToString(Object pojo) {
        return this.convertToXml(pojo);
    }

    private String convertToXml(Object obj) {
        this.writerStack.reset();
        if (obj instanceof RestfulCollection) {
            XStreamConfiguration.ConverterConfig cc = this.converterMap.get((Object)XStreamConfiguration.ConverterSet.COLLECTION);
            cc.mapper.setBaseObject(obj);
            String result = cc.xstream.toXML(obj);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Result is " + result);
            }
            return XML_DECL + result;
        }
        if (obj instanceof Map) {
            Map m = (Map)obj;
            XStreamConfiguration.ConverterConfig cc = this.converterMap.get((Object)XStreamConfiguration.ConverterSet.MAP);
            if (m.size() == 1) {
                Object s = m.values().iterator().next();
                cc.mapper.setBaseObject(s);
                String result = cc.xstream.toXML(s);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Result is " + result);
                }
                return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><response xmlns=\"http://ns.opensocial.org/2008/opensocial\">" + result + "</response>";
            }
        } else if (obj instanceof DataCollection) {
            XStreamConfiguration.ConverterConfig cc = this.converterMap.get((Object)XStreamConfiguration.ConverterSet.MAP);
            cc.mapper.setBaseObject(obj);
            String result = cc.xstream.toXML(obj);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Result is " + result);
            }
            return XML_DECL + result;
        }
        XStreamConfiguration.ConverterConfig cc = this.converterMap.get((Object)XStreamConfiguration.ConverterSet.DEFAULT);
        cc.mapper.setBaseObject(obj);
        String result = cc.xstream.toXML(obj);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Result is " + result);
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><response xmlns=\"http://ns.opensocial.org/2008/opensocial\">" + result + "</response>";
    }

    @Override
    public <T> T convertToObject(String xml, Class<T> className) {
        XStreamConfiguration.ConverterConfig cc = this.converterMap.get((Object)XStreamConfiguration.ConverterSet.DEFAULT);
        return (T)cc.xstream.fromXML(xml);
    }

    @Override
    public void append(Appendable buf, Object pojo) throws IOException {
        buf.append(this.convertToString(pojo));
    }
}

