/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;

public class UrlParameterAuthenticationHandler
implements AuthenticationHandler {
    private static final String SECURITY_TOKEN_PARAM = "st";
    private final SecurityTokenCodec securityTokenCodec;
    private final Boolean oauthSSLrequired;
    private static final Pattern AUTHORIZATION_REGEX = Pattern.compile("\\s*OAuth2\\s+(\\S*)\\s*.*");

    @Inject
    public UrlParameterAuthenticationHandler(SecurityTokenCodec securityTokenCodec, @Named(value="org.apache.shindig.auth.oauth2-require-ssl") Boolean oauthSSLrequired) {
        this.securityTokenCodec = securityTokenCodec;
        this.oauthSSLrequired = oauthSSLrequired;
    }

    @Override
    public String getName() {
        return AuthenticationMode.SECURITY_TOKEN_URL_PARAMETER.name();
    }

    @Override
    public SecurityToken getSecurityTokenFromRequest(HttpServletRequest request) throws AuthenticationHandler.InvalidAuthenticationException {
        Map<String, String> parameters = this.getMappedParameters(request);
        try {
            if (parameters.get("token") == null) {
                return null;
            }
            return this.securityTokenCodec.createToken(parameters);
        }
        catch (SecurityTokenException e) {
            throw new AuthenticationHandler.InvalidAuthenticationException("Malformed security token " + parameters.get("token"), e);
        }
    }

    @Override
    public String getWWWAuthenticateHeader(String realm) {
        return null;
    }

    protected SecurityTokenCodec getSecurityTokenCodec() {
        return this.securityTokenCodec;
    }

    protected Map<String, String> getMappedParameters(HttpServletRequest request) {
        String t;
        HashMap params = Maps.newHashMap();
        boolean isSecure = this.oauthSSLrequired != false ? request.isSecure() : true;
        String token = request.getParameter(SECURITY_TOKEN_PARAM);
        if (token == null && isSecure && request.getParameter("oauth_signature_method") == null) {
            token = request.getParameter("oauth_token");
        }
        if (token == null && isSecure) {
            Enumeration headers = request.getHeaders("Authorization");
            while (headers != null && headers.hasMoreElements()) {
                Matcher m;
                String authorization = (String)headers.nextElement();
                if (authorization == null || !(m = AUTHORIZATION_REGEX.matcher(authorization)).matches()) continue;
                token = m.group(1);
            }
        }
        if (StringUtils.isEmpty((CharSequence)token) && StringUtils.isNotBlank((CharSequence)(t = request.getHeader("X-Shindig-ST")))) {
            token = t;
        }
        params.put("token", token);
        params.put("activeUrl", this.getActiveUrl(request));
        return params;
    }

    protected String getActiveUrl(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }
}

