/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.loader;

import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.web.loader.ShenyuLoaderResult;
import org.apache.shenyu.web.loader.ShenyuPluginPathBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

public final class ShenyuPluginLoader
extends ClassLoader
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuPluginLoader.class);
    private static volatile ShenyuPluginLoader pluginLoader;
    private final ReentrantLock lock = new ReentrantLock();
    private final List<PluginJar> jars = Lists.newArrayList();
    private final Set<String> names = new HashSet<String>();
    private final Map<String, Class<?>> classCache = new ConcurrentHashMap();

    private ShenyuPluginLoader() {
        super(ShenyuPluginLoader.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ShenyuPluginLoader getInstance() {
        if (null != pluginLoader) return pluginLoader;
        Class<ShenyuPluginLoader> clazz = ShenyuPluginLoader.class;
        synchronized (ShenyuPluginLoader.class) {
            if (null != pluginLoader) return pluginLoader;
            pluginLoader = new ShenyuPluginLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return pluginLoader;
        }
    }

    public List<ShenyuLoaderResult> loadExtendPlugins(String path) throws IOException {
        File[] jarFiles = ShenyuPluginPathBuilder.getPluginFile(path).listFiles(file -> file.getName().endsWith(".jar"));
        if (Objects.isNull(jarFiles)) {
            return Collections.emptyList();
        }
        ArrayList<ShenyuLoaderResult> results = new ArrayList<ShenyuLoaderResult>();
        for (File each : jarFiles) {
            JarFile jar = new JarFile(each, true);
            this.jars.add(new PluginJar(jar, each));
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class") || entryName.contains("$")) continue;
                String className2 = entryName.substring(0, entryName.length() - 6).replaceAll("/", ".");
                this.names.add(className2);
            }
        }
        this.names.forEach(className -> {
            try {
                Object instance = this.getOrCreateSpringBean((String)className);
                if (Objects.nonNull(instance)) {
                    results.add(this.buildResult(instance));
                    LOG.info("The class successfully loaded into a ext-plugin {} is registered as a spring bean", className);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOG.warn("Registering ext-plugins succeeds spring bean fails:{}", className);
            }
        });
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.ability(name)) {
            return this.getParent().loadClass(name);
        }
        Class<?> clazz = this.classCache.get(name);
        if (clazz != null) {
            return clazz;
        }
        ShenyuPluginLoader shenyuPluginLoader = this;
        synchronized (shenyuPluginLoader) {
            clazz = this.classCache.get(name);
            if (clazz == null) {
                String path = this.classNameToPath(name);
                for (PluginJar each : this.jars) {
                    ZipEntry entry = each.jarFile.getEntry(path);
                    if (!Objects.nonNull(entry)) continue;
                    try {
                        int index = name.lastIndexOf(46);
                        if (index != -1) {
                            String packageName = name.substring(0, index);
                            this.definePackageInternal(packageName, each.jarFile.getManifest());
                        }
                        byte[] data = ByteStreams.toByteArray((InputStream)each.jarFile.getInputStream(entry));
                        clazz = this.defineClass(name, data, 0, data.length);
                        this.classCache.put(name, clazz);
                        return clazz;
                    }
                    catch (IOException ex) {
                        LOG.error("Failed to load class {}.", (Object)name, (Object)ex);
                    }
                }
            }
        }
        throw new ClassNotFoundException(String.format("Class name is %s not found.", name));
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        if (this.ability(name)) {
            return this.getParent().getResources(name);
        }
        ArrayList resources = Lists.newArrayList();
        for (PluginJar each : this.jars) {
            JarEntry entry = each.jarFile.getJarEntry(name);
            if (!Objects.nonNull(entry)) continue;
            try {
                resources.add(new URL(String.format("jar:file:%s!/%s", each.sourcePath.getAbsolutePath(), name)));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return Collections.enumeration(resources);
    }

    @Override
    protected URL findResource(String name) {
        if (this.ability(name)) {
            return this.getParent().getResource(name);
        }
        for (PluginJar each : this.jars) {
            JarEntry entry = each.jarFile.getJarEntry(name);
            if (!Objects.nonNull(entry)) continue;
            try {
                return new URL(String.format("jar:file:%s!/%s", each.sourcePath.getAbsolutePath(), name));
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return null;
    }

    @Override
    public void close() {
        for (PluginJar each : this.jars) {
            try {
                each.jarFile.close();
            }
            catch (IOException ex) {
                LOG.error("close shenyu plugin jar is ", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getOrCreateSpringBean(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (SpringBeanUtils.getInstance().existBean(className)) {
            return (T)SpringBeanUtils.getInstance().getBeanByClassName(className);
        }
        this.lock.lock();
        try {
            Object inst = SpringBeanUtils.getInstance().getBeanByClassName(className);
            if (Objects.isNull(inst)) {
                boolean next;
                Class<?> clazz = Class.forName(className, false, this);
                boolean bl = next = ShenyuPlugin.class.isAssignableFrom(clazz) || PluginDataHandler.class.isAssignableFrom(clazz);
                if (!next) {
                    Annotation[] annotations = clazz.getAnnotations();
                    next = Arrays.stream(annotations).anyMatch(e -> e.annotationType().equals(Component.class) || e.annotationType().equals(Service.class));
                }
                if (next) {
                    GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
                    beanDefinition.setBeanClassName(className);
                    beanDefinition.setAutowireCandidate(true);
                    beanDefinition.setRole(2);
                    String beanName = SpringBeanUtils.getInstance().registerBean((BeanDefinition)beanDefinition, (ClassLoader)this);
                    inst = SpringBeanUtils.getInstance().getBeanByClassName(beanName);
                }
            }
            Object object = inst;
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    private ShenyuLoaderResult buildResult(Object instance) {
        ShenyuLoaderResult result = new ShenyuLoaderResult();
        if (instance instanceof ShenyuPlugin) {
            result.setShenyuPlugin((ShenyuPlugin)instance);
        } else if (instance instanceof PluginDataHandler) {
            result.setPluginDataHandler((PluginDataHandler)instance);
        }
        return result;
    }

    private String classNameToPath(String className) {
        return String.join((CharSequence)"", className.replace(".", "/"), ".class");
    }

    private void definePackageInternal(String packageName, Manifest manifest) {
        if (null != this.getPackage(packageName)) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        String specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
        String specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
        String specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
        String implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        String implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        String implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        this.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
    }

    private boolean ability(String name) {
        return !this.names.contains(name);
    }

    static {
        ShenyuPluginLoader.registerAsParallelCapable();
    }

    private static class PluginJar {
        private final JarFile jarFile;
        private final File sourcePath;

        PluginJar(JarFile jarFile, File sourcePath) {
            this.jarFile = jarFile;
            this.sourcePath = sourcePath;
        }
    }
}

