/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.apache.dubbo.proxy;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.service.GenericException;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.enums.ResultEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.ParamCheckUtils;
import org.apache.shenyu.plugin.apache.dubbo.cache.ApacheDubboConfigCache;
import org.apache.shenyu.plugin.dubbo.common.param.DubboParamResolveService;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ApacheDubboProxyService {
    private final DubboParamResolveService dubboParamResolveService;

    public ApacheDubboProxyService(DubboParamResolveService dubboParamResolveService) {
        this.dubboParamResolveService = dubboParamResolveService;
    }

    public Mono<Object> genericInvoker(String body, MetaData metaData, ServerWebExchange exchange) throws ShenyuException {
        ReferenceConfig<GenericService> reference = ApacheDubboConfigCache.getInstance().get(metaData.getPath());
        if (Objects.isNull(reference) || StringUtils.isEmpty((CharSequence)reference.getInterface())) {
            ApacheDubboConfigCache.getInstance().invalidate(metaData.getPath());
            reference = ApacheDubboConfigCache.getInstance().initRef(metaData);
        }
        GenericService genericService = (GenericService)reference.get();
        Object pair = StringUtils.isBlank((CharSequence)metaData.getParameterTypes()) || ParamCheckUtils.dubboBodyIsEmpty((String)body) ? new ImmutablePair((Object)new String[0], (Object)new Object[0]) : this.dubboParamResolveService.buildParameter(body, metaData.getParameterTypes());
        return Mono.fromFuture((CompletableFuture)this.invokeAsync(genericService, metaData.getMethodName(), (String[])pair.getLeft(), (Object[])pair.getRight()).thenApply(ret -> {
            if (Objects.isNull(ret)) {
                ret = "dubbo has not return value!";
            }
            exchange.getAttributes().put("rpc_result", ret);
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
            return ret;
        })).onErrorMap(exception -> exception instanceof GenericException ? new ShenyuException(((GenericException)exception).getExceptionMessage()) : new ShenyuException(exception));
    }

    private CompletableFuture<Object> invokeAsync(GenericService genericService, String method, String[] parameterTypes, Object[] args) throws GenericException {
        genericService.$invoke(method, parameterTypes, args);
        Future resultFromFuture = RpcContext.getContext().getFuture();
        return resultFromFuture instanceof CompletableFuture ? (CompletableFuture<Object>)resultFromFuture : CompletableFuture.completedFuture(resultFromFuture);
    }
}

