/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.standalone.file;

import com.google.common.base.Strings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.mode.repository.standalone.StandalonePersistRepository;
import org.apache.shardingsphere.mode.repository.standalone.file.FileRepositoryDeleteVisitor;
import org.apache.shardingsphere.mode.repository.standalone.file.FileRepositoryProperties;
import org.apache.shardingsphere.mode.repository.standalone.file.FileRepositoryPropertyKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileRepository
implements StandalonePersistRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileRepository.class);
    private static final String DEFAULT_PERSIST_DIRECTORY = ".shardingsphere";
    private String path;

    public void init(Properties props) {
        FileRepositoryProperties localRepositoryProps = new FileRepositoryProperties(props);
        this.path = Optional.ofNullable(Strings.emptyToNull((String)((String)localRepositoryProps.getValue(FileRepositoryPropertyKey.PATH)))).orElseGet(() -> String.join((CharSequence)"/", System.getProperty("user.home"), DEFAULT_PERSIST_DIRECTORY));
    }

    public String get(String key) {
        if (!Files.exists(Paths.get(this.path, key), new LinkOption[0])) {
            return "";
        }
        try {
            List<String> lines = Files.readAllLines(Paths.get(this.path, key));
            if (!lines.isEmpty()) {
                return lines.size() == 1 ? (String)lines.iterator().next() : lines.stream().map(each -> each + System.lineSeparator()).collect(Collectors.joining());
            }
        }
        catch (IOException ex) {
            log.error("Get file data by key: {} failed", (Object)key, (Object)ex);
        }
        return "";
    }

    public List<String> getChildrenKeys(String key) {
        File file = new File(this.path, key);
        if (!file.exists()) {
            return Collections.emptyList();
        }
        File[] files = file.listFiles();
        return null == files ? Collections.emptyList() : Arrays.stream(files).map(File::getName).collect(Collectors.toList());
    }

    public void persist(String key, String value) {
        File file = new File(this.path, key);
        if (Strings.isNullOrEmpty((String)value)) {
            file.mkdirs();
            return;
        }
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(this.path, key), new OpenOption[0]);){
            bufferedWriter.write(value);
            bufferedWriter.flush();
        }
        catch (IOException ex) {
            log.error("Persist file data to key: {} failed", (Object)key, (Object)ex);
        }
    }

    public void delete(String key) {
        try {
            Files.walkFileTree(Paths.get(this.path, key), new FileRepositoryDeleteVisitor());
        }
        catch (IOException ex) {
            log.error("Delete file data by key: {} failed", (Object)key, (Object)ex);
        }
    }

    public void close() {
    }

    public boolean isDefault() {
        return true;
    }

    public String getType() {
        return "File";
    }
}

