/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.impl;

import java.util.LinkedList;
import java.util.Properties;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.DALSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementParser;
import org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.impl.PostgreSQLStatementSQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.VariableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dal.PostgreSQLAnalyzeTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dal.PostgreSQLExplainStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dal.PostgreSQLLoadStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dal.PostgreSQLResetParameterStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dal.PostgreSQLSetStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dal.PostgreSQLShowStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dal.PostgreSQLVacuumStatement;

public final class PostgreSQLDALStatementSQLVisitor
extends PostgreSQLStatementSQLVisitor
implements DALSQLVisitor,
SQLStatementVisitor {
    public PostgreSQLDALStatementSQLVisitor(Properties props) {
        super(props);
    }

    @Override
    public ASTNode visitShow(PostgreSQLStatementParser.ShowContext ctx) {
        return new PostgreSQLShowStatement();
    }

    @Override
    public ASTNode visitSet(PostgreSQLStatementParser.SetContext ctx) {
        PostgreSQLSetStatement result = new PostgreSQLSetStatement();
        LinkedList<VariableAssignSegment> variableAssigns = new LinkedList<VariableAssignSegment>();
        if (null != ctx.configurationParameterClause()) {
            VariableAssignSegment variableAssignSegment = (VariableAssignSegment)this.visit((ParseTree)ctx.configurationParameterClause());
            if (null != ctx.runtimeScope()) {
                variableAssignSegment.getVariable().setScope(ctx.runtimeScope().getText());
            }
            variableAssigns.add(variableAssignSegment);
            result.getVariableAssigns().addAll(variableAssigns);
        }
        return result;
    }

    @Override
    public ASTNode visitConfigurationParameterClause(PostgreSQLStatementParser.ConfigurationParameterClauseContext ctx) {
        VariableAssignSegment result = new VariableAssignSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        VariableSegment variable = new VariableSegment();
        variable.setStartIndex(ctx.varName().start.getStartIndex());
        variable.setStopIndex(ctx.varName().stop.getStopIndex());
        variable.setVariable(ctx.varName().getText());
        result.setVariable(variable);
        if (null != ctx.varList()) {
            result.setAssignValue(ctx.varList().getText());
        }
        if (null != ctx.DEFAULT()) {
            result.setAssignValue(ctx.DEFAULT().getText());
        }
        return result;
    }

    @Override
    public ASTNode visitResetParameter(PostgreSQLStatementParser.ResetParameterContext ctx) {
        return new PostgreSQLResetParameterStatement();
    }

    @Override
    public ASTNode visitAnalyzeTable(PostgreSQLStatementParser.AnalyzeTableContext ctx) {
        PostgreSQLAnalyzeTableStatement result = new PostgreSQLAnalyzeTableStatement();
        if (null != ctx.vacuumRelationList()) {
            result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.vacuumRelationList())).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitVacuumRelationList(PostgreSQLStatementParser.VacuumRelationListContext ctx) {
        CollectionValue result = new CollectionValue();
        for (PostgreSQLStatementParser.VacuumRelationContext each : ctx.vacuumRelation()) {
            PostgreSQLStatementParser.ColIdContext colId = each.qualifiedName().colId();
            TableNameSegment tableName = new TableNameSegment(colId.start.getStartIndex(), colId.stop.getStopIndex(), new IdentifierValue(colId.getText()));
            result.getValue().add(new SimpleTableSegment(tableName));
        }
        return result;
    }

    @Override
    public ASTNode visitLoad(PostgreSQLStatementParser.LoadContext ctx) {
        return new PostgreSQLLoadStatement();
    }

    @Override
    public ASTNode visitVacuum(PostgreSQLStatementParser.VacuumContext ctx) {
        return new PostgreSQLVacuumStatement();
    }

    @Override
    public ASTNode visitExplain(PostgreSQLStatementParser.ExplainContext ctx) {
        PostgreSQLExplainStatement result = new PostgreSQLExplainStatement();
        result.setStatement((SQLStatement)this.visit((ParseTree)ctx.explainableStmt()));
        return result;
    }

    @Override
    public ASTNode visitExplainableStmt(PostgreSQLStatementParser.ExplainableStmtContext ctx) {
        if (null != ctx.select()) {
            return (ASTNode)this.visit((ParseTree)ctx.select());
        }
        if (null != ctx.insert()) {
            return (ASTNode)this.visit((ParseTree)ctx.insert());
        }
        if (null != ctx.update()) {
            return (ASTNode)this.visit((ParseTree)ctx.update());
        }
        if (null != ctx.delete()) {
            return (ASTNode)this.visit((ParseTree)ctx.delete());
        }
        if (null != ctx.declare()) {
            return (ASTNode)this.visit((ParseTree)ctx.declare());
        }
        if (null != ctx.executeStmt()) {
            return (ASTNode)this.visit((ParseTree)ctx.executeStmt());
        }
        if (null != ctx.createMaterializedView()) {
            return (ASTNode)this.visit((ParseTree)ctx.createMaterializedView());
        }
        return (ASTNode)this.visit((ParseTree)ctx.refreshMatViewStmt());
    }

    @Generated
    public PostgreSQLDALStatementSQLVisitor() {
    }
}

