/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.oracle.visitor.statement.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.DMLSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OracleStatementParser;
import org.apache.shardingsphere.sql.parser.oracle.visitor.statement.impl.OracleStatementSQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.CommonTableExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.LockSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.DeleteMultiTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dml.OracleDeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dml.OracleInsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dml.OracleMergeStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dml.OracleSelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dml.OracleUpdateStatement;

public final class OracleDMLStatementSQLVisitor
extends OracleStatementSQLVisitor
implements DMLSQLVisitor,
SQLStatementVisitor {
    public OracleDMLStatementSQLVisitor(Properties props) {
        super(props);
    }

    @Override
    public ASTNode visitInsert(OracleStatementParser.InsertContext ctx) {
        if (null != ctx.insertSingleTable()) {
            OracleInsertStatement result = (OracleInsertStatement)this.visit((ParseTree)ctx.insertSingleTable().insertValuesClause());
            result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.insertSingleTable().insertIntoClause().tableName()));
            result.setParameterCount(this.getCurrentParameterIndex());
            return result;
        }
        return new OracleInsertStatement();
    }

    @Override
    public ASTNode visitInsertValuesClause(OracleStatementParser.InsertValuesClauseContext ctx) {
        OracleInsertStatement result = new OracleInsertStatement();
        if (null != ctx.columnNames()) {
            OracleStatementParser.ColumnNamesContext columnNames = ctx.columnNames();
            CollectionValue columnSegments = (CollectionValue)this.visit((ParseTree)columnNames);
            result.setInsertColumns(new InsertColumnsSegment(columnNames.start.getStartIndex(), columnNames.stop.getStopIndex(), columnSegments.getValue()));
        } else {
            result.setInsertColumns(new InsertColumnsSegment(ctx.start.getStartIndex() - 1, ctx.start.getStartIndex() - 1, Collections.emptyList()));
        }
        result.getValues().addAll(this.createInsertValuesSegments(ctx.assignmentValues()));
        return result;
    }

    private Collection<InsertValuesSegment> createInsertValuesSegments(Collection<OracleStatementParser.AssignmentValuesContext> assignmentValuesContexts) {
        LinkedList<InsertValuesSegment> result = new LinkedList<InsertValuesSegment>();
        for (OracleStatementParser.AssignmentValuesContext each : assignmentValuesContexts) {
            result.add((InsertValuesSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitUpdate(OracleStatementParser.UpdateContext ctx) {
        OracleUpdateStatement result = new OracleUpdateStatement();
        result.setTableSegment((TableSegment)this.visit((ParseTree)ctx.tableReferences()));
        result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.setAssignmentsClause()));
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        result.setParameterCount(this.getCurrentParameterIndex());
        return result;
    }

    @Override
    public ASTNode visitSetAssignmentsClause(OracleStatementParser.SetAssignmentsClauseContext ctx) {
        LinkedList<AssignmentSegment> assignments = new LinkedList<AssignmentSegment>();
        for (OracleStatementParser.AssignmentContext each : ctx.assignment()) {
            assignments.add((AssignmentSegment)this.visit((ParseTree)each));
        }
        return new SetAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), assignments);
    }

    @Override
    public ASTNode visitAssignmentValues(OracleStatementParser.AssignmentValuesContext ctx) {
        LinkedList<ExpressionSegment> segments = new LinkedList<ExpressionSegment>();
        for (OracleStatementParser.AssignmentValueContext each : ctx.assignmentValue()) {
            segments.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return new InsertValuesSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), segments);
    }

    @Override
    public ASTNode visitAssignment(OracleStatementParser.AssignmentContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visitColumnName(ctx.columnName());
        ExpressionSegment value = (ExpressionSegment)this.visit((ParseTree)ctx.assignmentValue());
        return new AssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, value);
    }

    @Override
    public ASTNode visitAssignmentValue(OracleStatementParser.AssignmentValueContext ctx) {
        OracleStatementParser.ExprContext expr = ctx.expr();
        if (null != expr) {
            return (ASTNode)this.visit((ParseTree)expr);
        }
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public ASTNode visitDelete(OracleStatementParser.DeleteContext ctx) {
        OracleDeleteStatement result = new OracleDeleteStatement();
        if (null != ctx.multipleTablesClause()) {
            result.setTableSegment((TableSegment)this.visit((ParseTree)ctx.multipleTablesClause()));
        } else {
            result.setTableSegment((TableSegment)this.visit((ParseTree)ctx.singleTableClause()));
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        result.setParameterCount(this.getCurrentParameterIndex());
        return result;
    }

    @Override
    public ASTNode visitSingleTableClause(OracleStatementParser.SingleTableClauseContext ctx) {
        SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
        if (null != ctx.alias()) {
            result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        return result;
    }

    @Override
    public ASTNode visitMultipleTablesClause(OracleStatementParser.MultipleTablesClauseContext ctx) {
        DeleteMultiTableSegment result = new DeleteMultiTableSegment();
        TableSegment relateTableSource = (TableSegment)this.visit((ParseTree)ctx.tableReferences());
        result.setRelationTable(relateTableSource);
        result.setActualDeleteTables(this.generateTablesFromTableMultipleTableNames(ctx.multipleTableNames()));
        return result;
    }

    private List<SimpleTableSegment> generateTablesFromTableMultipleTableNames(OracleStatementParser.MultipleTableNamesContext ctx) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (OracleStatementParser.TableNameContext each : ctx.tableName()) {
            result.add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitSelect(OracleStatementParser.SelectContext ctx) {
        OracleSelectStatement result = (OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery());
        result.setParameterCount(this.getCurrentParameterIndex());
        if (null != ctx.forUpdateClause()) {
            result.setLock((LockSegment)this.visit((ParseTree)ctx.forUpdateClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitUnionClause(OracleStatementParser.UnionClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.queryBlock(0));
    }

    @Override
    public ASTNode visitSelectSubquery(OracleStatementParser.SelectSubqueryContext ctx) {
        OracleSelectStatement result = null != ctx.queryBlock() ? (OracleSelectStatement)this.visit((ParseTree)ctx.queryBlock()) : (null != ctx.selectUnionClause() ? (OracleSelectStatement)this.visit((ParseTree)ctx.selectUnionClause()) : (OracleSelectStatement)this.visit((ParseTree)ctx.parenthesisSelectSubquery()));
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitQueryBlock(OracleStatementParser.QueryBlockContext ctx) {
        OracleSelectStatement result = new OracleSelectStatement();
        result.setProjections((ProjectionsSegment)this.visit((ParseTree)ctx.projections()));
        if (null != ctx.withClause()) {
            result.setWithSegment((WithSegment)this.visit((ParseTree)ctx.withClause()));
        }
        if (null != ctx.duplicateSpecification()) {
            result.getProjections().setDistinctRow(this.isDistinct(ctx));
        }
        if (null != ctx.fromClause()) {
            TableSegment tableSegment = (TableSegment)this.visit((ParseTree)ctx.fromClause());
            result.setFrom(tableSegment);
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.groupByClause()) {
            result.setGroupBy((GroupBySegment)this.visit((ParseTree)ctx.groupByClause()));
        }
        if (null != ctx.havingClause()) {
            result.setHaving((HavingSegment)this.visit((ParseTree)ctx.havingClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitHavingClause(OracleStatementParser.HavingClauseContext ctx) {
        ExpressionSegment expr = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
        return new HavingSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), expr);
    }

    @Override
    public ASTNode visitSelectUnionClause(OracleStatementParser.SelectUnionClauseContext ctx) {
        OracleSelectStatement result = null != ctx.queryBlock() ? (OracleSelectStatement)this.visit((ParseTree)ctx.queryBlock()) : (OracleSelectStatement)this.visit((ParseTree)ctx.parenthesisSelectSubquery());
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        for (OracleStatementParser.SelectSubqueryContext each : ctx.selectSubquery()) {
            this.visit((ParseTree)each);
        }
        return result;
    }

    @Override
    public ASTNode visitParenthesisSelectSubquery(OracleStatementParser.ParenthesisSelectSubqueryContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.selectSubquery());
    }

    @Override
    public ASTNode visitWithClause(OracleStatementParser.WithClauseContext ctx) {
        LinkedList<CommonTableExpressionSegment> commonTableExpressions = new LinkedList<CommonTableExpressionSegment>();
        if (null != ctx.subqueryFactoringClause()) {
            for (OracleStatementParser.SubqueryFactoringClauseContext each : ctx.subqueryFactoringClause()) {
                SubquerySegment subquery = new SubquerySegment(each.selectSubquery().start.getStartIndex(), each.selectSubquery().stop.getStopIndex(), (SelectStatement)((OracleSelectStatement)this.visit((ParseTree)each)));
                IdentifierValue identifier = (IdentifierValue)this.visit((ParseTree)each.queryName().name().identifier());
                CommonTableExpressionSegment commonTableExpression = new CommonTableExpressionSegment(each.start.getStartIndex(), each.stop.getStopIndex(), identifier, subquery);
                if (null != each.searchClause()) {
                    OracleStatementParser.ColumnNameContext columnName = each.searchClause().orderingColumn().columnName();
                    commonTableExpression.getColumns().add((ColumnSegment)this.visit((ParseTree)columnName));
                }
                commonTableExpressions.add(commonTableExpression);
            }
        }
        return new WithSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), commonTableExpressions);
    }

    @Override
    public ASTNode visitSubqueryFactoringClause(OracleStatementParser.SubqueryFactoringClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.selectSubquery());
    }

    private boolean isDistinct(OracleStatementParser.QueryBlockContext ctx) {
        return ((BooleanLiteralValue)this.visit((ParseTree)ctx.duplicateSpecification())).getValue();
    }

    @Override
    public ASTNode visitDuplicateSpecification(OracleStatementParser.DuplicateSpecificationContext ctx) {
        return new BooleanLiteralValue(null != ctx.DISTINCT());
    }

    @Override
    public ASTNode visitProjections(OracleStatementParser.ProjectionsContext ctx) {
        LinkedList<Object> projections = new LinkedList<Object>();
        if (null != ctx.unqualifiedShorthand()) {
            projections.add(new ShorthandProjectionSegment(ctx.unqualifiedShorthand().getStart().getStartIndex(), ctx.unqualifiedShorthand().getStop().getStopIndex()));
        }
        for (OracleStatementParser.ProjectionContext each : ctx.projection()) {
            projections.add((ProjectionSegment)this.visit((ParseTree)each));
        }
        ProjectionsSegment result = new ProjectionsSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        result.getProjections().addAll(projections);
        return result;
    }

    @Override
    public ASTNode visitProjection(OracleStatementParser.ProjectionContext ctx) {
        AliasSegment alias;
        if (null != ctx.qualifiedShorthand()) {
            OracleStatementParser.QualifiedShorthandContext shorthand = ctx.qualifiedShorthand();
            ShorthandProjectionSegment result = new ShorthandProjectionSegment(shorthand.getStart().getStartIndex(), shorthand.getStop().getStopIndex());
            IdentifierValue identifier = new IdentifierValue(shorthand.identifier().getText());
            result.setOwner(new OwnerSegment(shorthand.identifier().getStart().getStartIndex(), shorthand.identifier().getStop().getStopIndex(), identifier));
            return result;
        }
        AliasSegment aliasSegment = alias = null == ctx.alias() ? null : (AliasSegment)this.visit((ParseTree)ctx.alias());
        if (null != ctx.columnName()) {
            ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
            ColumnProjectionSegment result = new ColumnProjectionSegment(column);
            result.setAlias(alias);
            return result;
        }
        return this.createProjection(ctx, alias);
    }

    @Override
    public ASTNode visitAlias(OracleStatementParser.AliasContext ctx) {
        if (null != ctx.identifier()) {
            return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        }
        return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(ctx.STRING_().getText()));
    }

    private ASTNode createProjection(OracleStatementParser.ProjectionContext ctx, AliasSegment alias) {
        ASTNode projection = (ASTNode)this.visit((ParseTree)ctx.expr());
        if (projection instanceof AggregationProjectionSegment) {
            ((AggregationProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof ExpressionProjectionSegment) {
            ((ExpressionProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof CommonExpressionSegment) {
            CommonExpressionSegment segment = (CommonExpressionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getText());
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof ColumnSegment) {
            ColumnProjectionSegment result = new ColumnProjectionSegment((ColumnSegment)projection);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof SubqueryExpressionSegment) {
            SubqueryExpressionSegment subqueryExpressionSegment = (SubqueryExpressionSegment)projection;
            String text = ctx.start.getInputStream().getText(new Interval(subqueryExpressionSegment.getStartIndex(), subqueryExpressionSegment.getStopIndex()));
            SubqueryProjectionSegment result = new SubqueryProjectionSegment(((SubqueryExpressionSegment)projection).getSubquery(), text);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof BinaryOperationExpression) {
            int startIndex = ((BinaryOperationExpression)projection).getStartIndex();
            int stopIndex = null != alias ? alias.getStopIndex() : ((BinaryOperationExpression)projection).getStopIndex();
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(startIndex, stopIndex, ((BinaryOperationExpression)projection).getText());
            result.setAlias(alias);
            return result;
        }
        LiteralExpressionSegment column = (LiteralExpressionSegment)projection;
        ExpressionProjectionSegment result = null == alias ? new ExpressionProjectionSegment(column.getStartIndex(), column.getStopIndex(), String.valueOf(column.getLiterals())) : new ExpressionProjectionSegment(column.getStartIndex(), ctx.alias().stop.getStopIndex(), String.valueOf(column.getLiterals()));
        result.setAlias(alias);
        return result;
    }

    @Override
    public ASTNode visitFromClause(OracleStatementParser.FromClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableReferences());
    }

    @Override
    public ASTNode visitTableReferences(OracleStatementParser.TableReferencesContext ctx) {
        TableSegment result = (TableSegment)this.visit((ParseTree)ctx.tableReference(0));
        if (ctx.tableReference().size() > 1) {
            for (int i = 1; i < ctx.tableReference().size(); ++i) {
                result = this.generateJoinTableSourceFromTableReference(ctx.tableReference(i), result);
            }
        }
        return result;
    }

    private JoinTableSegment generateJoinTableSourceFromTableReference(OracleStatementParser.TableReferenceContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        result.setLeft(tableSegment);
        result.setRight((TableSegment)this.visit((ParseTree)ctx));
        return result;
    }

    @Override
    public ASTNode visitTableReference(OracleStatementParser.TableReferenceContext ctx) {
        TableSegment left = (TableSegment)this.visit((ParseTree)ctx.tableFactor());
        if (!ctx.joinedTable().isEmpty()) {
            for (OracleStatementParser.JoinedTableContext each : ctx.joinedTable()) {
                left = this.visitJoinedTable(each, left);
            }
        }
        TableSegment result = left;
        return result;
    }

    @Override
    public ASTNode visitTableFactor(OracleStatementParser.TableFactorContext ctx) {
        if (null != ctx.subquery()) {
            OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.subquery());
            SubquerySegment subquerySegment = new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)subquery);
            SubqueryTableSegment result = new SubqueryTableSegment(subquerySegment);
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.tableName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        return (ASTNode)this.visit((ParseTree)ctx.tableReferences());
    }

    private JoinTableSegment visitJoinedTable(OracleStatementParser.JoinedTableContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setLeft(tableSegment);
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        TableSegment right = (TableSegment)this.visit((ParseTree)ctx.tableFactor());
        result.setRight(right);
        if (null != ctx.joinSpecification()) {
            result = this.visitJoinSpecification(ctx.joinSpecification(), result);
        }
        return result;
    }

    private JoinTableSegment visitJoinSpecification(OracleStatementParser.JoinSpecificationContext ctx, JoinTableSegment joinTableSource) {
        if (null != ctx.expr()) {
            ExpressionSegment condition = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
            joinTableSource.setCondition(condition);
        }
        if (null != ctx.USING()) {
            LinkedList<ColumnSegment> columnSegmentList = new LinkedList<ColumnSegment>();
            for (OracleStatementParser.ColumnNameContext cname : ctx.columnNames().columnName()) {
                columnSegmentList.add((ColumnSegment)this.visit((ParseTree)cname));
            }
            joinTableSource.setUsing(columnSegmentList);
        }
        return joinTableSource;
    }

    @Override
    public ASTNode visitWhereClause(OracleStatementParser.WhereClauseContext ctx) {
        ASTNode segment = (ASTNode)this.visit((ParseTree)ctx.expr());
        return new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ExpressionSegment)segment);
    }

    @Override
    public ASTNode visitGroupByClause(OracleStatementParser.GroupByClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (OracleStatementParser.OrderByItemContext each : ctx.orderByItem()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
        }
        return new GroupBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }

    @Override
    public ASTNode visitSubquery(OracleStatementParser.SubqueryContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.selectSubquery());
    }

    @Override
    public ASTNode visitForUpdateClause(OracleStatementParser.ForUpdateClauseContext ctx) {
        LockSegment result = new LockSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.forUpdateClauseList()) {
            result.getTables().addAll(this.generateTablesFromforUpdateClauseOption(ctx.forUpdateClauseList()));
            result.getColumns().addAll(this.generateColumnsFromforUpdateClauseOption(ctx.forUpdateClauseList()));
        }
        return result;
    }

    private List<SimpleTableSegment> generateTablesFromforUpdateClauseOption(OracleStatementParser.ForUpdateClauseListContext ctx) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (OracleStatementParser.ForUpdateClauseOptionContext each : ctx.forUpdateClauseOption()) {
            if (null == each.tableName()) continue;
            result.add((SimpleTableSegment)this.visit((ParseTree)each.tableName()));
        }
        return result;
    }

    private List<ColumnSegment> generateColumnsFromforUpdateClauseOption(OracleStatementParser.ForUpdateClauseListContext ctx) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (OracleStatementParser.ForUpdateClauseOptionContext each : ctx.forUpdateClauseOption()) {
            if (null == each.columnName()) continue;
            result.add((ColumnSegment)this.visit((ParseTree)each.columnName()));
        }
        return result;
    }

    @Override
    public ASTNode visitMerge(OracleStatementParser.MergeContext ctx) {
        OracleMergeStatement result = new OracleMergeStatement();
        result.setTarget((TableSegment)((SimpleTableSegment)this.visit((ParseTree)ctx.intoClause())));
        result.setSource((TableSegment)this.visit((ParseTree)ctx.usingClause()));
        result.setExpr((ExpressionSegment)this.visit((ParseTree)ctx.usingClause().expr()));
        if (null != ctx.mergeUpdateClause()) {
            result.getUpdate().setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.mergeUpdateClause().mergeSetAssignmentsClause()));
            if (null != ctx.mergeUpdateClause().whereClause()) {
                result.getUpdate().setWhere((WhereSegment)this.visit((ParseTree)ctx.mergeUpdateClause().whereClause()));
            }
            if (null != ctx.mergeUpdateClause().deleteWhereClause()) {
                result.getDelete().setWhere((WhereSegment)this.visit((ParseTree)ctx.mergeUpdateClause().deleteWhereClause()));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitIntoClause(OracleStatementParser.IntoClauseContext ctx) {
        if (null != ctx.tableName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.viewName());
        if (null != ctx.alias()) {
            result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        return result;
    }

    @Override
    public ASTNode visitUsingClause(OracleStatementParser.UsingClauseContext ctx) {
        if (null != ctx.tableName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.viewName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.viewName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.subquery());
        SubquerySegment subquerySegment = new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)subquery);
        SubqueryTableSegment result = new SubqueryTableSegment(subquerySegment);
        if (null != ctx.alias()) {
            result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        return result;
    }

    @Override
    public ASTNode visitMergeUpdateClause(OracleStatementParser.MergeUpdateClauseContext ctx) {
        OracleMergeStatement result = new OracleMergeStatement();
        result.getUpdate().setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.mergeSetAssignmentsClause()));
        if (null != ctx.whereClause()) {
            result.getUpdate().setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.deleteWhereClause()) {
            result.getDelete().setWhere((WhereSegment)this.visit((ParseTree)ctx.deleteWhereClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitMergeSetAssignmentsClause(OracleStatementParser.MergeSetAssignmentsClauseContext ctx) {
        LinkedList<AssignmentSegment> assignments = new LinkedList<AssignmentSegment>();
        for (OracleStatementParser.MergeAssignmentContext each : ctx.mergeAssignment()) {
            assignments.add((AssignmentSegment)this.visit((ParseTree)each));
        }
        return new SetAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), assignments);
    }

    @Override
    public ASTNode visitMergeAssignment(OracleStatementParser.MergeAssignmentContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visitColumnName(ctx.columnName());
        ExpressionSegment value = (ExpressionSegment)this.visit((ParseTree)ctx.mergeAssignmentValue());
        return new AssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, value);
    }

    @Override
    public ASTNode visitMergeAssignmentValue(OracleStatementParser.MergeAssignmentValueContext ctx) {
        OracleStatementParser.ExprContext expr = ctx.expr();
        if (null != expr) {
            return (ASTNode)this.visit((ParseTree)expr);
        }
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public ASTNode visitDeleteWhereClause(OracleStatementParser.DeleteWhereClauseContext ctx) {
        ASTNode segment = (ASTNode)this.visit((ParseTree)ctx.whereClause().expr());
        return new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ExpressionSegment)segment);
    }

    @Generated
    public OracleDMLStatementSQLVisitor() {
    }
}

