/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.mysql.visitor.statement.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.DDLSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;
import org.apache.shardingsphere.sql.parser.mysql.visitor.statement.impl.MySQLStatementSQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.AlterDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.RenameColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.position.ColumnAfterPositionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.position.ColumnFirstPositionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.position.ColumnPositionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.DropPrimaryKeySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.routine.RoutineBodySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.routine.ValidStatementSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterEventStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterInstanceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterLogfileGroupStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterProcedureStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterServerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateEventStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateLogfileGroupStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateServerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateTriggerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropEventStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropLogfileGroupStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropProcedureStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropServerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropTriggerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLRenameTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLTruncateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLDeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLInsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLSelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLUpdateStatement;

public final class MySQLDDLStatementSQLVisitor
extends MySQLStatementSQLVisitor
implements DDLSQLVisitor,
SQLStatementVisitor {
    @Override
    public ASTNode visitCreateView(MySQLStatementParser.CreateViewContext ctx) {
        MySQLCreateViewStatement result = new MySQLCreateViewStatement();
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.viewName()));
        result.setSelect((SelectStatement)((MySQLSelectStatement)this.visit((ParseTree)ctx.select())));
        return result;
    }

    @Override
    public ASTNode visitAlterView(MySQLStatementParser.AlterViewContext ctx) {
        MySQLAlterViewStatement result = new MySQLAlterViewStatement();
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.viewName()));
        result.setSelect((SelectStatement)((MySQLSelectStatement)this.visit((ParseTree)ctx.select())));
        return result;
    }

    @Override
    public ASTNode visitDropView(MySQLStatementParser.DropViewContext ctx) {
        MySQLDropViewStatement result = new MySQLDropViewStatement();
        result.getViews().addAll(((CollectionValue)this.visit((ParseTree)ctx.viewNames())).getValue());
        return result;
    }

    @Override
    public ASTNode visitCreateDatabase(MySQLStatementParser.CreateDatabaseContext ctx) {
        MySQLCreateDatabaseStatement result = new MySQLCreateDatabaseStatement();
        result.setDatabaseName(ctx.schemaName().getText());
        return result;
    }

    @Override
    public ASTNode visitAlterDatabase(MySQLStatementParser.AlterDatabaseContext ctx) {
        return new MySQLAlterDatabaseStatement();
    }

    @Override
    public ASTNode visitDropDatabase(MySQLStatementParser.DropDatabaseContext ctx) {
        MySQLDropDatabaseStatement result = new MySQLDropDatabaseStatement();
        result.setDatabaseName(ctx.schemaName().getText());
        return result;
    }

    @Override
    public ASTNode visitRenameTableSpecification(MySQLStatementParser.RenameTableSpecificationContext ctx) {
        return new MySQLRenameTableStatement();
    }

    @Override
    public ASTNode visitCreateTable(MySQLStatementParser.CreateTableContext ctx) {
        MySQLCreateTableStatement result = new MySQLCreateTableStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.setNotExisted(null != ctx.notExistClause());
        if (null != ctx.createDefinitionClause()) {
            CollectionValue createDefinitions = (CollectionValue)this.visit((ParseTree)ctx.createDefinitionClause());
            for (CreateDefinitionSegment each : createDefinitions.getValue()) {
                if (each instanceof ColumnDefinitionSegment) {
                    result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitCreateDefinitionClause(MySQLStatementParser.CreateDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.CreateDefinitionContext each : ctx.createDefinition()) {
            if (null != each.columnDefinition()) {
                result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
            if (null != each.constraintDefinition()) {
                result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.constraintDefinition()));
            }
            if (null != each.checkConstraintDefinition()) {
                result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.checkConstraintDefinition()));
            }
            if (null == each.indexDefinition()) continue;
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.indexDefinition()));
        }
        return result;
    }

    @Override
    public ASTNode visitIndexDefinition(MySQLStatementParser.IndexDefinitionContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        CollectionValue columnSegments = (CollectionValue)this.visit((ParseTree)ctx.keyParts());
        result.getIndexColumns().addAll(columnSegments.getValue());
        if (null != ctx.indexName()) {
            result.setIndexName((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateLikeClause(MySQLStatementParser.CreateLikeClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitAlterTable(MySQLStatementParser.AlterTableContext ctx) {
        MySQLAlterTableStatement result = new MySQLAlterTableStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.alterDefinitionClause()) {
            for (AlterDefinitionSegment each : ((CollectionValue)this.visit((ParseTree)ctx.alterDefinitionClause())).getValue()) {
                if (each instanceof AddColumnDefinitionSegment) {
                    result.getAddColumnDefinitions().add((AddColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyColumnDefinitionSegment) {
                    result.getModifyColumnDefinitions().add((ModifyColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropColumnDefinitionSegment) {
                    result.getDropColumnDefinitions().add((DropColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getAddConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAlterDefinitionClause(MySQLStatementParser.AlterDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.AlterSpecificationContext each : ctx.alterSpecification()) {
            ModifyColumnDefinitionSegment modifyColumnDefinition;
            if (null != each.addColumnSpecification()) {
                result.getValue().add((AddColumnDefinitionSegment)this.visit((ParseTree)each.addColumnSpecification()));
            }
            if (null != each.addConstraintSpecification()) {
                result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.addConstraintSpecification().constraintDefinition()));
            }
            if (null != each.changeColumnSpecification()) {
                modifyColumnDefinition = new ModifyColumnDefinitionSegment(each.changeColumnSpecification().getStart().getStartIndex(), each.changeColumnSpecification().getStop().getStopIndex(), (ColumnDefinitionSegment)this.visit((ParseTree)each.changeColumnSpecification().columnDefinition()));
                if (null != each.changeColumnSpecification().firstOrAfterColumn()) {
                    modifyColumnDefinition.setColumnPosition((ColumnPositionSegment)this.visit((ParseTree)each.changeColumnSpecification().firstOrAfterColumn()));
                }
                result.getValue().add(modifyColumnDefinition);
            }
            if (null != each.modifyColumnSpecification()) {
                modifyColumnDefinition = new ModifyColumnDefinitionSegment(each.modifyColumnSpecification().getStart().getStartIndex(), each.modifyColumnSpecification().getStop().getStopIndex(), (ColumnDefinitionSegment)this.visit((ParseTree)each.modifyColumnSpecification().columnDefinition()));
                if (null != each.modifyColumnSpecification().firstOrAfterColumn()) {
                    modifyColumnDefinition.setColumnPosition((ColumnPositionSegment)this.visit((ParseTree)each.modifyColumnSpecification().firstOrAfterColumn()));
                }
                result.getValue().add(modifyColumnDefinition);
            }
            if (null == each.dropColumnSpecification()) continue;
            result.getValue().add((DropColumnDefinitionSegment)this.visit((ParseTree)each.dropColumnSpecification()));
        }
        return result;
    }

    @Override
    public ASTNode visitAddColumnSpecification(MySQLStatementParser.AddColumnSpecificationContext ctx) {
        LinkedList<ColumnDefinitionSegment> columnDefinitions = new LinkedList<ColumnDefinitionSegment>();
        for (MySQLStatementParser.ColumnDefinitionContext each : ctx.columnDefinition()) {
            columnDefinitions.add((ColumnDefinitionSegment)this.visit((ParseTree)each));
        }
        AddColumnDefinitionSegment result = new AddColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnDefinitions);
        if (null != ctx.firstOrAfterColumn()) {
            Preconditions.checkState((1 == columnDefinitions.size() ? 1 : 0) != 0);
            result.setColumnPosition(this.getColumnPositionSegment((ColumnDefinitionSegment)columnDefinitions.iterator().next(), (ColumnPositionSegment)this.visit((ParseTree)ctx.firstOrAfterColumn())));
        }
        return result;
    }

    @Override
    public ASTNode visitColumnDefinition(MySQLStatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        DataTypeSegment dataTypeSegment = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        boolean isPrimaryKey = this.isPrimaryKey(ctx);
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataTypeSegment, isPrimaryKey);
        result.getReferencedTables().addAll(this.getReferencedTables(ctx));
        return result;
    }

    private Collection<SimpleTableSegment> getReferencedTables(MySQLStatementParser.ColumnDefinitionContext ctx) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (MySQLStatementParser.StorageOptionContext storageOptionContext : ctx.storageOption()) {
            if (null == storageOptionContext.dataTypeGenericOption() || null == storageOptionContext.dataTypeGenericOption().referenceDefinition()) continue;
            result.add((SimpleTableSegment)this.visit((ParseTree)storageOptionContext.dataTypeGenericOption().referenceDefinition()));
        }
        for (MySQLStatementParser.GeneratedOptionContext generatedOptionContext : ctx.generatedOption()) {
            if (null == generatedOptionContext.dataTypeGenericOption() || null == generatedOptionContext.dataTypeGenericOption().referenceDefinition()) continue;
            result.add((SimpleTableSegment)this.visit((ParseTree)generatedOptionContext.dataTypeGenericOption().referenceDefinition()));
        }
        return result;
    }

    private boolean isPrimaryKey(MySQLStatementParser.ColumnDefinitionContext ctx) {
        for (MySQLStatementParser.StorageOptionContext storageOptionContext : ctx.storageOption()) {
            if (null == storageOptionContext.dataTypeGenericOption() || null == storageOptionContext.dataTypeGenericOption().primaryKey()) continue;
            return true;
        }
        for (MySQLStatementParser.GeneratedOptionContext generatedOptionContext : ctx.generatedOption()) {
            if (null == generatedOptionContext.dataTypeGenericOption() || null == generatedOptionContext.dataTypeGenericOption().primaryKey()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ASTNode visitConstraintDefinition(MySQLStatementParser.ConstraintDefinitionContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.primaryKeyOption()) {
            result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.primaryKeyOption().keyParts())).getValue());
        }
        if (null != ctx.foreignKeyOption()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.foreignKeyOption()));
        }
        if (null != ctx.uniqueOption()) {
            CollectionValue columnSegments = (CollectionValue)this.visit((ParseTree)ctx.uniqueOption().keyParts());
            result.getIndexColumns().addAll(columnSegments.getValue());
            if (null != ctx.uniqueOption().indexName()) {
                result.setIndexName(new IndexSegment(ctx.uniqueOption().indexName().start.getStartIndex(), ctx.uniqueOption().indexName().stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.uniqueOption().indexName())));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitCheckConstraintDefinition(MySQLStatementParser.CheckConstraintDefinitionContext ctx) {
        return new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
    }

    @Override
    public ASTNode visitChangeColumnSpecification(MySQLStatementParser.ChangeColumnSpecificationContext ctx) {
        return this.extractModifyColumnDefinition(ctx.getStart(), ctx.getStop(), ctx.columnDefinition(), ctx.firstOrAfterColumn());
    }

    @Override
    public ASTNode visitDropColumnSpecification(MySQLStatementParser.DropColumnSpecificationContext ctx) {
        return new DropColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), Collections.singletonList((ColumnSegment)this.visit((ParseTree)ctx.columnName())));
    }

    @Override
    public ASTNode visitDropPrimaryKeySpecification(MySQLStatementParser.DropPrimaryKeySpecificationContext ctx) {
        return new DropPrimaryKeySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
    }

    @Override
    public ASTNode visitModifyColumnSpecification(MySQLStatementParser.ModifyColumnSpecificationContext ctx) {
        return this.extractModifyColumnDefinition(ctx.getStart(), ctx.getStop(), ctx.columnDefinition(), ctx.firstOrAfterColumn());
    }

    @Override
    public ASTNode visitRenameColumnSpecification(MySQLStatementParser.RenameColumnSpecificationContext ctx) {
        return new RenameColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ColumnSegment)this.visit((ParseTree)ctx.columnName(0)), (ColumnSegment)this.visit((ParseTree)ctx.columnName(1)));
    }

    @Override
    public ASTNode visitReferenceDefinition(MySQLStatementParser.ReferenceDefinitionContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitForeignKeyOption(MySQLStatementParser.ForeignKeyOptionContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.referenceDefinition());
    }

    private ModifyColumnDefinitionSegment extractModifyColumnDefinition(Token start, Token stop, MySQLStatementParser.ColumnDefinitionContext columnDefinition, MySQLStatementParser.FirstOrAfterColumnContext firstOrAfterColumn) {
        ModifyColumnDefinitionSegment result = new ModifyColumnDefinitionSegment(start.getStartIndex(), stop.getStopIndex(), (ColumnDefinitionSegment)this.visit((ParseTree)columnDefinition));
        if (null != firstOrAfterColumn) {
            result.setColumnPosition(this.getColumnPositionSegment(result.getColumnDefinition(), (ColumnPositionSegment)this.visit((ParseTree)firstOrAfterColumn)));
        }
        return result;
    }

    @Override
    public ASTNode visitFirstOrAfterColumn(MySQLStatementParser.FirstOrAfterColumnContext ctx) {
        ColumnSegment columnName = null;
        if (null != ctx.columnName()) {
            columnName = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        }
        return null == ctx.columnName() ? new ColumnFirstPositionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnName) : new ColumnAfterPositionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnName);
    }

    private ColumnPositionSegment getColumnPositionSegment(ColumnDefinitionSegment columnDefinition, ColumnPositionSegment columnPosition) {
        return columnPosition instanceof ColumnFirstPositionSegment ? new ColumnFirstPositionSegment(columnPosition.getStartIndex(), columnPosition.getStopIndex(), columnPosition.getColumnName()) : new ColumnAfterPositionSegment(columnPosition.getStartIndex(), columnPosition.getStopIndex(), columnPosition.getColumnName());
    }

    @Override
    public ASTNode visitDropTable(MySQLStatementParser.DropTableContext ctx) {
        MySQLDropTableStatement result = new MySQLDropTableStatement();
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableNames())).getValue());
        return result;
    }

    @Override
    public ASTNode visitTruncateTable(MySQLStatementParser.TruncateTableContext ctx) {
        MySQLTruncateStatement result = new MySQLTruncateStatement();
        result.getTables().add((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitCreateIndex(MySQLStatementParser.CreateIndexContext ctx) {
        MySQLCreateIndexStatement result = new MySQLCreateIndexStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitDropIndex(MySQLStatementParser.DropIndexContext ctx) {
        MySQLDropIndexStatement result = new MySQLDropIndexStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitKeyParts(MySQLStatementParser.KeyPartsContext ctx) {
        CollectionValue result = new CollectionValue();
        List<MySQLStatementParser.KeyPartContext> keyParts = ctx.keyPart();
        for (MySQLStatementParser.KeyPartContext each : keyParts) {
            if (null == each.columnName()) continue;
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each.columnName()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateProcedure(MySQLStatementParser.CreateProcedureContext ctx) {
        MySQLCreateProcedureStatement result = new MySQLCreateProcedureStatement();
        result.setRoutineBody((RoutineBodySegment)this.visit((ParseTree)ctx.routineBody()));
        return result;
    }

    @Override
    public ASTNode visitAlterProcedure(MySQLStatementParser.AlterProcedureContext ctx) {
        return new MySQLAlterProcedureStatement();
    }

    @Override
    public ASTNode visitDropProcedure(MySQLStatementParser.DropProcedureContext ctx) {
        return new MySQLDropProcedureStatement();
    }

    @Override
    public ASTNode visitCreateFunction(MySQLStatementParser.CreateFunctionContext ctx) {
        MySQLCreateFunctionStatement result = new MySQLCreateFunctionStatement();
        result.setRoutineBody((RoutineBodySegment)this.visit((ParseTree)ctx.routineBody()));
        return result;
    }

    @Override
    public ASTNode visitRoutineBody(MySQLStatementParser.RoutineBodyContext ctx) {
        RoutineBodySegment result = new RoutineBodySegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        CollectionValue validStatements = null != ctx.simpleStatement() ? (CollectionValue)this.visit((ParseTree)ctx.simpleStatement()) : (CollectionValue)this.visit((ParseTree)ctx.compoundStatement());
        result.getValidStatements().addAll(validStatements.getValue());
        return result;
    }

    @Override
    public ASTNode visitSimpleStatement(MySQLStatementParser.SimpleStatementContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.validStatement());
    }

    @Override
    public ASTNode visitCompoundStatement(MySQLStatementParser.CompoundStatementContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.beginStatement());
    }

    @Override
    public ASTNode visitBeginStatement(MySQLStatementParser.BeginStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitValidStatement(MySQLStatementParser.ValidStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        ValidStatementSegment validStatement = this.createValidStatementSegment(ctx);
        if (null != validStatement.getSqlStatement()) {
            result.getValue().add(validStatement);
        }
        if (null != ctx.beginStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.beginStatement()));
        }
        if (null != ctx.flowControlStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.flowControlStatement()));
        }
        return result;
    }

    private ValidStatementSegment createValidStatementSegment(MySQLStatementParser.ValidStatementContext ctx) {
        ValidStatementSegment result = new ValidStatementSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        MySQLCreateTableStatement sqlStatement = null;
        if (null != ctx.createTable()) {
            sqlStatement = (MySQLCreateTableStatement)this.visit((ParseTree)ctx.createTable());
        } else if (null != ctx.alterTable()) {
            sqlStatement = (MySQLAlterTableStatement)this.visit((ParseTree)ctx.alterTable());
        } else if (null != ctx.dropTable()) {
            sqlStatement = (MySQLDropTableStatement)this.visit((ParseTree)ctx.dropTable());
        } else if (null != ctx.truncateTable()) {
            sqlStatement = (MySQLTruncateStatement)this.visit((ParseTree)ctx.truncateTable());
        } else if (null != ctx.insert()) {
            sqlStatement = (MySQLInsertStatement)this.visit((ParseTree)ctx.insert());
        } else if (null != ctx.replace()) {
            sqlStatement = (MySQLInsertStatement)this.visit((ParseTree)ctx.replace());
        } else if (null != ctx.update()) {
            sqlStatement = (MySQLUpdateStatement)this.visit((ParseTree)ctx.update());
        } else if (null != ctx.delete()) {
            sqlStatement = (MySQLDeleteStatement)this.visit((ParseTree)ctx.delete());
        } else if (null != ctx.select()) {
            sqlStatement = (MySQLSelectStatement)this.visit((ParseTree)ctx.select());
        }
        result.setSqlStatement((SQLStatement)sqlStatement);
        return result;
    }

    @Override
    public ASTNode visitFlowControlStatement(MySQLStatementParser.FlowControlStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.caseStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.caseStatement()));
        }
        if (null != ctx.ifStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.ifStatement()));
        }
        if (null != ctx.loopStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.loopStatement()));
        }
        if (null != ctx.repeatStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.repeatStatement()));
        }
        if (null != ctx.whileStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.whileStatement()));
        }
        return result;
    }

    @Override
    public ASTNode visitCaseStatement(MySQLStatementParser.CaseStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitIfStatement(MySQLStatementParser.IfStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitLoopStatement(MySQLStatementParser.LoopStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitRepeatStatement(MySQLStatementParser.RepeatStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitWhileStatement(MySQLStatementParser.WhileStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterFunction(MySQLStatementParser.AlterFunctionContext ctx) {
        return new MySQLAlterFunctionStatement();
    }

    @Override
    public ASTNode visitDropFunction(MySQLStatementParser.DropFunctionContext ctx) {
        return new MySQLDropFunctionStatement();
    }

    @Override
    public ASTNode visitCreateEvent(MySQLStatementParser.CreateEventContext ctx) {
        return new MySQLCreateEventStatement();
    }

    @Override
    public ASTNode visitAlterEvent(MySQLStatementParser.AlterEventContext ctx) {
        return new MySQLAlterEventStatement();
    }

    @Override
    public ASTNode visitDropEvent(MySQLStatementParser.DropEventContext ctx) {
        return new MySQLDropEventStatement();
    }

    @Override
    public ASTNode visitAlterInstance(MySQLStatementParser.AlterInstanceContext ctx) {
        return new MySQLAlterInstanceStatement();
    }

    @Override
    public ASTNode visitCreateLogfileGroup(MySQLStatementParser.CreateLogfileGroupContext ctx) {
        return new MySQLCreateLogfileGroupStatement();
    }

    @Override
    public ASTNode visitAlterLogfileGroup(MySQLStatementParser.AlterLogfileGroupContext ctx) {
        return new MySQLAlterLogfileGroupStatement();
    }

    @Override
    public ASTNode visitDropLogfileGroup(MySQLStatementParser.DropLogfileGroupContext ctx) {
        return new MySQLDropLogfileGroupStatement();
    }

    @Override
    public ASTNode visitCreateServer(MySQLStatementParser.CreateServerContext ctx) {
        return new MySQLCreateServerStatement();
    }

    @Override
    public ASTNode visitAlterServer(MySQLStatementParser.AlterServerContext ctx) {
        return new MySQLAlterServerStatement();
    }

    @Override
    public ASTNode visitDropServer(MySQLStatementParser.DropServerContext ctx) {
        return new MySQLDropServerStatement();
    }

    @Override
    public ASTNode visitCreateTrigger(MySQLStatementParser.CreateTriggerContext ctx) {
        return new MySQLCreateTriggerStatement();
    }

    @Override
    public ASTNode visitDropTrigger(MySQLStatementParser.DropTriggerContext ctx) {
        return new MySQLDropTriggerStatement();
    }
}

