/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.parser;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.shardingsphere.sql.parser.spi.SQLParserFacade;

public final class SQLParserFacadeRegistry {
    private static final SQLParserFacadeRegistry INSTANCE = new SQLParserFacadeRegistry();
    private final Map<String, SQLParserFacade> facades = new LinkedHashMap<String, SQLParserFacade>();

    private SQLParserFacadeRegistry() {
        for (SQLParserFacade each : ServiceLoader.load(SQLParserFacade.class)) {
            this.facades.put(each.getDatabaseType(), each);
        }
    }

    public static SQLParserFacadeRegistry getInstance() {
        return INSTANCE;
    }

    public SQLParserFacade getSQLParserFacade(String databaseType) {
        if (this.facades.containsKey(databaseType)) {
            return this.facades.get(databaseType);
        }
        throw new UnsupportedOperationException(String.format("Cannot support database type '%s'", databaseType));
    }
}

