/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.projection.impl;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.ExpressionConverter;

public final class AggregationProjectionConverter
implements SQLSegmentConverter<AggregationProjectionSegment, SqlNode> {
    private static final Map<String, SqlAggFunction> REGISTRY = new TreeMap<String, SqlAggFunction>(String.CASE_INSENSITIVE_ORDER);

    private static void register(SqlAggFunction sqlAggFunction) {
        REGISTRY.put(sqlAggFunction.getName(), sqlAggFunction);
    }

    @Override
    public Optional<SqlNode> convert(AggregationProjectionSegment segment) {
        if (null == segment) {
            return Optional.empty();
        }
        SqlLiteral functionQuantifier = segment instanceof AggregationDistinctProjectionSegment ? SqlLiteral.createSymbol((Enum)SqlSelectKeyword.DISTINCT, (SqlParserPos)SqlParserPos.ZERO) : null;
        SqlAggFunction operator = this.convertOperator(segment.getType().name());
        List<SqlNode> params = this.convertParameters(segment.getParameters(), segment.getInnerExpression());
        SqlBasicCall sqlBasicCall = new SqlBasicCall((SqlOperator)operator, params, SqlParserPos.ZERO, functionQuantifier);
        if (segment.getAlias().isPresent()) {
            return Optional.of(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, Arrays.asList(sqlBasicCall, SqlIdentifier.star(Collections.singletonList((String)segment.getAlias().get()), (SqlParserPos)SqlParserPos.ZERO, Collections.singletonList(SqlParserPos.ZERO))), SqlParserPos.ZERO));
        }
        return Optional.of(sqlBasicCall);
    }

    private SqlAggFunction convertOperator(String operator) {
        Preconditions.checkState((boolean)REGISTRY.containsKey(operator), (String)"Unsupported SQL operator: `%s`", (Object)operator);
        return REGISTRY.get(operator);
    }

    private List<SqlNode> convertParameters(Collection<ExpressionSegment> params, String innerExpression) {
        if (innerExpression.contains("*")) {
            return Collections.singletonList(SqlIdentifier.star((SqlParserPos)SqlParserPos.ZERO));
        }
        LinkedList<SqlNode> result = new LinkedList<SqlNode>();
        ExpressionConverter expressionConverter = new ExpressionConverter();
        for (ExpressionSegment each : params) {
            expressionConverter.convert(each).ifPresent(result::add);
        }
        return result;
    }

    static {
        AggregationProjectionConverter.register(SqlStdOperatorTable.MAX);
        AggregationProjectionConverter.register(SqlStdOperatorTable.MIN);
        AggregationProjectionConverter.register(SqlStdOperatorTable.SUM);
        AggregationProjectionConverter.register(SqlStdOperatorTable.COUNT);
        AggregationProjectionConverter.register(SqlStdOperatorTable.AVG);
        AggregationProjectionConverter.register(SqlStdOperatorTable.BIT_XOR);
    }
}

